/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.aggregators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryMasterType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryStatusTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.StatusType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

public abstract class AggregationStrategy<T> {
    private static final Logger log = Logger.getLogger(AggregationStrategy.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    public final Class<T> resultClass;
    public static final AggregationStrategy<MasterResponseType> UsersToMaster = new AggregationStrategy<MasterResponseType>(MasterResponseType.class){

        @Override
        public void aggregate(MasterResponseType extra, MasterResponseType accumulator, SpinResultEntry originalSpinResult) {
            accumulator.getQueryMaster().addAll(extra.getQueryMaster());
        }

        @Override
        public void aggregateError(MasterResponseType accumulator, SpinResultEntry spinResultEntry) {
        }

        @Override
        public ResponseMessageType packageInResponse(MasterResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            List queryMasterList = toBeWrapped.getQueryMaster();
            1.removeQueryMasterTypeDupesFrom(queryMasterList);
            1.sortQueryMasterTypesByDateDesc(queryMasterList);
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            CRCSerializer.addMasterResponse((ResponseMessageType)response, (MasterResponseType)toBeWrapped);
            return response;
        }

        @Override
        public MasterResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getMasterResponse((ResponseMessageType)response);
        }
    };
    public static final AggregationStrategy<MasterResponseType> MasterResponseType = new AggregationStrategy<MasterResponseType>(MasterResponseType.class){

        @Override
        public void aggregate(MasterResponseType extra, MasterResponseType accumulator, SpinResultEntry originalSpinResult) {
            accumulator.getQueryMaster().addAll(extra.getQueryMaster());
        }

        @Override
        public void aggregateError(MasterResponseType accumulator, SpinResultEntry spinResultEntry) {
        }

        @Override
        public ResponseMessageType packageInResponse(MasterResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            3.removeDupesFrom(toBeWrapped.getQueryMaster());
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            CRCSerializer.addMasterResponse((ResponseMessageType)response, (MasterResponseType)toBeWrapped);
            return response;
        }

        @Override
        public MasterResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getMasterResponse((ResponseMessageType)response);
        }
    };
    public static final AggregationStrategy<InstanceResponseType> InstanceResponseType = new AggregationStrategy<InstanceResponseType>(InstanceResponseType.class){

        @Override
        public void aggregate(InstanceResponseType extra, InstanceResponseType accumulator, SpinResultEntry originalSpinResult) {
            if (DEBUG) {
                log.debug((Object)("Adding " + extra.getQueryInstance() + " to accumulator: " + accumulator.getQueryInstance()));
            }
            accumulator.getQueryInstance().addAll(extra.getQueryInstance());
        }

        @Override
        public void aggregateError(InstanceResponseType accumulator, SpinResultEntry spinResultEntry) {
        }

        @Override
        public ResponseMessageType packageInResponse(InstanceResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            4.removeDupesFrom(toBeWrapped.getQueryInstance());
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            CRCSerializer.addInstanceResponse((ResponseMessageType)response, (InstanceResponseType)toBeWrapped);
            return response;
        }

        @Override
        public InstanceResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getInstanceResponse((ResponseMessageType)response);
        }
    };
    public static final AggregationStrategy<ResultResponseType> ResultResponseType = new AggregationStrategy<ResultResponseType>(ResultResponseType.class){

        @Override
        public void aggregate(ResultResponseType extra, ResultResponseType accumulator, SpinResultEntry originalSpinResult) {
            List queryResultInstances;
            if (DEBUG) {
                log.debug((Object)("Adding " + extra.getQueryResultInstance() + " to accumulator: " + accumulator.getQueryResultInstance()));
            }
            if ((queryResultInstances = extra.getQueryResultInstance()) == null || queryResultInstances.isEmpty()) {
                this.aggregateError(accumulator, originalSpinResult);
            } else {
                for (QueryResultInstanceType queryResultInstance : queryResultInstances) {
                    queryResultInstance.setDescription(originalSpinResult.getSpinResultMetadata().getDescription());
                }
                accumulator.getQueryResultInstance().addAll(queryResultInstances);
            }
        }

        @Override
        public void aggregateError(ResultResponseType accumulator, SpinResultEntry spinResultEntry) {
            QueryResultInstanceType emptyResult = new QueryResultInstanceType();
            QueryStatusTypeType resultStatus = new QueryStatusTypeType();
            resultStatus.setDescription("No results available");
            resultStatus.setName("UNAVAILABLE");
            emptyResult.setQueryStatusType(resultStatus);
            emptyResult.setDescription(spinResultEntry.getSpinResultMetadata().getDescription());
            accumulator.getQueryResultInstance().add(emptyResult);
        }

        @Override
        public ResponseMessageType packageInResponse(ResultResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            this.gatherPatientSets(toBeWrapped.getQueryResultInstance());
            CRCSerializer.addResultResponse((ResponseMessageType)response, (ResultResponseType)toBeWrapped);
            return response;
        }

        @Override
        public ResultResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getResultResponse((ResponseMessageType)response);
        }

        private void gatherPatientSets(List<QueryResultInstanceType> resultTypes) {
            QueryResultInstanceType aggregatedResult = null;
            for (QueryResultInstanceType queryResultInstance : resultTypes) {
                if (queryResultInstance == null || queryResultInstance.getQueryResultType() == null || queryResultInstance.getQueryResultType().getResultTypeId() == null || !queryResultInstance.getQueryResultType().getResultTypeId().equals("1")) continue;
                if (aggregatedResult == null) {
                    aggregatedResult = new QueryResultInstanceType();
                    aggregatedResult.setDescription("aggregated set");
                    aggregatedResult.setQueryInstanceId(queryResultInstance.getQueryInstanceId());
                    aggregatedResult.setResultInstanceId(queryResultInstance.getResultInstanceId());
                    aggregatedResult.setSetSize(queryResultInstance.getSetSize());
                    QueryResultTypeType resultType = queryResultInstance.getQueryResultType();
                    QueryResultTypeType aggregatedResultType = new QueryResultTypeType();
                    aggregatedResultType.setDisplayType(resultType.getDisplayType());
                    aggregatedResultType.setName(resultType.getName());
                    aggregatedResultType.setResultTypeId(resultType.getResultTypeId());
                    aggregatedResultType.setVisualAttributeType(resultType.getVisualAttributeType());
                    aggregatedResultType.setDescription("Aggregated Result Set");
                    aggregatedResult.setQueryResultType(aggregatedResultType);
                } else {
                    aggregatedResult.setSetSize(aggregatedResult.getSetSize() + queryResultInstance.getSetSize());
                }
                this.convertPDOResponseToCounts(queryResultInstance);
            }
            if (aggregatedResult != null) {
                resultTypes.add(aggregatedResult);
            }
        }

        private void convertPDOResponseToCounts(QueryResultInstanceType response) {
            response.getQueryResultType().setResultTypeId("4");
            response.getQueryResultType().setDisplayType("CATNUM");
            response.getQueryResultType().setName("PATIENT_COUNT_XML");
        }
    };

    private static StatusType makeDoneStatus() {
        StatusType status = new StatusType();
        StatusType.Condition done = new StatusType.Condition();
        done.setType("DONE");
        done.setValue("DONE");
        status.getCondition().add(done);
        return status;
    }

    private AggregationStrategy(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    public abstract void aggregate(T var1, T var2, SpinResultEntry var3);

    public abstract void aggregateError(T var1, SpinResultEntry var2);

    public abstract ResponseMessageType packageInResponse(T var1) throws SerializationException;

    public abstract T extractFromResponse(ResponseMessageType var1) throws SerializationException;

    static final <T> void removeDupesFrom(Collection<T> c) {
        Set unique = Util.asSet(c);
        c.clear();
        c.addAll(unique);
    }

    static void sortQueryMasterTypesByDateDesc(List<QueryMasterType> queryMasterList) {
        Collections.sort(queryMasterList, new Comparator<QueryMasterType>(){

            @Override
            public int compare(QueryMasterType queryMasterType, QueryMasterType queryMasterType1) {
                return queryMasterType1.getCreateDate().compare(queryMasterType.getCreateDate());
            }
        });
    }

    static final void removeQueryMasterTypeDupesFrom(List<QueryMasterType> queryMasterList) {
        ArrayList<QueryMasterType> selectedMasters = new ArrayList<QueryMasterType>();
        for (QueryMasterType masterType : queryMasterList) {
            int index = selectedMasters.indexOf(masterType);
            if (index == -1) {
                selectedMasters.add(masterType);
                continue;
            }
            QueryMasterType duplicate = (QueryMasterType)selectedMasters.get(index);
            if (duplicate.getCreateDate().compare(masterType.getCreateDate()) == -1) continue;
            selectedMasters.remove(duplicate);
            selectedMasters.add(masterType);
        }
        queryMasterList.clear();
        queryMasterList.addAll(selectedMasters);
    }
}

