/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.i2b2message.BodyType;
import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.pdo.query.GetPDOFromInputListRequestType;
import edu.harvard.i2b2.crc.datavo.pdo.query.PatientDataResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterDeleteRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterInstanceResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterRenameRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ObjectFactory;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PsmQryHeaderType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PsmRequestTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.RequestXmlResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultOutputOptionListType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultOutputOptionType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.UserType;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.shrine.serializers.crc.CRCParsedResponse;
import net.shrine.serializers.crc.CRCQueryStatus;
import net.shrine.serializers.crc.CRCQueryTopic;
import net.shrine.serializers.crc.CRCRequestType;
import net.shrine.serializers.crc.CRCResponseType;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.sheriff.model.SheriffRequestType;
import net.shrine.sheriff.model.SheriffResponseType;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class CRCSerializer
extends HiveCommonSerializer {
    private CRCSerializer() {
    }

    public static RequestMessageType getRequestPSM(QueryDefinitionType queryDef, SecurityType securityType, String projectId) throws SerializationException {
        RequestMessageType requestMessage = CRCSerializer.getTemplateRequestMessageType();
        requestMessage.getMessageBody().getAny().add(new ObjectFactory().createPsmheader(CRCSerializer.psmHeader(securityType, projectId)));
        QueryDefinitionRequestType requestQueryDef = new QueryDefinitionRequestType();
        requestQueryDef.setQueryDefinition(queryDef);
        ResultOutputOptionListType list = new ResultOutputOptionListType();
        ResultOutputOptionType patientCounts = new ResultOutputOptionType();
        patientCounts.setName("patient_count_xml");
        patientCounts.setPriorityIndex(Integer.valueOf(1));
        list.getResultOutput().add(patientCounts);
        requestQueryDef.setResultOutputList(list);
        CRCSerializer.addAnyTypeToBodyNode(requestMessage.getMessageBody(), requestQueryDef);
        CRCSerializer.setSecurityType(requestMessage, securityType);
        return requestMessage;
    }

    public static QueryDefinitionRequestType getQueryDefinitionRequest(RequestMessageType request) throws SerializationException {
        try {
            return CRCSerializer.getBodyNode(request, 1, QueryDefinitionRequestType.class);
        }
        catch (Exception e) {
            throw new SerializationException("Could not find the query definition", e);
        }
    }

    public static void updateQueryDefinitionRequest(RequestMessageType request, QueryDefinitionRequestType queryDef) throws SerializationException {
        CRCSerializer.updateAnyTypeBodyNode(request.getMessageBody(), 1, queryDef);
    }

    public static GetPDOFromInputListRequestType getPDOInputListRequest(RequestMessageType request) throws SerializationException {
        try {
            return CRCSerializer.getBodyNode(request, 1, GetPDOFromInputListRequestType.class);
        }
        catch (Exception e) {
            throw new SerializationException("Could not find the query definition", e);
        }
    }

    public static void updatePatientDataResponse(ResponseMessageType response, PatientDataResponseType pdrt) throws SerializationException {
        CRCSerializer.updateAnyTypeBodyNode(response.getMessageBody(), 0, pdrt);
    }

    public static void addPatientDataResponse(ResponseMessageType response, PatientDataResponseType pdrt) {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), pdrt);
    }

    public static void updatePDOQuery(RequestMessageType request, GetPDOFromInputListRequestType pdoRequest) throws SerializationException {
        CRCSerializer.updateAnyTypeBodyNode(request.getMessageBody(), 1, pdoRequest);
    }

    public static void updateMasterResultInstanceResponse(ResponseMessageType response, MasterInstanceResultResponseType newMaster) throws SerializationException {
        CRCSerializer.updateAnyTypeBodyNode(response.getMessageBody(), 0, newMaster);
    }

    public static void addMasterResultInstanceResponse(ResponseMessageType response, MasterInstanceResultResponseType newMaster) {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), newMaster);
    }

    public static void addSheriffResponse(ResponseMessageType response, SheriffResponseType sheriffResponse) {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), sheriffResponse);
    }

    public static void addSheriffRequest(RequestMessageType request, SheriffRequestType sheriffRequest) {
        CRCSerializer.addAnyTypeToBodyNode(request.getMessageBody(), sheriffRequest);
    }

    private static void updateAnyTypeBodyNode(BodyType body, int indexToUpdate, Object update) throws SerializationException {
        try {
            Object old = body.getAny().get(indexToUpdate);
            if (old instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)old;
                element.setValue(update);
                return;
            }
            CRCSerializer.addAnyTypeToBodyNode(body, indexToUpdate, update);
        }
        catch (IndexOutOfBoundsException ioobe) {
            log.warn((Object)"failed updating an any type body element", (Throwable)ioobe);
            throw new SerializationException("Could not update body element");
        }
    }

    public static void addAnyTypeToBodyNode(BodyType body, int indexToAdd, Object addition) {
        String ns = addition.getClass().getPackage().getAnnotation(XmlSchema.class).namespace();
        String xmlRepresentationName = addition.getClass().getAnnotation(XmlRootElement.class).name();
        JAXBElement element = new JAXBElement(new QName(ns, xmlRepresentationName, ""), addition.getClass().getSuperclass(), addition);
        body.getAny().add(indexToAdd, element);
    }

    public static void addAnyTypeToBodyNode(BodyType body, Object addition) {
        String ns = addition.getClass().getPackage().getAnnotation(XmlSchema.class).namespace();
        String xmlRepresentationName = addition.getClass().getAnnotation(XmlRootElement.class).name();
        JAXBElement element = new JAXBElement(new QName(ns, xmlRepresentationName, ""), addition.getClass().getSuperclass(), addition);
        body.getAny().add(element);
    }

    public static void updatePDORequest(RequestMessageType request, GetPDOFromInputListRequestType pdo) {
        request.getMessageBody().getAny().remove(1);
        CRCSerializer.addAnyTypeToBodyNode(request.getMessageBody(), pdo);
    }

    public static PatientDataResponseType getPatientDataResponseType(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, PatientDataResponseType.class);
    }

    public static SheriffResponseType getSheriffResponseType(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, SheriffResponseType.class);
    }

    public static CRCResponseType getResponseType(ResponseMessageType responseMessageType) {
        boolean indexOfResponsePayload = false;
        String clazzName = CRCSerializer.getPayloadClassName(responseMessageType.getMessageBody(), 0);
        return CRCResponseType.fromClass(clazzName);
    }

    public static CRCRequestType getRequestType(RequestMessageType requestMessageType) throws SerializationException {
        boolean indexOfRequestPayload = true;
        String clazzName = CRCSerializer.getPayloadClassName(requestMessageType.getMessageBody(), 1);
        CRCRequestType type = CRCRequestType.fromClass(clazzName);
        if (type == CRCRequestType.MasterRequestType) {
            PsmQryHeaderType header = CRCSerializer.getBodyNode(requestMessageType, 0, PsmQryHeaderType.class);
            if (header.getRequestType() == PsmRequestTypeType.CRC_QRY_GET_REQUEST_XML_FROM_QUERY_MASTER_ID) {
                type = CRCRequestType.GetRequestXml;
            }
            if (header.getRequestType() == PsmRequestTypeType.CRC_QRY_DELETE_QUERY_MASTER) {
                type = CRCRequestType.MasterDeleteRequestType;
            }
        }
        return type;
    }

    public static String getPayloadClassName(BodyType bodyType, int indexOfResponsePayload) {
        String clazzName;
        if (bodyType.getAny().get(indexOfResponsePayload) instanceof JAXBElement) {
            JAXBElement payload = (JAXBElement)bodyType.getAny().get(indexOfResponsePayload);
            clazzName = payload.getValue().getClass().getName();
        } else {
            clazzName = bodyType.getAny().get(indexOfResponsePayload).getClass().getName();
        }
        if (DEBUG) {
            log.debug((Object)("getRequestType(...) " + clazzName));
        }
        return clazzName;
    }

    public static MasterInstanceResultResponseType getQueryMaster(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, MasterInstanceResultResponseType.class);
    }

    public static String getQueryMasterID(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getQueryMaster(response).getQueryMaster().getQueryMasterId();
    }

    public static boolean isCompletedQuery(ResponseMessageType response) {
        return CRCQueryStatus.COMPLETED.equals((Object)CRCSerializer.getQueryStatus(response));
    }

    public static boolean isErrorQuery(ResponseMessageType response) {
        return CRCQueryStatus.ERROR.equals((Object)CRCSerializer.getQueryStatus(response));
    }

    public static CRCQueryStatus getQueryStatus(ResponseMessageType response) {
        try {
            String queryInstanceResponse = CRCSerializer.getQueryMaster(response).getQueryInstance().getQueryStatusType().getName();
            if (DEBUG) {
                log.debug((Object)("query status is:" + queryInstanceResponse));
            }
            return CRCQueryStatus.valueOf(queryInstanceResponse);
        }
        catch (Exception e) {
            log.warn((Object)"could not read status for query master", (Throwable)e);
            return CRCQueryStatus.ERROR;
        }
    }

    public static List<QueryResultInstanceType> getQueryResults(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getQueryMaster(response).getQueryResultInstance();
    }

    public static CRCParsedResponse getParsedResponse(ResponseMessageType response) throws SerializationException {
        try {
            MasterInstanceResultResponseType masterResult = CRCSerializer.getQueryMaster(response);
            ArrayList resultIds = Util.makeArrayList();
            for (QueryResultInstanceType resultInstance : masterResult.getQueryResultInstance()) {
                resultIds.add(resultInstance.getResultInstanceId());
            }
            CRCParsedResponse parsed = new CRCParsedResponse(CRCSerializer.toXMLString(response), CRCSerializer.getQueryStatus(response).name(), CRCSerializer.getQueryResults(response).get(0).getSetSize(), masterResult.getQueryMaster().getQueryMasterId(), masterResult.getQueryInstance().getQueryInstanceId(), resultIds, masterResult.getQueryMaster().getName(), masterResult.getQueryMaster().getCreateDate());
            return parsed;
        }
        catch (Exception e) {
            log.error((Object)"Could not parse response from CRC", (Throwable)e);
            throw new SerializationException(e);
        }
    }

    public static MasterRequestType getMasterRequest(RequestMessageType request) throws SerializationException {
        return CRCSerializer.getBodyNode(request, 1, MasterRequestType.class);
    }

    public static MasterDeleteRequestType getMasterDeleteRequest(RequestMessageType request) throws SerializationException {
        return CRCSerializer.getBodyNode(request, 1, MasterDeleteRequestType.class);
    }

    public static MasterRenameRequestType getMasterRenameRequest(RequestMessageType request) throws SerializationException {
        return CRCSerializer.getBodyNode(request, 1, MasterRenameRequestType.class);
    }

    public static InstanceRequestType getInstanceRequest(RequestMessageType request) throws SerializationException {
        return CRCSerializer.getBodyNode(request, 1, InstanceRequestType.class);
    }

    public static ResultRequestType getResultRequest(RequestMessageType request) throws SerializationException {
        return CRCSerializer.getBodyNode(request, 1, ResultRequestType.class);
    }

    public static MasterResponseType getMasterResponse(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, MasterResponseType.class);
    }

    public static RequestXmlResponseType getRequestXmlResponse(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, RequestXmlResponseType.class);
    }

    public static InstanceResponseType getInstanceResponse(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, InstanceResponseType.class);
    }

    public static ResultResponseType getResultResponse(ResponseMessageType response) throws SerializationException {
        return CRCSerializer.getBodyNode(response, 0, ResultResponseType.class);
    }

    public static void addMasterResponse(ResponseMessageType response, MasterResponseType toBeWrapped) throws SerializationException {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), toBeWrapped);
    }

    public static void addRequestXmlResponse(ResponseMessageType response, RequestXmlResponseType toBeWrapped) throws SerializationException {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), toBeWrapped);
    }

    public static void addInstanceResponse(ResponseMessageType response, InstanceResponseType toBeWrapped) throws SerializationException {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), toBeWrapped);
    }

    public static void addResultResponse(ResponseMessageType response, ResultResponseType toBeWrapped) throws SerializationException {
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), toBeWrapped);
    }

    public static Long getQueryTopicId(RequestMessageType request) {
        Long queryTopicId = null;
        Element shrineQueryTopic = (Element)request.getMessageBody().getAny().get(2);
        NodeList elList = shrineQueryTopic.getElementsByTagName("queryTopicID");
        if (elList != null && elList.getLength() > 0) {
            String nodeValue = elList.item(0).getTextContent();
            queryTopicId = Long.valueOf(nodeValue);
        }
        return queryTopicId;
    }

    public static void setQueryTopicId(RequestMessageType request, Long queryTopicId) throws SerializationException {
        try {
            CRCQueryTopic topic = new CRCQueryTopic();
            topic.setQueryTopicID(String.valueOf(queryTopicId));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CRCQueryTopic.class});
            StringWriter writer = new StringWriter();
            jaxbContext.createMarshaller().marshal((Object)topic, (Writer)writer);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(((Object)writer).toString())));
            request.getMessageBody().getAny().add(2, document.getDocumentElement());
        }
        catch (Exception e) {
            throw new SerializationException("Could not set queryTopicID", e);
        }
    }

    private static PsmQryHeaderType psmHeader(SecurityType securityType, String projectId) {
        PsmQryHeaderType header = new PsmQryHeaderType();
        UserType userType = new UserType();
        userType.setValue(securityType.getUsername());
        userType.setGroup(projectId);
        header.setUser(userType);
        header.setPatientSetLimit(0);
        header.setEstimatedTime(0);
        header.setRequestType(PsmRequestTypeType.CRC_QRY_RUN_QUERY_INSTANCE_FROM_QUERY_DEFINITION);
        return header;
    }
}

