/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ConstrainDateType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.NetworkTime;
import org.spin.tools.Util;

public class QueryDefBuilder {
    public static String SHRINE = "SHRINE";
    public static String Demographics = "Demographics";
    public static String Diagnosis = "Diagnosis";
    public static String Medications = "Medications";
    public static String Labs = "Labs";
    public static String Age = "Age";
    public static String Gender = "Gender";
    public static String Male = "Male";
    public static String Female = "Female";
    public static String PATH_DEMOGRAPHICS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics);
    public static String PATH_DIAGNOSIS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Diagnosis);
    public static String PATH_MEDICATIONS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Medications);
    public static String PATH_LABS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Labs);
    public static String PATH_MALE = QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics, Gender, Male);
    public static String PATH_FEMALE = QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics, Gender, Female);
    public static String SLASH = "\\";
    private static String I2B2_YEARS_OLD_STRING = " years old";

    public static RequestMessageType getRequestPSM(QueryDefinitionType queryDef, SecurityType securityType, String projectId) throws SerializationException {
        return CRCSerializer.getRequestPSM(queryDef, securityType, projectId);
    }

    public static QueryDefinitionType getQueryDefinition(List<PanelType> panels) {
        QueryDefinitionType queryDef = new QueryDefinitionType();
        for (int p = 0; p < panels.size(); ++p) {
            PanelType panel = panels.get(p);
            panel.setPanelNumber(p + 1);
            queryDef.getPanel().add(panel);
        }
        return queryDef;
    }

    public static QueryDefinitionType getQueryDefinition(PanelType ... panels) {
        return QueryDefBuilder.getQueryDefinition(Arrays.asList(panels));
    }

    public static QueryDefinitionType getQueryDefinition(ItemType ... itemsInSinglePanel) {
        return QueryDefBuilder.getQueryDefinition(QueryDefBuilder.getPanel(itemsInSinglePanel));
    }

    public static QueryDefinitionType getQueryDefinition(String ... itemKeysSinglePanel) {
        return QueryDefBuilder.getQueryDefinition(QueryDefBuilder.getPanel(itemKeysSinglePanel));
    }

    public static PanelType getPanel(List<ItemType> items) {
        PanelType panel = new PanelType();
        panel.setPanelNumber(1);
        panel.setInvert(0);
        PanelType.TotalItemOccurrences occurences = new PanelType.TotalItemOccurrences();
        occurences.setValue(items.size());
        panel.setTotalItemOccurrences(occurences);
        for (ItemType item : items) {
            panel.getItem().add(item);
        }
        return panel;
    }

    public static PanelType getPanel(ItemType ... items) {
        return QueryDefBuilder.getPanel(Arrays.asList(items));
    }

    public static ConstrainDateType getDateConstraint(int year) {
        ConstrainDateType constraint = new ConstrainDateType();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, 1, 1);
        constraint.setValue(NetworkTime.makeXMLGregorianCalendar((GregorianCalendar)calendar));
        return constraint;
    }

    public static PanelType getPanel(int yearStart, int yearEnd, ItemType ... items) {
        PanelType panel = QueryDefBuilder.getPanel(items);
        panel.setPanelDateFrom(QueryDefBuilder.getDateConstraint(yearStart));
        panel.setPanelDateTo(QueryDefBuilder.getDateConstraint(yearEnd));
        return panel;
    }

    public static PanelType getPanel(String ... itemKeys) {
        return QueryDefBuilder.getPanel(QueryDefBuilder.getItems(itemKeys));
    }

    public static ItemType getItemGenderMale() {
        return QueryDefBuilder.getItem(PATH_MALE);
    }

    public static ItemType getItemGenderFemale() {
        return QueryDefBuilder.getItem(PATH_FEMALE);
    }

    public static ItemType getItem(String path) {
        ItemType item = new ItemType();
        item.setItemKey(path);
        return item;
    }

    public static ItemType[] getItems(List<String> itemKeys) {
        ItemType[] items = new ItemType[itemKeys.size()];
        for (int i = 0; i < itemKeys.size(); ++i) {
            items[i] = QueryDefBuilder.getItem(itemKeys.get(i));
        }
        return items;
    }

    public static ItemType[] getItems(String ... itemKeys) {
        return QueryDefBuilder.getItems(Arrays.asList(itemKeys));
    }

    public static String getPathPrefix(String PREFIX) {
        return SLASH + SLASH + PREFIX + SLASH;
    }

    public static String buildPath(String ... traversal) {
        StringBuilder path = new StringBuilder();
        for (String node : traversal) {
            path.append(node);
            path.append(SLASH);
        }
        return path.toString();
    }

    public static String buildPathWithPrefix(String PREFIX, String ... traversal) {
        return QueryDefBuilder.getPathPrefix(PREFIX) + QueryDefBuilder.buildPath(traversal);
    }

    public static ItemType getItemAge(int yearsOld) {
        String ageBin = QueryDefBuilder.getAgeBin(yearsOld);
        String ageString = yearsOld + I2B2_YEARS_OLD_STRING;
        if (QueryDefBuilder.between(yearsOld, 0, 89)) {
            return QueryDefBuilder.getItem(QueryDefBuilder.buildPathWithPrefix(SHRINE, SHRINE, Demographics, Age, ageBin, ageString));
        }
        return QueryDefBuilder.getItemAgeBin(ageBin);
    }

    public static ItemType getItemAgeBin(String ageRange) {
        return QueryDefBuilder.getItem(QueryDefBuilder.buildPathWithPrefix(SHRINE, SHRINE, Demographics, Age, ageRange));
    }

    public static ArrayList<String> getAgeBins() {
        ArrayList ranges = Util.makeArrayList();
        for (int i = 0; i < 100; ++i) {
            String bin = QueryDefBuilder.getAgeBin(i);
            if (ranges.contains(bin)) continue;
            ranges.add(bin);
        }
        return ranges;
    }

    public static String getAgeBin(int yearsOld) {
        if (yearsOld >= 90) {
            return ">=90" + I2B2_YEARS_OLD_STRING;
        }
        String age = null;
        if (QueryDefBuilder.between(yearsOld, 0, 9)) {
            age = "0-9";
        } else if (QueryDefBuilder.between(yearsOld, 10, 17)) {
            age = "10-17";
        } else if (QueryDefBuilder.between(yearsOld, 18, 34)) {
            age = "18-34";
        } else if (QueryDefBuilder.between(yearsOld, 35, 44)) {
            age = "35-44";
        } else if (QueryDefBuilder.between(yearsOld, 45, 54)) {
            age = "45-54";
        } else if (QueryDefBuilder.between(yearsOld, 55, 64)) {
            age = "55-64";
        } else if (QueryDefBuilder.between(yearsOld, 65, 74)) {
            age = "65-74";
        } else if (QueryDefBuilder.between(yearsOld, 75, 84)) {
            age = "75-84";
        } else if (QueryDefBuilder.between(yearsOld, 85, 89)) {
            age = "85-89";
        }
        return age + I2B2_YEARS_OLD_STRING;
    }

    private static boolean between(int number, int min, int max) {
        return number >= min && number <= max;
    }
}

