/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.List;
import net.shrine.config.AdapterMappings;
import net.shrine.config.ShrineConfigTestResources;
import org.spin.tools.FileUtils;
import org.spin.tools.JAXBUtils;
import org.spin.tools.SPINUnitTest;

public final class AdapterMappingsTest
extends SPINUnitTest {
    private static final String CORE_KEY_DEMOGRAPHICS_0_9 = "\\\\i2b2\\i2b2\\Demographics\\Age\\0-9 years old\\";
    private static final String CORE_KEY_TEST = "\\\\i2b2\\i2b2\\TEST\\KEY\\";
    private static final String CORE_KEY_INVALID = "THIS IS NOT A VALID GLOBAL KEY";
    private static final String LOCAL_KEY_DEMOGRAPHICS_AGE_4 = "\\\\i2b2\\LOCAL\\DEM|AGE:4";
    private static final String LOCAL_KEY_DEMOGRAPHICS_AGE_TEST = "\\\\i2b2\\LOCAL\\DEM|AGE:TEST";

    public void skip_testGetInstanceReturnsTheSameObject() throws Exception {
        AdapterMappings one = AdapterMappings.getDefaultInstance();
        AdapterMappings two = AdapterMappings.getDefaultInstance();
        AdapterMappingsTest.assertSame((String)"getDefaultInstance should always return the same object", (Object)one, (Object)two);
    }

    public void testLoadFromFile() throws Exception {
        File tempfile = File.createTempFile("AdapterMappings", ".xml");
        String contents = FileUtils.read((InputStream)ShrineConfigTestResources.AdapterMappings_DEM_AGE_0_9.getInputStream());
        FileUtils.write((File)tempfile, (String)contents);
        AdapterMappings mappings = AdapterMappings.loadfromFile((File)tempfile);
        int expectedEntries = 0;
        String entryTag = "<entry>";
        BufferedReader in = new BufferedReader(new InputStreamReader(ShrineConfigTestResources.AdapterMappings_DEM_AGE_0_9.getInputStream()));
        String line = in.readLine();
        while (line != null) {
            if (line.trim().equalsIgnoreCase("<entry>")) {
                ++expectedEntries;
            }
            line = in.readLine();
        }
        AdapterMappingsTest.assertEquals((String)("Should have loaded " + expectedEntries + " mappings"), (int)expectedEntries, (int)mappings.size());
        String expectedHostname = "localhost-test";
        AdapterMappingsTest.assertEquals((String)"Hostname should be localhost-test", (String)"localhost-test", (String)mappings.getHostname());
        int expectedTimestampYear = 1970;
        Calendar cal = Calendar.getInstance();
        cal.setTime(mappings.getTimestamp());
        AdapterMappingsTest.assertEquals((String)"Timestamp should be 1970", (int)1970, (int)cal.get(1));
    }

    public void testApplyI2B2Prefix() throws Exception {
        String no_prefix = "\\TEST\\PATH";
        String has_prefix = "\\\\I2B2\\TEST\\PATH";
        AdapterMappingsTest.assertEquals((String)"Should apply prefix where there is none", (String)"\\\\I2B2\\TEST\\PATH", (String)AdapterMappings.applyI2B2Prefix((String)"\\TEST\\PATH"));
        AdapterMappingsTest.assertEquals((String)"Should apply prefix when the local path begins with \\I2B2(single slash)", (String)"\\\\I2B2\\I2B2\\TEST\\PATH", (String)AdapterMappings.applyI2B2Prefix((String)"\\I2B2\\TEST\\PATH"));
        AdapterMappingsTest.assertEquals((String)"Should not apply the prefix when it is already there.", (String)"\\\\I2B2\\TEST\\PATH", (String)AdapterMappings.applyI2B2Prefix((String)"\\\\I2B2\\TEST\\PATH"));
    }

    public void testGetMappings() throws Exception {
        AdapterMappings mappings = AdapterMappings.loadfromStream((InputStream)ShrineConfigTestResources.AdapterMappings_DEM_AGE_0_9.getInputStream());
        AdapterMappingsTest.assertNotNull((Object)mappings.getMappings(CORE_KEY_INVALID));
        AdapterMappingsTest.assertSame((Object)0, (Object)mappings.getMappings(CORE_KEY_INVALID).size());
        AdapterMappingsTest.assertNotNull((Object)mappings.getMappings(CORE_KEY_DEMOGRAPHICS_0_9));
        AdapterMappingsTest.assertSame((Object)10, (Object)mappings.getMappings(CORE_KEY_DEMOGRAPHICS_0_9).size());
        try {
            List local_keys = mappings.getMappings(CORE_KEY_DEMOGRAPHICS_0_9);
            local_keys.add("Better hope not");
            AdapterMappingsTest.fail((String)"Should not be able to add directly");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddMapping() throws Exception {
        AdapterMappings mappings = AdapterMappings.loadfromStream((InputStream)ShrineConfigTestResources.AdapterMappings_DEM_AGE_0_9.getInputStream());
        AdapterMappingsTest.assertFalse((String)"Should not add duplicate local_keys", (boolean)mappings.addMapping(CORE_KEY_DEMOGRAPHICS_0_9, LOCAL_KEY_DEMOGRAPHICS_AGE_4));
        AdapterMappingsTest.assertSame((Object)10, (Object)mappings.getMappings(CORE_KEY_DEMOGRAPHICS_0_9).size());
        AdapterMappingsTest.assertTrue((String)"Should add a new local_key succesfully", (boolean)mappings.addMapping(CORE_KEY_DEMOGRAPHICS_0_9, LOCAL_KEY_DEMOGRAPHICS_AGE_TEST));
        AdapterMappingsTest.assertSame((Object)11, (Object)mappings.getMappings(CORE_KEY_DEMOGRAPHICS_0_9).size());
        AdapterMappingsTest.assertSame((Object)0, (Object)mappings.getMappings(CORE_KEY_TEST).size());
        AdapterMappingsTest.assertTrue((String)"Should add a new core+local key conbo successully", (boolean)mappings.addMapping(CORE_KEY_TEST, LOCAL_KEY_DEMOGRAPHICS_AGE_TEST));
        AdapterMappingsTest.assertSame((Object)1, (Object)mappings.getMappings(CORE_KEY_TEST).size());
    }

    public void testSerialize() throws Exception {
        AdapterMappings m = new AdapterMappings();
        m.addMapping("core1", "local1");
        m.addMapping("core1", "local2");
        m.addMapping("core2", "local1");
        m.addMapping("core2", "local2");
        m.addMapping("core2", "local3");
        String xml = JAXBUtils.marshalToString((Object)m);
        AdapterMappings m1 = (AdapterMappings)JAXBUtils.unmarshal((String)xml, AdapterMappings.class);
        String xml1 = JAXBUtils.marshalToString((Object)m1);
        AdapterMappingsTest.assertEquals((String)xml, (String)xml1);
    }
}

