/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.hive;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import net.shrine.serializers.hive.MockHttpEchoHandler;
import net.shrine.serializers.hive.MockHttpHandler;
import net.shrine.serializers.hive.MockHttpHandlerException;

public class MockHttpEmbeddedServer {
    public static final String HOSTNAME = "localhost";
    public static final int PORT = 20201;
    public static final String RESOURCE = "/";
    private HttpServer embededServer = HttpServer.create(new InetSocketAddress("localhost", 20201), 10);

    public MockHttpEmbeddedServer() throws IOException {
        this(new MockHttpEchoHandler());
    }

    public MockHttpEmbeddedServer(final MockHttpHandler handler) throws IOException {
        HttpHandler handlerWrapper = new HttpHandler(){

            @Override
            public void handle(HttpExchange t) throws IOException {
                int contentLength = Integer.parseInt(t.getRequestHeaders().getFirst("Content-Length"));
                byte[] buffer = new byte[contentLength];
                InputStream is = t.getRequestBody();
                is.read(buffer);
                try {
                    String responseBody = handler.handle(new String(buffer));
                    t.sendResponseHeaders(200, responseBody.length());
                    OutputStream os = t.getResponseBody();
                    os.write(responseBody.getBytes());
                    os.close();
                }
                catch (MockHttpHandlerException e) {
                    throw new IOException(e);
                }
            }
        };
        this.embededServer.createContext(RESOURCE, handlerWrapper);
        this.embededServer.setExecutor(null);
    }

    public static String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(HOSTNAME);
        sb.append(":");
        sb.append(20201);
        sb.append(RESOURCE);
        return sb.toString();
    }

    public void start() {
        this.embededServer.start();
    }

    public void shutdown() {
        this.embededServer.stop(3);
    }
}

