/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff;

import edu.harvard.i2b2.crc.datavo.pm.ParamType;
import edu.harvard.i2b2.crc.datavo.pm.PasswordType;
import edu.harvard.i2b2.crc.datavo.pm.UserType;
import junit.framework.Assert;
import net.shrine.protocol.ApprovedTopic;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.Credential;
import net.shrine.protocol.ReadApprovedQueryTopicsRequest;
import net.shrine.protocol.ReadApprovedQueryTopicsResponse;
import net.shrine.serializers.pm.PMHttpClient;
import net.shrine.serializers.pm.PMSerializer;
import net.shrine.sheriff.SheriffQueryAuthorizationService;
import net.shrine.sheriff.model.SheriffClientFacade;
import net.shrine.sheriff.model.SheriffEntry;
import org.easymock.EasyMock;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.ShouldMatchersForJUnit;
import org.scalatest.matchers.Matchers;
import org.scalatest.matchers.Matchers$ByteTolerance$;
import org.scalatest.matchers.Matchers$DoubleTolerance$;
import org.scalatest.matchers.Matchers$FloatTolerance$;
import org.scalatest.matchers.Matchers$IntTolerance$;
import org.scalatest.matchers.Matchers$LongTolerance$;
import org.scalatest.matchers.Matchers$ShortTolerance$;
import org.scalatest.matchers.ShouldMatchers;
import org.scalatest.matchers.ShouldMatchers$ShouldMethodHelper$;
import org.scalatest.mock.EasyMockSugar;
import org.scalatest.verb.ShouldVerb;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u0013\t!3\u000b[3sS\u001a4\u0017+^3ss\u0006+H\u000f[8sSj\fG/[8o'\u0016\u0014h/[2f)\u0016\u001cHO\u0003\u0002\u0004\t\u000591\u000f[3sS\u001a4'BA\u0003\u0007\u0003\u0019\u0019\bN]5oK*\tq!A\u0002oKR\u001c\u0001a\u0005\u0004\u0001\u0015Iar$\n\t\u0003\u0017Ai\u0011\u0001\u0004\u0006\u0003\u001b9\tA\u0001\\1oO*\tq\"\u0001\u0003kCZ\f\u0017BA\t\r\u0005\u0019y%M[3diB\u00111CG\u0007\u0002))\u0011QCF\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003/a\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003e\t1a\u001c:h\u0013\tYBC\u0001\nBgN,'\u000f^5p]N4uN\u001d&V]&$\bCA\n\u001e\u0013\tqBC\u0001\fTQ>,H\u000eZ'bi\u000eDWM]:G_JTUK\\5u!\t\u00013%D\u0001\"\u0015\t\u0011c#\u0001\u0003n_\u000e\\\u0017B\u0001\u0013\"\u00055)\u0015m]=N_\u000e\\7+^4beB\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\tY1kY1mC>\u0013'.Z2u\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t!\u0001C\u00032\u0001\u0011\u0005!'A\u000euKN$X\t\u001f;sC\u000e$XiY8n[>t7/V:fe:\fW.Z\u000b\u0002gA\u0011a\u0005N\u0005\u0003k\u001d\u0012A!\u00168ji\"\u0012\u0001g\u000e\t\u0003qij\u0011!\u000f\u0006\u0003+aI!aO\u001d\u0003\tQ+7\u000f\u001e\u0005\u0006{\u0001!IAP\u0001\u0013GJ,\u0017\r^3UKN$Xk]3s)f\u0004X\rF\u0002@\u001fb\u0003\"\u0001Q'\u000e\u0003\u0005S!AQ\"\u0002\u0005Al'B\u0001#F\u0003\u0019!\u0017\r^1w_*\u0011aiR\u0001\u0004GJ\u001c'B\u0001%J\u0003\u0011I'G\u0019\u001a\u000b\u0005)[\u0015a\u00025beZ\f'\u000f\u001a\u0006\u0002\u0019\u0006\u0019Q\rZ;\n\u00059\u000b%\u0001C+tKJ$\u0016\u0010]3\t\u000bAc\u0004\u0019A)\u00021\u0015D\b/Z2uK\u0012,5m\\7n_:\u001cXk]3s]\u0006lW\r\u0005\u0002S+:\u0011aeU\u0005\u0003)\u001e\na\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011Ak\n\u0005\u00063r\u0002\r!U\u0001\na\u0006\u0014\u0018-\u001c(b[\u0016DQa\u0017\u0001\u0005\u0002I\nq\u0003^3tiJ+\u0017\rZ!qaJ|g/\u001a3F]R\u0014\u0018.Z:)\u0005i;\u0004")
public class SheriffQueryAuthorizationServiceTest
implements AssertionsForJUnit,
ShouldMatchersForJUnit,
EasyMockSugar,
ScalaObject {
    private final Matchers.NotWord not;
    private final Matchers.BeWord be;
    private final Matchers.HaveWord have;
    private final Matchers.ContainWord contain;
    private final Matchers.IncludeWord include;
    private final Matchers.FullyMatchWord fullyMatch;
    private final Matchers.StartWithWord startWith;
    private final Matchers.EndWithWord endWith;
    private final Matchers.LengthWord length;
    private final Matchers.SizeWord size;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile ShouldMatchers$ShouldMethodHelper$ org$scalatest$matchers$ShouldMatchers$$ShouldMethodHelper$module;
    private volatile Matchers$DoubleTolerance$ DoubleTolerance$module;
    private volatile Matchers$FloatTolerance$ FloatTolerance$module;
    private volatile Matchers$LongTolerance$ LongTolerance$module;
    private volatile Matchers$IntTolerance$ IntTolerance$module;
    private volatile Matchers$ShortTolerance$ ShortTolerance$module;
    private volatile Matchers$ByteTolerance$ ByteTolerance$module;

    @Test
    public void testExtractEcommonsUsername() {
        String expectedEcommonsUsername = "testEcommonsName";
        UserType userType = this.createTestUserType(expectedEcommonsUsername, "ecommons_username");
        Assert.assertEquals((String)expectedEcommonsUsername, (String)PMSerializer.extractEcommonsUsername((UserType)userType));
    }

    /*
     * WARNING - void declaration
     */
    private UserType createTestUserType(String expectedEcommonsUsername, String paramName) {
        void var3_3;
        UserType userType = new UserType();
        userType.setDomain("HarvardDemo");
        userType.setUserName("demo");
        PasswordType password = new PasswordType();
        password.setValue("demouser");
        userType.setPassword(password);
        ParamType testParam = new ParamType();
        testParam.setName(paramName);
        testParam.setValue(expectedEcommonsUsername);
        userType.getParam().add(testParam);
        return var3_3;
    }

    @Test
    public void testReadApprovedEntries() {
        String ecommonsName = "ecommonsUsername";
        SheriffEntry sheriffEntry = new SheriffEntry();
        sheriffEntry.setECommonsID(ecommonsName);
        long queryTopic1$1 = 1L;
        sheriffEntry.setQueryTopicID(Predef$.MODULE$.long2Long(queryTopic1$1));
        UserType user = this.createTestUserType(ecommonsName, "ecommons_username");
        String userId = "username";
        String domain = "domain";
        String password = "";
        AuthenticationInfo authn$1 = new AuthenticationInfo("domain", "username", new Credential("", false));
        List sheriffEntries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SheriffEntry[]{sheriffEntry}));
        PMHttpClient pmClient = (PMHttpClient)this.mock(Manifest$.MODULE$.classType(PMHttpClient.class));
        SheriffClientFacade sheriffFacade = (SheriffClientFacade)this.mock(Manifest$.MODULE$.classType(SheriffClientFacade.class));
        SheriffQueryAuthorizationService service$1 = new SheriffQueryAuthorizationService(pmClient, sheriffFacade);
        EasyMock.expect((Object)sheriffFacade.readApprovedEntries(ecommonsName)).andReturn((Object)JavaConversions$.MODULE$.seqAsJavaList((Seq)sheriffEntries));
        this.expecting(EasyMock.expect((Object)pmClient.getUserConfiguration("domain", "username", "")).andReturn((Object)user));
        this.whenExecuting(pmClient, (Seq)Predef$.MODULE$.wrapRefArray(new Object[]{sheriffFacade}), (Function0)new Serializable(this, queryTopic1$1, authn$1, service$1){
            public static final long serialVersionUID;
            private final long queryTopic1$1;
            private final AuthenticationInfo authn$1;
            private final SheriffQueryAuthorizationService service$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReadApprovedQueryTopicsResponse response = this.service$1.readApprovedEntries(new ReadApprovedQueryTopicsRequest("projectId", 1L, this.authn$1, "username"));
                Assert.assertNotNull((Object)response);
                Assert.assertEquals((int)1, (int)response.approvedTopics().size());
                Assert.assertEquals((long)this.queryTopic1$1, (long)((ApprovedTopic)response.approvedTopics().apply(0)).queryTopicId());
            }
            {
                this.queryTopic1$1 = l;
                this.authn$1 = authenticationInfo;
                this.service$1 = sheriffQueryAuthorizationService;
            }
        });
    }

    public SheriffQueryAuthorizationServiceTest() {
        Assertions.class.$init$((Assertions)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        Matchers.class.$init$((Matchers)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        ShouldMatchers.class.$init$((ShouldMatchers)this);
        ShouldMatchersForJUnit.class.$init$((ShouldMatchersForJUnit)this);
        EasyMockSugar.class.$init$((EasyMockSugar)this);
    }
}

