/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.shrine.config.package$;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreDescriptorParser$;
import net.shrine.crypto.KeyStoreDescriptorParser$Keys$;
import net.shrine.crypto.KeyStoreType;
import net.shrine.crypto.KeyStoreType$;
import net.shrine.crypto.RemoteSiteDescriptor;
import net.shrine.log.Loggable;
import net.shrine.util.PeerToPeerModel$;
import net.shrine.util.SingleHubModel;
import net.shrine.util.TrustModel;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public final class KeyStoreDescriptorParser$
implements Loggable {
    public static final KeyStoreDescriptorParser$ MODULE$;
    private final Logger net$shrine$log$Loggable$$internalLogger;
    private volatile boolean bitmap$0;

    static {
        new KeyStoreDescriptorParser$();
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        KeyStoreDescriptorParser$ keyStoreDescriptorParser$ = this;
        synchronized (keyStoreDescriptorParser$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.class.net$shrine$log$Loggable$$internalLogger((Loggable)this);
                this.bitmap$0 = true;
            }
            return this.net$shrine$log$Loggable$$internalLogger;
        }
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger : this.net$shrine$log$Loggable$$internalLogger$lzycompute();
    }

    public Logger logger() {
        return Loggable.class.logger((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.class.debugEnabled((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.class.infoEnabled((Loggable)this);
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public final void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public final void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public final void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public final void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public KeyStoreDescriptor apply(Config keyStoreConfig, Config hubConfig, Config qepConfig) {
        TrustModel tm = this.getTrustModel$1(hubConfig, qepConfig);
        return new KeyStoreDescriptor(keyStoreConfig.getString(KeyStoreDescriptorParser$Keys$.MODULE$.file()), keyStoreConfig.getString(KeyStoreDescriptorParser$Keys$.MODULE$.password()), (Option<String>)package$.MODULE$.ConfigExtensions(keyStoreConfig).getOption(KeyStoreDescriptorParser$Keys$.MODULE$.privateKeyAlias(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<String, String> apply(Config x$7) {
                return new Serializable(this, x$7){
                    public static final long serialVersionUID = 0L;
                    private final Config x$7$1;

                    public final String apply(String x$1) {
                        return this.x$7$1.getString(x$1);
                    }
                    {
                        this.x$7$1 = x$7$1;
                    }
                };
            }
        }), (Seq<String>)this.getCaCertAliases$1(keyStoreConfig), tm, (Seq<RemoteSiteDescriptor>)this.getRemoteSites$1(keyStoreConfig, hubConfig, qepConfig, tm), this.getKeyStoreType$1(keyStoreConfig));
    }

    private final TrustModel getTrustModel$1(Config hubConfig$1, Config qepConfig$1) {
        PeerToPeerModel$ peerToPeerModel$;
        boolean hasModel = qepConfig$1.hasPath(KeyStoreDescriptorParser$Keys$.MODULE$.trustModel());
        if (hasModel && !qepConfig$1.getBoolean(KeyStoreDescriptorParser$Keys$.MODULE$.trustModel())) {
            peerToPeerModel$ = PeerToPeerModel$.MODULE$;
        } else if (hasModel && hubConfig$1.hasPath(KeyStoreDescriptorParser$Keys$.MODULE$.isHub())) {
            peerToPeerModel$ = new SingleHubModel(hubConfig$1.getBoolean(KeyStoreDescriptorParser$Keys$.MODULE$.isHub()));
        } else if (hasModel) {
            this.warn((Function0<Object>)new Serializable(hubConfig$1){
                public static final long serialVersionUID = 0L;
                private final Config hubConfig$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not specify whether this is the hub or a downStreamNode, assuming it ", " because the hub config is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hubConfig$1.isEmpty() ? "isn't" : "is", this.hubConfig$1.isEmpty() ? "empty" : "defined"}));
                }
                {
                    this.hubConfig$1 = hubConfig$1;
                }
            });
            peerToPeerModel$ = new SingleHubModel(!hubConfig$1.isEmpty());
        } else {
            this.info((Function0<Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No Trust Model specified for this network configuration, assuming that a Peer configuration is being used";
                }
            });
            peerToPeerModel$ = PeerToPeerModel$.MODULE$;
        }
        return peerToPeerModel$;
    }

    public final String net$shrine$crypto$KeyStoreDescriptorParser$$parseUrl$1(String url) {
        return new URL(url).getHost();
    }

    public final String net$shrine$crypto$KeyStoreDescriptorParser$$parsePort$1(String url) {
        return ((Object)BoxesRunTime.boxToInteger((int)new URL(url).getPort())).toString();
    }

    private final Seq getRemoteSites$1(Config keyStoreConfig$1, Config hubConfig$1, Config qepConfig$1, TrustModel tm$1) {
        TrustModel trustModel;
        block5: {
            Seq seq;
            block3: {
                boolean bl;
                SingleHubModel singleHubModel;
                boolean bl2;
                block4: {
                    block2: {
                        bl2 = false;
                        singleHubModel = null;
                        trustModel = tm$1;
                        if (!PeerToPeerModel$.MODULE$.equals(trustModel)) break block2;
                        seq = this.parseAliasMap$1(keyStoreConfig$1, hubConfig$1);
                        break block3;
                    }
                    if (!(trustModel instanceof SingleHubModel)) break block4;
                    bl2 = true;
                    singleHubModel = (SingleHubModel)trustModel;
                    boolean bl3 = singleHubModel.isCa();
                    if (!bl3) break block4;
                    seq = this.parseRemoteSitesForHub$1(hubConfig$1);
                    break block3;
                }
                if (!bl2 || (bl = singleHubModel.isCa())) break block5;
                seq = this.parseRemoteSiteFromQep$1(keyStoreConfig$1, qepConfig$1);
            }
            return seq;
        }
        throw new MatchError((Object)trustModel);
    }

    public final boolean net$shrine$crypto$KeyStoreDescriptorParser$$isString$1(ConfigValue cv) {
        ConfigValueType configValueType = cv.valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        return !(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null);
    }

    private final Seq getCaCertAliases$1(Config keyStoreConfig$1) {
        return (Seq)((TraversableLike)package$.MODULE$.ConfigExtensions(keyStoreConfig$1).getOption(KeyStoreDescriptorParser$Keys$.MODULE$.caCertAliases(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<String, ConfigList> apply(Config x$1) {
                return new Serializable(this, x$1){
                    public static final long serialVersionUID = 0L;
                    private final Config x$1$1;

                    public final ConfigList apply(String x$1) {
                        return this.x$1$1.getList(x$1);
                    }
                    {
                        this.x$1$1 = x$1$1;
                    }
                };
            }
        }).fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<ConfigValue> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<ConfigValue> apply(ConfigList list) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)list).asScala();
            }
        })).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ConfigValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$isString$1(A1) ? KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1(A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ConfigValue x1) {
                ConfigValue configValue = x1;
                boolean bl = KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$isString$1(configValue);
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq parseRemoteSitesForHub$1(Config hubConfig$1) {
        Set downStreamAliases = hubConfig$1.getConfig(KeyStoreDescriptorParser$Keys$.MODULE$.downStreamNodes()).entrySet();
        return ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(downStreamAliases).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RemoteSiteDescriptor apply(Map.Entry<String, ConfigValue> entry) {
                String url = KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1(entry.getValue());
                return new RemoteSiteDescriptor(entry.getKey(), (Option<String>)None$.MODULE$, KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$parseUrl$1(url), KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$parsePort$1(url));
            }
        }, Set$.MODULE$.canBuildFrom())).toList();
    }

    private final Seq parseRemoteSiteFromQep$1(Config keyStoreConfig$1, Config qepConfig$1) {
        Seq aliases = this.getCaCertAliases$1(keyStoreConfig$1);
        Predef$.MODULE$.assert(aliases.nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "There has to be at least one caCertAlias";
            }
        });
        String qepUrl = qepConfig$1.getString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyStoreDescriptorParser$Keys$.MODULE$.qepEndpoint(), KeyStoreDescriptorParser$Keys$.MODULE$.url()})));
        RemoteSiteDescriptor remoteSiteDescriptor = new RemoteSiteDescriptor("Hub", (Option<String>)new Some(aliases.head()), this.net$shrine$crypto$KeyStoreDescriptorParser$$parseUrl$1(qepUrl), this.net$shrine$crypto$KeyStoreDescriptorParser$$parsePort$1(qepUrl));
        return (Seq)Nil$.MODULE$.$plus$colon((Object)remoteSiteDescriptor, List$.MODULE$.canBuildFrom());
    }

    private final Seq parseAliasMap$1(Config keyStoreConfig$1, Config hubConfig$1) {
        Set aliases = keyStoreConfig$1.getConfig(KeyStoreDescriptorParser$Keys$.MODULE$.aliasMap()).entrySet();
        Set downStreamAliases = hubConfig$1.getConfig(KeyStoreDescriptorParser$Keys$.MODULE$.downStreamNodes()).entrySet();
        Predef$.MODULE$.assert(aliases.size() == downStreamAliases.size(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The aliasMap has to match one-to-one with the Hub's downstreamNodes";
            }
        });
        JavaConversions$.MODULE$.asScalaSet(aliases).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaSet(downStreamAliases)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Map.Entry<String, ConfigValue> entry) {
                ConfigValueType configValueType = entry.getValue().valueType();
                ConfigValueType configValueType2 = ConfigValueType.STRING;
                Predef$.MODULE$.assert(!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null));
            }
        });
        Predef$.MODULE$.assert(aliases.size() == ((TraversableOnce)((GenSetLike)JavaConversions$.MODULE$.asScalaSet(aliases).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map.Entry<String, ConfigValue> x$3) {
                return x$3.getKey();
            }
        }, Set$.MODULE$.canBuildFrom())).intersect((GenSet)JavaConversions$.MODULE$.asScalaSet(downStreamAliases).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map.Entry<String, ConfigValue> x$4) {
                return x$4.getKey();
            }
        }, Set$.MODULE$.canBuildFrom()))).size());
        return ((SetLike)JavaConversions$.MODULE$.asScalaSet(aliases).map((Function1)new Serializable(downStreamAliases){
            public static final long serialVersionUID = 0L;
            private final Set downStreamAliases$1;

            public final RemoteSiteDescriptor apply(Map.Entry<String, ConfigValue> siteAlias) {
                String url = KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1((ConfigValue)((Map.Entry)JavaConversions$.MODULE$.asScalaSet(this.downStreamAliases$1).find((Function1)new Serializable(this, siteAlias){
                    public static final long serialVersionUID = 0L;
                    private final Map.Entry siteAlias$1;

                    public final boolean apply(Map.Entry<String, ConfigValue> x$5) {
                        return BoxesRunTime.equals((Object)x$5.getKey(), this.siteAlias$1.getKey());
                    }
                    {
                        this.siteAlias$1 = siteAlias$1;
                    }
                }).get()).getValue());
                return new RemoteSiteDescriptor(siteAlias.getKey(), (Option<String>)new Some((Object)KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1(siteAlias.getValue())), KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$parseUrl$1(url), KeyStoreDescriptorParser$.MODULE$.net$shrine$crypto$KeyStoreDescriptorParser$$parsePort$1(url));
            }
            {
                this.downStreamAliases$1 = downStreamAliases$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq();
    }

    private final KeyStoreType getKeyStoreType$1(Config keyStoreConfig$1) {
        Option typeOption = package$.MODULE$.ConfigExtensions(keyStoreConfig$1).getOption(KeyStoreDescriptorParser$Keys$.MODULE$.keyStoreType(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<String, String> apply(Config x$6) {
                return new Serializable(this, x$6){
                    public static final long serialVersionUID = 0L;
                    private final Config x$6$1;

                    public final String apply(String x$1) {
                        return this.x$6$1.getString(x$1);
                    }
                    {
                        this.x$6$1 = x$6$1;
                    }
                };
            }
        });
        return (KeyStoreType)typeOption.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<KeyStoreType> apply(String name) {
                return KeyStoreType$.MODULE$.valueOf(name);
            }
        }).getOrElse((Function0)new Serializable(typeOption){
            public static final long serialVersionUID = 0L;
            public final Option typeOption$1;

            public final KeyStoreType apply() {
                KeyStoreDescriptorParser$.MODULE$.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getKeyStoreType.1.2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown keystore type '", "', allowed types are ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.typeOption$1.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), KeyStoreType$.MODULE$.JKS().name(), KeyStoreType$.MODULE$.PKCS12().name()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return KeyStoreType$.MODULE$.Default();
            }
            {
                this.typeOption$1 = typeOption$1;
            }
        });
    }

    public final String net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1(ConfigValue cv) {
        return cv.unwrapped().toString();
    }

    private KeyStoreDescriptorParser$() {
        MODULE$ = this;
        Loggable.class.$init$((Loggable)this);
    }
}

