/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tcp;

import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.effect.concurrent.Semaphore;
import cats.effect.concurrent.Semaphore$;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$PureOps$;
import fs2.internal.FreeC;
import fs2.io.AsyncYield;
import fs2.io.AsyncYield$;
import fs2.io.tcp.Socket;
import fs2.io.tcp.Socket$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$$eq$colon$eq$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcIJ$sp;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Socket$ {
    public static Socket$ MODULE$;

    static {
        new Socket$();
    }

    public <F> Resource<F, Socket<F>> client(InetSocketAddress to, boolean reuseAddress, int sendBufferSize, int receiveBufferSize, boolean keepAlive, boolean noDelay, AsynchronousChannelGroup AG, Concurrent<F> F2, ContextShift<F> CS) {
        return this.mkClient(to, reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay, AG, F2, AsyncYield$.MODULE$.fromAsyncAndContextShift(F2, CS));
    }

    public <F> boolean client$default$2() {
        return true;
    }

    public <F> int client$default$3() {
        return 262144;
    }

    public <F> int client$default$4() {
        return 262144;
    }

    public <F> boolean client$default$5() {
        return false;
    }

    public <F> boolean client$default$6() {
        return false;
    }

    public <F> Resource<F, Socket<F>> mkClient(InetSocketAddress to, boolean reuseAddress, int sendBufferSize, int receiveBufferSize, boolean keepAlive, boolean noDelay, AsynchronousChannelGroup AG, Concurrent<F> F2, AsyncYield<F> Y) {
        return Resource$.MODULE$.liftF(implicits$.MODULE$.toFlatMapOps(Socket$.setup$1(F2, AG, reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay), F2).flatMap((Function1<AsynchronousSocketChannel, Object> & Serializable & scala.Serializable)ch -> Socket$.connect$1(ch, Y, to)), F2).flatMap((Function1<AsynchronousSocketChannel, Resource> & Serializable & scala.Serializable)x$1 -> MODULE$.apply((AsynchronousSocketChannel)x$1, F2, Y));
    }

    public <F> boolean mkClient$default$2() {
        return true;
    }

    public <F> int mkClient$default$3() {
        return 262144;
    }

    public <F> int mkClient$default$4() {
        return 262144;
    }

    public <F> boolean mkClient$default$5() {
        return false;
    }

    public <F> boolean mkClient$default$6() {
        return false;
    }

    public <F> FreeC<?, BoxedUnit> server(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Concurrent<F> F2, ContextShift<F> CS) {
        return Stream$.MODULE$.collect$extension(this.serverWithLocalAddress(address, maxQueued, reuseAddress, receiveBufferSize, AG, F2, CS), new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Either<InetSocketAddress, Resource<F, Socket<F>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Right) {
                    Right right = (Right)A1;
                    Resource s2 = (Resource)right.value();
                    object = s2;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Either<InetSocketAddress, Resource<F, Socket<F>>> x1) {
                Either<InetSocketAddress, Resource<F, Socket<F>>> either2 = x1;
                boolean bl = either2 instanceof Right;
                return bl;
            }
        });
    }

    public <F> int server$default$2() {
        return 0;
    }

    public <F> boolean server$default$3() {
        return true;
    }

    public <F> int server$default$4() {
        return 262144;
    }

    public <F> FreeC<?, BoxedUnit> serverWithLocalAddress(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Concurrent<F> F2, ContextShift<F> CS) {
        return this.mkServerWithLocalAddress(address, maxQueued, reuseAddress, receiveBufferSize, AG, F2, AsyncYield$.MODULE$.fromAsyncAndContextShift(F2, CS));
    }

    public <F> int serverWithLocalAddress$default$2() {
        return 0;
    }

    public <F> boolean serverWithLocalAddress$default$3() {
        return true;
    }

    public <F> int serverWithLocalAddress$default$4() {
        return 262144;
    }

    public <F> FreeC<?, BoxedUnit> mkServerWithLocalAddress(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Concurrent<F> F2, AsyncYield<F> Y) {
        Object setup = F2.delay((Function0<AsynchronousServerSocketChannel> & Serializable & scala.Serializable)() -> {
            AsynchronousServerSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousServerSocketChannel(AG);
            ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress));
            ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize));
            ch.bind(address);
            return ch;
        });
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(setup, (Function1<AsynchronousServerSocketChannel, Object> & Serializable & scala.Serializable)sch -> Socket$.cleanup$1(sch, F2)), (Function1<AsynchronousServerSocketChannel, Object> & Serializable & scala.Serializable)sch -> new Stream(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.emit(package$.MODULE$.Left().apply((InetSocketAddress)sch.getLocalAddress())), (Function0<Object> & Serializable & scala.Serializable)() -> new Stream(Stream$.MODULE$.map$extension(Socket$.acceptIncoming$1(sch, Y$2, F$2), (Function1<Resource, Right> & Serializable & scala.Serializable)x$2 -> package$.MODULE$.Right().apply(x$2))))));
    }

    public <F> int mkServerWithLocalAddress$default$2() {
        return 0;
    }

    public <F> boolean mkServerWithLocalAddress$default$3() {
        return true;
    }

    public <F> int mkServerWithLocalAddress$default$4() {
        return 262144;
    }

    private <F> Resource<F, Socket<F>> apply(AsynchronousSocketChannel ch, Concurrent<F> F2, AsyncYield<F> Y) {
        F socket = implicits$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, F2), F2).flatMap((Function1<Semaphore, Object> & Serializable & scala.Serializable)readSemaphore -> implicits$.MODULE$.toFunctorOps(Ref$.MODULE$.of(ByteBuffer.allocate(0), F2), F2).map((Function1<Ref, Socket> & Serializable & scala.Serializable)bufferRef -> new Socket<F>(F2, ch, (Semaphore)readSemaphore, (Ref)bufferRef, Y){
            private final Concurrent F$3;
            private final AsynchronousSocketChannel ch$2;
            private final Semaphore readSemaphore$1;
            private final Ref bufferRef$1;
            private final AsyncYield Y$3;

            public Option<FiniteDuration> read$default$2() {
                return Socket.read$default$2$(this);
            }

            public Option<FiniteDuration> reads$default$2() {
                return Socket.reads$default$2$(this);
            }

            public Option<FiniteDuration> readN$default$2() {
                return Socket.readN$default$2$(this);
            }

            public Option<FiniteDuration> write$default$2() {
                return Socket.write$default$2$(this);
            }

            public Option<FiniteDuration> writes$default$1() {
                return Socket.writes$default$1$(this);
            }

            public F readN(int numBytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$readN0$1(numBytes, timeout, this.readSemaphore$1, this.F$3, this.bufferRef$1, this.Y$3, this.ch$2);
            }

            public F read(int maxBytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$read0$1(maxBytes, timeout, this.readSemaphore$1, this.F$3, this.bufferRef$1, this.Y$3, this.ch$2);
            }

            public FreeC<?, BoxedUnit> reads(int maxBytes, Option<FiniteDuration> timeout) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(this.read(maxBytes, timeout)), (Function1<Option, Object> & Serializable & scala.Serializable)x0$1 -> new Stream<F, O>(anon.5.$anonfun$reads$1(this, maxBytes, timeout, x0$1)));
            }

            public F write(Chunk<Object> bytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$write0$1(bytes, timeout, this.Y$3, this.ch$2, this.F$3);
            }

            public Function1<FreeC<?, BoxedUnit>, FreeC<?, BoxedUnit>> writes(Option<FiniteDuration> timeout) {
                return (Function1<Object, Object> & Serializable & scala.Serializable)x$8 -> new Stream<F, O>(anon.5.$anonfun$writes$1(this, timeout, ((Stream)x$8).fs2$Stream$$free()));
            }

            public F localAddress() {
                return this.F$3.delay((Function0<SocketAddress> & Serializable & scala.Serializable)() -> $this.ch$2.getLocalAddress());
            }

            public F remoteAddress() {
                return this.F$3.delay((Function0<SocketAddress> & Serializable & scala.Serializable)() -> $this.ch$2.getRemoteAddress());
            }

            public F close() {
                return this.F$3.delay((JFunction0$mcV$sp & scala.Serializable)() -> $this.ch$2.close());
            }

            public F endOfOutput() {
                return this.F$3.delay((JFunction0$mcV$sp & scala.Serializable)() -> $this.ch$2.shutdownOutput());
            }

            public F endOfInput() {
                return this.F$3.delay((JFunction0$mcV$sp & scala.Serializable)() -> $this.ch$2.shutdownInput());
            }

            public static final /* synthetic */ FreeC $anonfun$reads$2(anon.5 $this, int maxBytes$1, Option timeout$3) {
                return $this.reads(maxBytes$1, timeout$3);
            }

            public static final /* synthetic */ FreeC $anonfun$reads$1(anon.5 $this, int maxBytes$1, Option timeout$3, Option x0$1) {
                FreeC<?, BoxedUnit> freeC;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Chunk bytes = (Chunk)some.value();
                    freeC = Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(bytes), (Function0<Object> & Serializable & scala.Serializable)() -> new Stream<F, O>(anon.5.$anonfun$reads$2($this, maxBytes$1, timeout$3)));
                } else if (None$.MODULE$.equals(option)) {
                    freeC = Stream$.MODULE$.empty();
                } else {
                    throw new MatchError(option);
                }
                return freeC;
            }

            public static final /* synthetic */ FreeC $anonfun$writes$2(anon.5 $this, Option timeout$4, Chunk bs) {
                return Stream$.MODULE$.eval($this.write(bs, timeout$4));
            }

            public static final /* synthetic */ FreeC $anonfun$writes$1(anon.5 $this, Option timeout$4, FreeC x$8) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.chunks$extension(x$8), (Function1<Chunk, Object> & Serializable & scala.Serializable)bs -> new Stream<F, O>(anon.5.$anonfun$writes$2($this, timeout$4, bs)));
            }
            {
                this.F$3 = F$3;
                this.ch$2 = ch$2;
                this.readSemaphore$1 = readSemaphore$1;
                this.bufferRef$1 = bufferRef$1;
                this.Y$3 = Y$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reads$1$adapted(fs2.io.tcp.Socket$$anon$5 int scala.Option scala.Option ), $anonfun$writes$1$adapted(fs2.io.tcp.Socket$$anon$5 scala.Option java.lang.Object ), $anonfun$localAddress$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$remoteAddress$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$close$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$endOfOutput$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$endOfInput$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$reads$2$adapted(fs2.io.tcp.Socket$$anon$5 int scala.Option ), $anonfun$writes$2$adapted(fs2.io.tcp.Socket$$anon$5 scala.Option fs2.Chunk )}, serializedLambda);
            }
        }));
        return Resource$.MODULE$.make(socket, (Function1<Socket, Object> & Serializable & scala.Serializable)x$9 -> implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(F2.delay((JFunction0$mcV$sp & scala.Serializable)() -> {
            block0: {
                if (!ch.isOpen()) break block0;
                ch.close();
            }
        }), F2), F2), F2).void(), F2);
    }

    private static final Object setup$1(Concurrent F$1, AsynchronousChannelGroup AG$1, boolean reuseAddress$1, int sendBufferSize$1, int receiveBufferSize$1, boolean keepAlive$1, boolean noDelay$1) {
        return F$1.delay((Function0<AsynchronousSocketChannel> & Serializable & scala.Serializable)() -> {
            AsynchronousSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousSocketChannel(AG$1);
            ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress$1));
            ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, Predef$.MODULE$.int2Integer(sendBufferSize$1));
            ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize$1));
            ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, Predef$.MODULE$.boolean2Boolean(keepAlive$1));
            ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(noDelay$1));
            return ch;
        });
    }

    private static final Object connect$1(AsynchronousSocketChannel ch, AsyncYield Y$1, InetSocketAddress to$1) {
        return Y$1.asyncYield((Function1<Function1, Object> & Serializable & scala.Serializable)cb -> {
            ch.connect(to$1, null, new CompletionHandler<Void, Void>(cb, ch){
                private final Function1 cb$1;
                private final AsynchronousSocketChannel ch$1;

                public void completed(Void result2, Void attachment) {
                    this.cb$1.apply(package$.MODULE$.Right().apply(this.ch$1));
                }

                public void failed(Throwable rsn, Void attachment) {
                    this.cb$1.apply(package$.MODULE$.Left().apply(rsn));
                }
                {
                    this.cb$1 = cb$1;
                    this.ch$1 = ch$1;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Object cleanup$1(AsynchronousServerSocketChannel sch, Concurrent F$2) {
        return F$2.delay((JFunction0$mcV$sp & scala.Serializable)() -> {
            block0: {
                if (!sch.isOpen()) break block0;
                sch.close();
            }
        });
    }

    private static final Object acceptChannel$1(AsyncYield Y$2, AsynchronousServerSocketChannel sch$2) {
        return Y$2.asyncYield((Function1<Function1, Object> & Serializable & scala.Serializable)cb -> {
            sch$2.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(cb){
                private final Function1 cb$2;

                public void completed(AsynchronousSocketChannel ch, Void attachment) {
                    this.cb$2.apply(package$.MODULE$.Right().apply(ch));
                }

                public void failed(Throwable rsn, Void attachment) {
                    this.cb$2.apply(package$.MODULE$.Left().apply(rsn));
                }
                {
                    this.cb$2 = cb$2;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ FreeC $anonfun$mkServerWithLocalAddress$4(Concurrent F$2, AsyncYield Y$2, Either x0$1) {
        FreeC<?, BoxedUnit> freeC;
        Either either2 = x0$1;
        if (either2 instanceof Left) {
            freeC = Stream$PureOps$.MODULE$.apply$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()));
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            AsynchronousSocketChannel accepted = (AsynchronousSocketChannel)right.value();
            freeC = Stream$.MODULE$.emit(MODULE$.apply(accepted, F$2, Y$2));
        } else {
            throw new MatchError(either2);
        }
        return freeC;
    }

    private static final FreeC go$1(AsyncYield Y$2, AsynchronousServerSocketChannel sch$2, Concurrent F$2) {
        return Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(Socket$.acceptChannel$1(Y$2, sch$2), F$2), F$2)), (Function1<Either, Object> & Serializable & scala.Serializable)x0$1 -> new Stream(Socket$.$anonfun$mkServerWithLocalAddress$4(F$2, Y$2, x0$1))), (Function0<Object> & Serializable & scala.Serializable)() -> new Stream(Socket$.go$1(Y$2, sch$2, F$2)));
    }

    public static final /* synthetic */ FreeC $anonfun$mkServerWithLocalAddress$6(AsynchronousServerSocketChannel sch$2, Concurrent F$2, Throwable x0$1) {
        FreeC<?, BoxedUnit> freeC;
        Throwable throwable = x0$1;
        if (throwable instanceof AsynchronousCloseException) {
            AsynchronousCloseException asynchronousCloseException = (AsynchronousCloseException)throwable;
            freeC = sch$2.isOpen() ? Stream$.MODULE$.raiseError(asynchronousCloseException, RaiseThrowable$.MODULE$.fromApplicativeError(F$2)) : Stream$.MODULE$.empty();
        } else {
            freeC = Stream$.MODULE$.raiseError(throwable, RaiseThrowable$.MODULE$.fromApplicativeError(F$2));
        }
        return freeC;
    }

    private static final FreeC acceptIncoming$1(AsynchronousServerSocketChannel sch, AsyncYield Y$2, Concurrent F$2) {
        return Stream$.MODULE$.handleErrorWith$extension(Socket$.go$1(Y$2, sch, F$2), (Function1<Throwable, Object> & Serializable & scala.Serializable)x0$1 -> new Stream(Socket$.$anonfun$mkServerWithLocalAddress$6(sch, F$2, x0$1)));
    }

    public static final /* synthetic */ void $anonfun$apply$3(AsynchronousSocketChannel ch$2, ByteBuffer buff$1, long timeoutMs$1, Function1 cb) {
        long started = System.currentTimeMillis();
        ch$2.read(buff$1, timeoutMs$1, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler<Integer, BoxedUnit>(started, cb){
            private final long started$1;
            private final Function1 cb$3;

            public void completed(Integer result2, BoxedUnit attachment) {
                long took = System.currentTimeMillis() - this.started$1;
                this.cb$3.apply(package$.MODULE$.Right().apply(new Tuple2$mcIJ$sp(Predef$.MODULE$.Integer2int(result2), took)));
            }

            public void failed(Throwable err, BoxedUnit attachment) {
                this.cb$3.apply(package$.MODULE$.Left().apply(err));
            }
            {
                this.started$1 = started$1;
                this.cb$3 = cb$3;
            }
        });
    }

    private static final Object readChunk$1(ByteBuffer buff, long timeoutMs, AsyncYield Y$3, AsynchronousSocketChannel ch$2) {
        return Y$3.asyncYield((Function1<Function1, Object> & Serializable & scala.Serializable)cb -> {
            Socket$.$anonfun$apply$3(ch$2, buff, timeoutMs, cb);
            return BoxedUnit.UNIT;
        });
    }

    private static final Object getBufferOf$1(int sz, Ref bufferRef$1, Concurrent F$3) {
        return implicits$.MODULE$.toFlatMapOps(bufferRef$1.get(), F$3).flatMap((Function1<ByteBuffer, Object> & Serializable & scala.Serializable)buff -> buff.capacity() < sz ? implicits$.MODULE$.toFlatMapOps(F$3.delay((Function0<ByteBuffer> & Serializable & scala.Serializable)() -> ByteBuffer.allocate(sz)), F$3).flatTap((Function1<ByteBuffer, Object> & Serializable & scala.Serializable)a -> bufferRef$1.set(a)) : F$3.delay((Function0<ByteBuffer> & Serializable & scala.Serializable)() -> {
            ((Buffer)buff).clear();
            ((Buffer)buff).limit(sz);
            return buff;
        }));
    }

    private static final Object releaseBuffer$1(ByteBuffer buff, Concurrent F$3) {
        return F$3.delay((Function0<Chunk> & Serializable & scala.Serializable)() -> {
            void var2_3;
            Chunk<Object> chunk;
            int read = buff.position();
            if (read == 0) {
                chunk = Chunk$.MODULE$.bytes((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            } else {
                byte[] dest = new byte[read];
                ((Buffer)buff).flip();
                buff.get(dest);
                chunk = Chunk$.MODULE$.bytes(dest);
            }
            Chunk<Object> result2 = chunk;
            ((Buffer)buff).clear();
            return var2_3;
        });
    }

    public static final Object fs2$io$tcp$Socket$$read0$1(int max2, Option timeout, Semaphore readSemaphore$1, Concurrent F$3, Ref bufferRef$1, AsyncYield Y$3, AsynchronousSocketChannel ch$2) {
        return readSemaphore$1.withPermit(implicits$.MODULE$.toFlatMapOps(F$3.attempt(implicits$.MODULE$.toFlatMapOps(Socket$.getBufferOf$1(max2, bufferRef$1, F$3), F$3).flatMap((Function1<ByteBuffer, Object> & Serializable & scala.Serializable)buff -> implicits$.MODULE$.toFlatMapOps(Socket$.readChunk$1(buff, BoxesRunTime.unboxToLong(timeout.map((Function1<FiniteDuration, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong(x$3.toMillis())).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> 0L)), Y$3, ch$2), F$3).flatMap((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int read = tuple2._1$mcI$sp();
            Object f = read < 0 ? F$3.pure(None$.MODULE$) : implicits$.MODULE$.toFunctorOps(Socket$.releaseBuffer$1(buff, F$3), F$3).map((Function1<Chunk, Some> & Serializable & scala.Serializable)x$4 -> new Some<Chunk>((Chunk)x$4));
            return f;
        }))), F$3).flatMap((Function1<Either, Object> & Serializable & scala.Serializable)x0$2 -> {
            Object f;
            Either either2 = x0$2;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable err = (Throwable)left.value();
                f = F$3.raiseError(err);
            } else if (either2 instanceof Right) {
                Right right = (Right)either2;
                Option maybeChunk = (Option)right.value();
                f = F$3.pure(maybeChunk);
            } else {
                throw new MatchError(either2);
            }
            return f;
        }));
    }

    private static final Object go$2(long timeoutMs, ByteBuffer buff$5, Concurrent F$3, int max$1, AsyncYield Y$3, AsynchronousSocketChannel ch$2) {
        return implicits$.MODULE$.toFlatMapOps(Socket$.readChunk$1(buff$5, timeoutMs, Y$3, ch$2), F$3).flatMap((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int readBytes = tuple2._1$mcI$sp();
            long took = tuple2._2$mcJ$sp();
            Object object = readBytes < 0 || buff$5.position() >= max$1 ? implicits$.MODULE$.toFunctorOps(Socket$.releaseBuffer$1(buff$5, F$3), F$3).map((Function1<Chunk, Some> & Serializable & scala.Serializable)x$5 -> new Some<Chunk>((Chunk)x$5)) : Socket$.go$2(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timeoutMs - took), 0L), buff$5, F$3, max$1, Y$3, ch$2);
            return object;
        });
    }

    public static final Object fs2$io$tcp$Socket$$readN0$1(int max2, Option timeout, Semaphore readSemaphore$1, Concurrent F$3, Ref bufferRef$1, AsyncYield Y$3, AsynchronousSocketChannel ch$2) {
        return readSemaphore$1.withPermit(implicits$.MODULE$.toFlatMapOps(F$3.attempt(implicits$.MODULE$.toFlatMapOps(Socket$.getBufferOf$1(max2, bufferRef$1, F$3), F$3).flatMap((Function1<ByteBuffer, Object> & Serializable & scala.Serializable)buff -> Socket$.go$2(BoxesRunTime.unboxToLong(timeout.map((Function1<FiniteDuration, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong(x$6.toMillis())).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> 0L)), buff, F$3, max2, Y$3, ch$2))), F$3).flatMap((Function1<Either, Object> & Serializable & scala.Serializable)x0$1 -> {
            Object f;
            Either either2 = x0$1;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable err = (Throwable)left.value();
                f = F$3.raiseError(err);
            } else if (either2 instanceof Right) {
                Right right = (Right)either2;
                Option maybeChunk = (Option)right.value();
                f = F$3.pure(maybeChunk);
            } else {
                throw new MatchError(either2);
            }
            return f;
        }));
    }

    public static final /* synthetic */ void $anonfun$apply$21(AsynchronousSocketChannel ch$2, ByteBuffer buff$6, long remains$1, Function1 cb) {
        long start = System.currentTimeMillis();
        ch$2.write(buff$6, remains$1, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler<Integer, BoxedUnit>(cb, buff$6, start){
            private final Function1 cb$4;
            private final ByteBuffer buff$6;
            private final long start$1;

            public void completed(Integer result2, BoxedUnit attachment) {
                this.cb$4.apply(package$.MODULE$.Right().apply(this.buff$6.remaining() <= 0 ? None$.MODULE$ : new Some<Long>(BoxesRunTime.boxToLong(System.currentTimeMillis() - this.start$1))));
            }

            public void failed(Throwable err, BoxedUnit attachment) {
                this.cb$4.apply(package$.MODULE$.Left().apply(err));
            }
            {
                this.cb$4 = cb$4;
                this.buff$6 = buff$6;
                this.start$1 = start$1;
            }
        });
    }

    private static final Object go$3(ByteBuffer buff, long remains, AsyncYield Y$3, AsynchronousSocketChannel ch$2, Concurrent F$3) {
        return implicits$.MODULE$.toFlatMapOps(Y$3.asyncYield((Function1<Function1, Object> & Serializable & scala.Serializable)cb -> {
            Socket$.$anonfun$apply$21(ch$2, buff, remains, cb);
            return BoxedUnit.UNIT;
        }), F$3).flatMap((Function1<Option, Object> & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                object = F$3.pure(BoxedUnit.UNIT);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long took = BoxesRunTime.unboxToLong(some.value());
                object = Socket$.go$3(buff, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(remains - took), 0L), Y$3, ch$2, F$3);
            } else {
                throw new MatchError(option);
            }
            return object;
        });
    }

    public static final Object fs2$io$tcp$Socket$$write0$1(Chunk bytes, Option timeout, AsyncYield Y$3, AsynchronousSocketChannel ch$2, Concurrent F$3) {
        return Socket$.go$3(bytes.toBytes(Predef$$eq$colon$eq$.MODULE$.tpEquals()).toByteBuffer(Predef$$eq$colon$eq$.MODULE$.tpEquals()), BoxesRunTime.unboxToLong(timeout.map((Function1<FiniteDuration, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong(x$7.toMillis())).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> 0L)), Y$3, ch$2, F$3);
    }

    private Socket$() {
        MODULE$ = this;
    }
}

