/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public class FieldType
implements IndexableFieldType {
    private boolean stored;
    private boolean tokenized = true;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean frozen;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private int dataDimensionCount;
    private int indexDimensionCount;
    private int dimensionNumBytes;
    private Map<String, String> attributes;

    public FieldType(IndexableFieldType ref) {
        this.stored = ref.stored();
        this.tokenized = ref.tokenized();
        this.storeTermVectors = ref.storeTermVectors();
        this.storeTermVectorOffsets = ref.storeTermVectorOffsets();
        this.storeTermVectorPositions = ref.storeTermVectorPositions();
        this.storeTermVectorPayloads = ref.storeTermVectorPayloads();
        this.omitNorms = ref.omitNorms();
        this.indexOptions = ref.indexOptions();
        this.docValuesType = ref.docValuesType();
        this.dataDimensionCount = ref.pointDataDimensionCount();
        this.indexDimensionCount = ref.pointIndexDimensionCount();
        this.dimensionNumBytes = ref.pointNumBytes();
        if (ref.getAttributes() != null) {
            this.attributes = new HashMap<String, String>(ref.getAttributes());
        }
    }

    public FieldType() {
    }

    protected void checkIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("this FieldType is already frozen and cannot be changed");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public void setStored(boolean value) {
        this.checkIfFrozen();
        this.stored = value;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public void setTokenized(boolean value) {
        this.checkIfFrozen();
        this.tokenized = value;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public void setStoreTermVectors(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectors = value;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    public void setStoreTermVectorOffsets(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorOffsets = value;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    public void setStoreTermVectorPositions(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPositions = value;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    public void setStoreTermVectorPayloads(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPayloads = value;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean value) {
        this.checkIfFrozen();
        this.omitNorms = value;
    }

    @Override
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions value) {
        this.checkIfFrozen();
        if (value == null) {
            throw new NullPointerException("IndexOptions must not be null");
        }
        this.indexOptions = value;
    }

    public void setDimensions(int dimensionCount, int dimensionNumBytes) {
        this.setDimensions(dimensionCount, dimensionCount, dimensionNumBytes);
    }

    public void setDimensions(int dataDimensionCount, int indexDimensionCount, int dimensionNumBytes) {
        if (dataDimensionCount < 0) {
            throw new IllegalArgumentException("dataDimensionCount must be >= 0; got " + dataDimensionCount);
        }
        if (dataDimensionCount > 8) {
            throw new IllegalArgumentException("dataDimensionCount must be <= 8; got " + dataDimensionCount);
        }
        if (indexDimensionCount < 0) {
            throw new IllegalArgumentException("indexDimensionCount must be >= 0; got " + indexDimensionCount);
        }
        if (indexDimensionCount > dataDimensionCount) {
            throw new IllegalArgumentException("indexDimensionCount must be <= dataDimensionCount: " + dataDimensionCount + "; got " + indexDimensionCount);
        }
        if (dimensionNumBytes < 0) {
            throw new IllegalArgumentException("dimensionNumBytes must be >= 0; got " + dimensionNumBytes);
        }
        if (dimensionNumBytes > 16) {
            throw new IllegalArgumentException("dimensionNumBytes must be <= 16; got " + dimensionNumBytes);
        }
        if (dataDimensionCount == 0) {
            if (indexDimensionCount != 0) {
                throw new IllegalArgumentException("when dataDimensionCount is 0, indexDimensionCount must be 0; got " + indexDimensionCount);
            }
            if (dimensionNumBytes != 0) {
                throw new IllegalArgumentException("when dataDimensionCount is 0, dimensionNumBytes must be 0; got " + dimensionNumBytes);
            }
        } else {
            if (indexDimensionCount == 0) {
                throw new IllegalArgumentException("when dataDimensionCount is > 0, indexDimensionCount must be > 0; got " + indexDimensionCount);
            }
            if (dimensionNumBytes == 0 && dataDimensionCount != 0) {
                throw new IllegalArgumentException("when dimensionNumBytes is 0, dataDimensionCount must be 0; got " + dataDimensionCount);
            }
        }
        this.dataDimensionCount = dataDimensionCount;
        this.indexDimensionCount = indexDimensionCount;
        this.dimensionNumBytes = dimensionNumBytes;
    }

    @Override
    public int pointDataDimensionCount() {
        return this.dataDimensionCount;
    }

    @Override
    public int pointIndexDimensionCount() {
        return this.indexDimensionCount;
    }

    @Override
    public int pointNumBytes() {
        return this.dimensionNumBytes;
    }

    public String putAttribute(String key, String value) {
        this.checkIfFrozen();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes.put(key, value);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.stored()) {
            result2.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("indexed");
            if (this.tokenized()) {
                result2.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                result2.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                result2.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                result2.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                result2.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                result2.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                result2.append(",indexOptions=");
                result2.append((Object)this.indexOptions);
            }
        }
        if (this.dataDimensionCount != 0) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("pointDataDimensionCount=");
            result2.append(this.dataDimensionCount);
            result2.append(",pointIndexDimensionCount=");
            result2.append(this.indexDimensionCount);
            result2.append(",pointNumBytes=");
            result2.append(this.dimensionNumBytes);
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("docValuesType=");
            result2.append((Object)this.docValuesType);
        }
        return result2.toString();
    }

    @Override
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public void setDocValuesType(DocValuesType type) {
        this.checkIfFrozen();
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null");
        }
        this.docValuesType = type;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.dataDimensionCount;
        result2 = 31 * result2 + this.indexDimensionCount;
        result2 = 31 * result2 + this.dimensionNumBytes;
        result2 = 31 * result2 + (this.docValuesType == null ? 0 : this.docValuesType.hashCode());
        result2 = 31 * result2 + this.indexOptions.hashCode();
        result2 = 31 * result2 + (this.omitNorms ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorOffsets ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorPayloads ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorPositions ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectors ? 1231 : 1237);
        result2 = 31 * result2 + (this.stored ? 1231 : 1237);
        result2 = 31 * result2 + (this.tokenized ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other = (FieldType)obj;
        if (this.dataDimensionCount != other.dataDimensionCount) {
            return false;
        }
        if (this.indexDimensionCount != other.indexDimensionCount) {
            return false;
        }
        if (this.dimensionNumBytes != other.dimensionNumBytes) {
            return false;
        }
        if (this.docValuesType != other.docValuesType) {
            return false;
        }
        if (this.indexOptions != other.indexOptions) {
            return false;
        }
        if (this.omitNorms != other.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != other.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != other.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != other.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != other.storeTermVectors) {
            return false;
        }
        if (this.stored != other.stored) {
            return false;
        }
        return this.tokenized == other.tokenized;
    }
}

