/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static Automaton minimize(Automaton a, int maxDeterminizedStates) {
        int n;
        int j;
        int x2;
        int q;
        if (a.getNumStates() == 0 || !a.isAccept(0) && a.getNumTransitions(0) == 0) {
            return new Automaton();
        }
        if ((a = Operations.determinize(a, maxDeterminizedStates)).getNumTransitions(0) == 1) {
            Transition t = new Transition();
            a.getTransition(0, 0, t);
            if (t.dest == 0 && t.min == 0 && t.max == 0x10FFFF) {
                return a;
            }
        }
        a = Operations.totalize(a);
        int[] sigma = a.getStartPoints();
        int sigmaLen = sigma.length;
        int statesLen = a.getNumStates();
        ArrayList[][] reverse = new ArrayList[statesLen][sigmaLen];
        HashSet[] partition = new HashSet[statesLen];
        ArrayList[] splitblock = new ArrayList[statesLen];
        int[] block = new int[statesLen];
        StateList[][] active = new StateList[statesLen][sigmaLen];
        StateListNode[][] active2 = new StateListNode[statesLen][sigmaLen];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        BitSet pending2 = new BitSet(sigmaLen * statesLen);
        BitSet split = new BitSet(statesLen);
        BitSet refine = new BitSet(statesLen);
        BitSet refine2 = new BitSet(statesLen);
        for (q = 0; q < statesLen; ++q) {
            splitblock[q] = new ArrayList();
            partition[q] = new HashSet();
            for (x2 = 0; x2 < sigmaLen; ++x2) {
                active[q][x2] = new StateList();
            }
        }
        for (q = 0; q < statesLen; ++q) {
            j = a.isAccept(q) ? 0 : 1;
            partition[j].add(q);
            block[q] = j;
            for (int x3 = 0; x3 < sigmaLen; ++x3) {
                ArrayList[] r = reverse[a.step(q, sigma[x3])];
                if (r[x3] == null) {
                    r[x3] = new ArrayList();
                }
                r[x3].add(q);
            }
        }
        for (int j2 = 0; j2 <= 1; ++j2) {
            for (x2 = 0; x2 < sigmaLen; ++x2) {
                Iterator x3 = partition[j2].iterator();
                while (x3.hasNext()) {
                    int q2 = (Integer)x3.next();
                    if (reverse[q2][x2] == null) continue;
                    active2[q2][x2] = active[j2][x2].add(q2);
                }
            }
        }
        for (int x4 = 0; x4 < sigmaLen; ++x4) {
            j = active[0][x4].size <= active[1][x4].size ? 0 : 1;
            pending.add(new IntPair(j, x4));
            pending2.set(x4 * statesLen + j);
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x5 = ip.n2;
            pending2.clear(x5 * statesLen + p);
            StateListNode m = active[p][x5].first;
            while (m != null) {
                ArrayList r = reverse[m.q][x5];
                if (r != null) {
                    Iterator iterator = r.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        if (split.get(i)) continue;
                        split.set(i);
                        int j3 = block[i];
                        splitblock[j3].add(i);
                        if (refine2.get(j3)) continue;
                        refine2.set(j3);
                        refine.set(j3);
                    }
                }
                m = m.next;
            }
            int j4 = refine.nextSetBit(0);
            while (j4 >= 0) {
                Object b1;
                ArrayList sb = splitblock[j4];
                if (sb.size() < partition[j4].size()) {
                    b1 = partition[j4];
                    HashSet b2 = partition[k];
                    Iterator j3 = sb.iterator();
                    while (j3.hasNext()) {
                        int s2 = (Integer)j3.next();
                        ((HashSet)b1).remove(s2);
                        b2.add(s2);
                        block[s2] = k;
                        for (int c = 0; c < sigmaLen; ++c) {
                            StateListNode sn = active2[s2][c];
                            if (sn == null || sn.sl != active[j4][c]) continue;
                            sn.remove();
                            active2[s2][c] = active[k][c].add(s2);
                        }
                    }
                    for (int c = 0; c < sigmaLen; ++c) {
                        int aj = active[j4][c].size;
                        int ak = active[k][c].size;
                        int ofs = c * statesLen;
                        if (!pending2.get(ofs + j4) && 0 < aj && aj <= ak) {
                            pending2.set(ofs + j4);
                            pending.add(new IntPair(j4, c));
                            continue;
                        }
                        pending2.set(ofs + k);
                        pending.add(new IntPair(k, c));
                    }
                    ++k;
                }
                refine2.clear(j4);
                b1 = sb.iterator();
                while (b1.hasNext()) {
                    int s3 = (Integer)b1.next();
                    split.clear(s3);
                }
                sb.clear();
                j4 = refine.nextSetBit(j4 + 1);
            }
            refine.clear();
        }
        Automaton result2 = new Automaton();
        Transition t = new Transition();
        int[] stateMap = new int[statesLen];
        int[] stateRep = new int[k];
        result2.createState();
        for (n = 0; n < k; ++n) {
            boolean isInitial = false;
            Iterator s3 = partition[n].iterator();
            while (s3.hasNext()) {
                int q3 = (Integer)s3.next();
                if (q3 != 0) continue;
                isInitial = true;
                break;
            }
            int newState = isInitial ? 0 : result2.createState();
            Iterator iterator = partition[n].iterator();
            while (iterator.hasNext()) {
                int q4 = (Integer)iterator.next();
                stateMap[q4] = newState;
                result2.setAccept(newState, a.isAccept(q4));
                stateRep[newState] = q4;
            }
        }
        for (n = 0; n < k; ++n) {
            int numTransitions = a.initTransition(stateRep[n], t);
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                result2.addTransition(n, stateMap[t.dest], t.min, t.max);
            }
        }
        result2.finishState();
        return Operations.removeDeadStates(result2);
    }

    static final class StateListNode {
        final int q;
        StateListNode next;
        StateListNode prev;
        final StateList sl;

        StateListNode(int q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static final class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(int q) {
            return new StateListNode(q, this);
        }
    }

    static final class IntPair {
        final int n1;
        final int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }
}

