/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry$minusAfter;
import org.http4s.headers.Retry$minusAfter$;
import org.http4s.util.CaseInsensitiveString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static Retry$ MODULE$;
    private final Logger logger;

    static {
        new Retry$();
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CaseInsensitiveString, Object> redactHeaderWhen, Client<F> client, Sync<F> F2, Timer<F> T) {
        return Client$.MODULE$.apply((Function1<Request, Resource> & Serializable & scala.Serializable)x$1 -> Retry$.prepareLoop$1(x$1, 1, client, F2, policy, redactHeaderWhen, T), F2);
    }

    public <F> Function1<CaseInsensitiveString, Object> apply$default$2() {
        return (Function1<CaseInsensitiveString, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(Retry$.$anonfun$apply$default$2$1(elem));
    }

    public <F> Client<F> retryWithRedactedHeaders(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CaseInsensitiveString, Object> redactHeaderWhen, Client<F> client, Sync<F> F2, Timer<F> T) {
        return this.apply(policy, redactHeaderWhen, client, F2, T);
    }

    private static final Resource prepareLoop$1(Request req, int attempts, Client client$1, Sync F$1, Function3 policy$1, Function1 redactHeaderWhen$1, Timer T$1) {
        return ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(client$1.run(req), Resource$.MODULE$.catsEffectMonadErrorForResource(F$1)), Resource$.MODULE$.catsEffectMonadErrorForResource(F$1)).flatMap((Function1<Either, Resource> & Serializable & scala.Serializable)x0$1 -> {
            Resource resource;
            Either either2 = x0$1;
            if (either2 instanceof Right) {
                Resource resource2;
                Right right = (Right)either2;
                Response response = (Response)right.value();
                Option option = (Option)policy$1.apply(req, right, BoxesRunTime.boxToInteger(attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(63).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" has failed on attempt #").append(attempts).append(" with reason ").append(response.status()).append(". Retrying after ").append(duration).append(".").toString());
                    }
                    resource2 = Retry$.nextAttempt$1(req, attempts, duration, Headers$.MODULE$.get$extension0(response.headers(), Retry$minusAfter$.MODULE$), T$1, F$1, client$1, policy$1, redactHeaderWhen$1);
                } else if (None$.MODULE$.equals(option)) {
                    resource2 = Resource$.MODULE$.pure(response, F$1);
                } else {
                    throw new MatchError(option);
                }
                resource = resource2;
            } else if (either2 instanceof Left) {
                Resource resource3;
                Left left = (Left)either2;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply(req, left, BoxesRunTime.boxToInteger(attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts).append(". Retrying after ").append(duration).toString(), e);
                    }
                    resource3 = Retry$.nextAttempt$1(req, attempts, duration, None$.MODULE$, T$1, F$1, client$1, policy$1, redactHeaderWhen$1);
                } else if (None$.MODULE$.equals(option)) {
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(52).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" threw an exception on attempt #").append(attempts).append(". Giving up.").toString(), e);
                    }
                    resource3 = Resource$.MODULE$.liftF(F$1.raiseError(e), F$1);
                } else {
                    throw new MatchError(option);
                }
                resource = resource3;
            } else {
                throw new MatchError(either2);
            }
            return resource;
        });
    }

    private static final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.toList$extension(Headers$.MODULE$.redactSensitive$extension(request.headers(), redactWhen)).mkString(",");
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    public static final /* synthetic */ long $anonfun$apply$2(Retry$minusAfter h) {
        long l;
        Either<HttpDate, Object> either2 = h.retry();
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            HttpDate d = (HttpDate)left.value();
            l = Instant.now().until(d.toInstant(), ChronoUnit.SECONDS);
        } else if (either2 instanceof Right) {
            long secs;
            Right right = (Right)either2;
            l = secs = BoxesRunTime.unboxToLong(right.value());
        } else {
            throw new MatchError(either2);
        }
        return l;
    }

    private static final Resource nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Timer T$1, Sync F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1) {
        long headerDuration = BoxesRunTime.unboxToLong(retryHeader.map((Function1<Retry$minusAfter, Object> & Serializable & scala.Serializable)h -> BoxesRunTime.boxToLong(Retry$.$anonfun$apply$2(h))).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> 0L));
        FiniteDuration sleepDuration = new package.DurationLong(package$.MODULE$.DurationLong(headerDuration)).seconds().max(duration);
        return implicits$.MODULE$.catsSyntaxApply(Resource$.MODULE$.liftF(T$1.sleep(sleepDuration), F$1), Resource$.MODULE$.catsEffectMonadErrorForResource(F$1)).$times$greater(Retry$.prepareLoop$1(req, attempts + 1, client$1, F$1, policy$1, redactHeaderWhen$1, T$1));
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$2$1(CaseInsensitiveString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private Retry$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger("org.http4s.client.middleware.Retry");
    }
}

