/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.client.WaitQueueTimeoutException$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RetryPolicy$ {
    public static RetryPolicy$ MODULE$;
    private final Set<Status> RetriableStatuses;

    static {
        new RetryPolicy$();
    }

    public <F> Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> apply(Function1<Object, Option<FiniteDuration>> backoff, Function2<Request<F>, Either<Throwable, Response<F>>, Object> retriable) {
        return (Function3<Request, Either, Object, Option> & Serializable & scala.Serializable)(req, result2, retries) -> RetryPolicy$.$anonfun$apply$5(retriable, backoff, req, result2, BoxesRunTime.unboxToInt(retries));
    }

    public <F> Function2<Request<F>, Either<Throwable, Response<F>>, Object> apply$default$2() {
        return (Function2<Request, Either, Object> & Serializable & scala.Serializable)(req, result2) -> BoxesRunTime.boxToBoolean(RetryPolicy$.MODULE$.defaultRetriable(req, result2));
    }

    public Set<Status> RetriableStatuses() {
        return this.RetriableStatuses;
    }

    public <F> boolean defaultRetriable(Request<F> req, Either<Throwable, Response<F>> result2) {
        return req.method().isIdempotent() && this.isErrorOrRetriableStatus(result2);
    }

    public <F> boolean unsafeRetriable(Request<F> req, Either<Throwable, Response<F>> result2) {
        return this.defaultRetriable(req, result2);
    }

    public <F> boolean recklesslyRetriable(Either<Throwable, Response<F>> result2) {
        return this.isErrorOrRetriableStatus(result2);
    }

    private <F> boolean isErrorOrRetriableStatus(Either<Throwable, Response<F>> result2) {
        boolean bl;
        Either<Throwable, Response<F>> either2 = result2;
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Response resp = (Response)right.value();
            bl = this.RetriableStatuses().apply(resp.status());
        } else {
            Left left;
            Throwable throwable;
            bl = !(either2 instanceof Left) || !WaitQueueTimeoutException$.MODULE$.equals(throwable = (Throwable)(left = (Left)either2).value());
        }
        return bl;
    }

    public Function1<Object, Option<FiniteDuration>> exponentialBackoff(Duration maxWait, int maxRetry) {
        long maxInMillis = maxWait.toMillis();
        return (Function1<Object, Option> & Serializable & scala.Serializable)k -> RetryPolicy$.$anonfun$exponentialBackoff$1(maxRetry, maxInMillis, BoxesRunTime.unboxToInt(k));
    }

    private FiniteDuration expBackoff(int k, long maxInMillis) {
        double millis = (package$.MODULE$.pow(2.0, k) - 1.0) * 1000.0;
        double interval = package$.MODULE$.min(millis, (double)maxInMillis);
        return FiniteDuration$.MODULE$.apply((long)(package$.MODULE$.random() * interval), TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ Option $anonfun$apply$5(Function2 retriable$1, Function1 backoff$1, Request req, Either result2, int retries) {
        return BoxesRunTime.unboxToBoolean(retriable$1.apply(req, result2)) ? (Option)backoff$1.apply(BoxesRunTime.boxToInteger(retries)) : None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$exponentialBackoff$1(int maxRetry$1, long maxInMillis$1, int k) {
        return k > maxRetry$1 ? None$.MODULE$ : new Some<FiniteDuration>(MODULE$.expBackoff(k, maxInMillis$1));
    }

    private RetryPolicy$() {
        MODULE$ = this;
        this.RetriableStatuses = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Status[]{Status$.MODULE$.RequestTimeout(), Status$.MODULE$.InternalServerError(), Status$.MODULE$.ServiceUnavailable(), Status$.MODULE$.BadGateway(), Status$.MODULE$.GatewayTimeout()}));
    }
}

