/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.Applicative;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.EitherObjectOps$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest;
import org.http4s.Challenge;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.package$;
import org.http4s.util.CaseInsensitiveString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenSetLike;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class DigestAuth$ {
    public static DigestAuth$ MODULE$;

    static {
        new DigestAuth$();
    }

    public <F, A> Function1<Kleisli<?, AuthedRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, F> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$1) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$1);
        return (Function1<Kleisli, Kleisli> & Serializable & scala.Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$1);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int apply$default$5() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, AuthedRequest<F, A>>> challenge(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Sync<F> F2) {
        return new Kleisli((Function1<Request, Object> & Serializable & scala.Serializable)req -> implicits$.MODULE$.toFlatMapOps(MODULE$.checkAuth(realm, store, nonceKeeper, (Request)req, F2), F2).flatMap((Function1<DigestAuth.AuthReply, Object> & Serializable & scala.Serializable)x0$1 -> {
            Object f;
            DigestAuth.AuthReply authReply = x0$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                f = F2.pure(EitherObjectOps$.MODULE$.right$extension(implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), new AuthedRequest(authInfo, req)));
            } else {
                f = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? implicits$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, true, F2), F2).map((Function1<Map, Either> & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm)) : implicits$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, false, F2), F2).map((Function1<Map, Either> & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return f;
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F, A> F checkAuth(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, Applicative<F> F2) {
        Authorization authorization;
        Option<Credentials> option;
        F f;
        boolean bl = false;
        Some some = null;
        Option<Header> option2 = Headers$.MODULE$.get$extension0(req.headers(), Authorization$.MODULE$);
        if (option2 instanceof Some) {
            Credentials credentials;
            bl = true;
            some = (Some)option2;
            Authorization authorization2 = (Authorization)some.value();
            Option<Credentials> option3 = Authorization$.MODULE$.unapply(authorization2);
            if (!option3.isEmpty() && (credentials = option3.get()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = (Credentials.AuthParams)credentials;
                CaseInsensitiveString caseInsensitiveString = authParams.authScheme();
                NonEmptyList<Tuple2<String, String>> params = authParams.params();
                CaseInsensitiveString caseInsensitiveString2 = AuthScheme$.MODULE$.Digest();
                CaseInsensitiveString caseInsensitiveString3 = caseInsensitiveString;
                if (!(caseInsensitiveString2 != null ? !((Object)caseInsensitiveString2).equals(caseInsensitiveString3) : caseInsensitiveString3 != null)) {
                    f = this.checkAuthParams(realm, store, nonceKeeper, req, params, F2);
                    return f;
                }
            }
        }
        if (bl && !(option = Authorization$.MODULE$.unapply(authorization = (Authorization)some.value())).isEmpty()) {
            f = F2.pure(DigestAuth$NoCredentials$.MODULE$);
            return f;
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
        f = F2.pure(DigestAuth$NoAuthorizationHeader$.MODULE$);
        return f;
    }

    private <F> F getChallengeParams(NonceKeeper nonceKeeper, boolean staleNonce, Sync<F> F2) {
        return F2.delay((Function0<Map> & Serializable & scala.Serializable)() -> {
            void var3_3;
            String nonce = nonceKeeper.newNonce();
            Map m = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("qop"), "auth"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("nonce"), nonce)}));
            return staleNonce ? m.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("stale"), "TRUE")) : var3_3;
        });
    }

    private <F, A> F checkAuthParams(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Applicative<F> F2) {
        F f;
        String nc;
        GenMap params = paramsNel.toList().toMap(Predef$.MODULE$.$conforms());
        if (!((GenSetLike)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf(params.keySet())) {
            return F2.pure(DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        String uri = req.uri().toString();
        Option option = params.get("realm");
        Some<String> some = new Some<String>(realm);
        if (option == null ? some != null : !option.equals(some)) {
            return F2.pure(DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply("nonce");
        NonceKeeper.Reply reply = nonceKeeper.receiveNonce(nonce, Integer.parseInt(nc = (String)params.apply("nc"), 16));
        if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
            f = F2.pure(DigestAuth$StaleNonce$.MODULE$);
        } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
            f = F2.pure(DigestAuth$BadNC$.MODULE$);
        } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
            f = implicits$.MODULE$.toFunctorOps(store.apply((String)params.apply("username")), F2).map(arg_0 -> DigestAuth$.$anonfun$checkAuthParams$1(method, (Map)params, realm, uri, nonce, nc, arg_0));
        } else {
            throw new MatchError(reply);
        }
        return f;
    }

    private static final Either paramsToChallenge$1(Map params, String realm$1) {
        return EitherObjectOps$.MODULE$.left$extension(implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), new Challenge("Digest", realm$1, params));
    }

    public static final /* synthetic */ DigestAuth.AuthReply $anonfun$checkAuthParams$1(String method$1, Map params$1, String realm$2, String uri$1, String nonce$1, String nc$1, Option x0$1) {
        Some some;
        Tuple2 tuple2;
        DigestAuth.AuthReply<Nothing$> authReply;
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            authReply = DigestAuth$UserUnknown$.MODULE$;
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String resp;
            Object authInfo = tuple2._1();
            String password = (String)tuple2._2();
            String string2 = resp = DigestUtil$.MODULE$.computeResponse(method$1, (String)params$1.apply("username"), realm$2, password, uri$1, nonce$1, nc$1, (String)params$1.apply("cnonce"), (String)params$1.apply("qop"));
            Object v = params$1.apply("response");
            authReply = !(string2 != null ? !string2.equals(v) : v != null) ? new DigestAuth.OK(authInfo) : DigestAuth$WrongResponse$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return authReply;
    }

    private DigestAuth$() {
        MODULE$ = this;
    }
}

