/*
 * Decompiled with CFR 0.152.
 */
package slick.jdbc;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TimestamptzConverter$ {
    public static TimestamptzConverter$ MODULE$;
    private final Class<?> timestampTZClass;
    private final Constructor<?> timestampTZCtor;
    private final Method timestampTZToBytes;
    private final Class<?> zoneIdClass;
    private final Method zoneIdgetId;
    private final Method zoneIdgetRegion;
    private final int REGIONIDBIT;
    private final int OFFSET_HOUR;
    private final int OFFSET_MINUTE;
    private final int highBits;
    private final int lowBits;
    private final int msb;
    private final int lsb;

    static {
        new TimestamptzConverter$();
    }

    public Class<?> timestampTZClass() {
        return this.timestampTZClass;
    }

    public Constructor<?> timestampTZCtor() {
        return this.timestampTZCtor;
    }

    public Method timestampTZToBytes() {
        return this.timestampTZToBytes;
    }

    public Class<?> zoneIdClass() {
        return this.zoneIdClass;
    }

    public Method zoneIdgetId() {
        return this.zoneIdgetId;
    }

    public Method zoneIdgetRegion() {
        return this.zoneIdgetRegion;
    }

    public int REGIONIDBIT() {
        return this.REGIONIDBIT;
    }

    public Object offsetDateTimeToTimestamptz(OffsetDateTime attribute) {
        byte[] bytes = this.newTIMESTAMPTZBuffer();
        ZonedDateTime utc = attribute.atZoneSameInstant(ZoneOffset.UTC);
        this.writeDateTime(bytes, utc);
        ZoneOffset offset = attribute.getOffset();
        this.writeZoneOffset(bytes, offset);
        return this.timestampTZCtor().newInstance(new Object[]{bytes});
    }

    public OffsetDateTime timestamptzToOffsetDateTime(Object dbData) {
        OffsetDateTime offsetDateTime;
        if (dbData == null) {
            offsetDateTime = null;
        } else {
            byte[] bytes = (byte[])this.timestampTZToBytes().invoke(dbData, new Object[0]);
            OffsetDateTime utc = this.extractUtc(bytes);
            if (this.isFixedOffset(bytes)) {
                ZoneOffset offset = this.extractOffset(bytes);
                offsetDateTime = utc.withOffsetSameInstant(offset);
            } else {
                ZoneId zoneId = this.extractZoneId(bytes);
                offsetDateTime = utc.atZoneSameInstant(zoneId).toOffsetDateTime();
            }
        }
        return offsetDateTime;
    }

    public Object offsetTimeToTimestamptz(OffsetTime attribute) {
        byte[] bytes = this.newTIMESTAMPTZBuffer();
        ZonedDateTime utc = attribute.atDate(LocalDate.ofEpochDay(0L)).atZoneSameInstant(ZoneOffset.UTC);
        this.writeDateTime(bytes, utc);
        ZoneOffset offset = attribute.getOffset();
        this.writeZoneOffset(bytes, offset);
        return this.timestampTZCtor().newInstance(new Object[]{bytes});
    }

    public OffsetTime timestamptzToOffsetTime(Object dbData) {
        OffsetTime offsetTime;
        if (dbData == null) {
            offsetTime = null;
        } else {
            byte[] bytes = (byte[])this.timestampTZToBytes().invoke(dbData, new Object[0]);
            OffsetDateTime utc = this.extractUtc(bytes);
            if (this.isFixedOffset(bytes)) {
                ZoneOffset offset = this.extractOffset(bytes);
                offsetTime = utc.withOffsetSameInstant(offset).toOffsetTime();
            } else {
                ZoneId zoneId = this.extractZoneId(bytes);
                offsetTime = utc.atZoneSameInstant(zoneId).toOffsetDateTime().toOffsetTime();
            }
        }
        return offsetTime;
    }

    public Object zonedDateTimeToTimestamptz(ZonedDateTime attribute) {
        byte[] bytes = this.newTIMESTAMPTZBuffer();
        ZonedDateTime utc = attribute.withZoneSameInstant(ZoneOffset.UTC);
        this.writeDateTime(bytes, utc);
        String zoneId = attribute.getZone().getId();
        Integer regionCode = (Integer)this.zoneIdgetId().invoke(null, zoneId);
        if (!BoxesRunTime.equalsNumObject(regionCode, BoxesRunTime.boxToInteger(-1))) {
            this.writeZoneId(bytes, Predef$.MODULE$.Integer2int(regionCode));
        } else {
            this.writeZoneOffset(bytes, attribute.getOffset());
        }
        return this.timestampTZCtor().newInstance(new Object[]{bytes});
    }

    public ZonedDateTime timestamptzToZonedDateTime(Object dbData) {
        ZonedDateTime zonedDateTime;
        if (dbData == null) {
            zonedDateTime = null;
        } else {
            byte[] bytes = (byte[])this.timestampTZToBytes().invoke(dbData, new Object[0]);
            OffsetDateTime utc = this.extractUtc(bytes);
            if (this.isFixedOffset(bytes)) {
                ZoneOffset offset = this.extractOffset(bytes);
                zonedDateTime = utc.atZoneSameInstant(offset);
            } else {
                ZoneId zoneId = this.extractZoneId(bytes);
                zonedDateTime = utc.atZoneSameInstant(zoneId);
            }
        }
        return zonedDateTime;
    }

    public OffsetDateTime extractUtc(byte[] bytes) {
        int year = (bytes[0] - 100) * 100 + (bytes[1] - 100);
        byte month = bytes[2];
        byte dayOfMonth = bytes[3];
        int hour = bytes[4] - 1;
        int minute = bytes[5] - 1;
        int second = bytes[6] - 1;
        int nanoOfSecond = (bytes[7] & 0xFF) << 24 | (bytes[8] & 0xFF) << 16 | (bytes[9] & 0xFF) << 8 | bytes[10] & 0xFF;
        return OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, ZoneOffset.UTC);
    }

    public boolean isFixedOffset(byte[] bytes) {
        return (bytes[11] & this.REGIONIDBIT()) == 0;
    }

    public byte[] newTIMESTAMPTZBuffer() {
        return new byte[13];
    }

    public void writeDateTime(byte[] bytes, ZonedDateTime utc) {
        int year = utc.getYear();
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)utc.getMonthValue();
        bytes[3] = (byte)utc.getDayOfMonth();
        bytes[4] = (byte)(utc.getHour() + 1);
        bytes[5] = (byte)(utc.getMinute() + 1);
        bytes[6] = (byte)(utc.getSecond() + 1);
        int nano = utc.getNano();
        byte[] ba = package$.MODULE$.BigInt().apply(nano).toByteArray();
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ba)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            TimestamptzConverter$.$anonfun$writeDateTime$1(bytes, ba, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public int OFFSET_HOUR() {
        return this.OFFSET_HOUR;
    }

    public int OFFSET_MINUTE() {
        return this.OFFSET_MINUTE;
    }

    public ZoneOffset extractOffset(byte[] bytes) {
        return ZoneOffset.ofHoursMinutes(bytes[11] - this.OFFSET_HOUR(), bytes[12] - this.OFFSET_MINUTE());
    }

    public void writeZoneOffset(byte[] bytes, ZoneOffset offset) {
        int totalMinutes = offset.getTotalSeconds() / 60;
        bytes[11] = (byte)(totalMinutes / 60 + this.OFFSET_HOUR());
        bytes[12] = (byte)(totalMinutes % 60 + this.OFFSET_MINUTE());
    }

    public int highBits() {
        return this.highBits;
    }

    public int lowBits() {
        return this.lowBits;
    }

    public ZoneId extractZoneId(byte[] bytes) {
        Integer regionCode = Predef$.MODULE$.int2Integer(((bytes[11] & this.highBits()) << 6) + ((bytes[12] & this.lowBits()) >> 2));
        String regionName = (String)this.zoneIdgetRegion().invoke(null, regionCode);
        return ZoneId.of(regionName);
    }

    public int msb() {
        return this.msb;
    }

    public int lsb() {
        return this.lsb;
    }

    public void writeZoneId(byte[] bytes, int regionCode) {
        bytes[11] = (byte)(this.REGIONIDBIT() | (regionCode & this.msb()) >>> 6);
        bytes[12] = (byte)((regionCode & this.lsb()) << 2);
    }

    public static final /* synthetic */ void $anonfun$writeDateTime$1(byte[] bytes$1, byte[] ba$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte b = BoxesRunTime.unboxToByte(tuple2._1());
        int i = tuple2._2$mcI$sp();
        bytes$1[11 - ba$1.length + i] = b;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private TimestamptzConverter$() {
        MODULE$ = this;
        this.timestampTZClass = Class.forName("oracle.sql.TIMESTAMPTZ");
        this.timestampTZCtor = this.timestampTZClass().getConstructor(byte[].class);
        this.timestampTZToBytes = this.timestampTZClass().getMethod("toBytes", new Class[0]);
        this.zoneIdClass = Class.forName("oracle.sql.ZONEIDMAP");
        this.zoneIdgetId = this.zoneIdClass().getMethod("getID", String.class);
        this.zoneIdgetRegion = this.zoneIdClass().getMethod("getRegion", Integer.TYPE);
        this.REGIONIDBIT = Integer.parseInt("10000000", 2);
        this.OFFSET_HOUR = 20;
        this.OFFSET_MINUTE = 60;
        this.highBits = Integer.parseInt("1111111", 2);
        this.lowBits = Integer.parseInt("11111100", 2);
        this.msb = Integer.parseInt("1111111000000", 2);
        this.lsb = Integer.parseInt("111111", 2);
    }
}

