/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.messagequeueclient;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.typesafe.config.Config;
import java.util.concurrent.TimeoutException;
import net.shrine.config.package$;
import net.shrine.log.Loggable;
import net.shrine.messagequeueclient.CouldNotInterpretHTTPResponseProblem;
import net.shrine.messagequeueclient.HttpClient$;
import net.shrine.messagequeueclient.MessageQueueWebClient;
import net.shrine.messagequeueclient.MessageQueueWebClient$;
import net.shrine.messagequeueclient.MessageQueueWebClient$MessageQueueClientMessage$;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskButOKToRetryException;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskButOKToRetryException$;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskDoNotRetryException;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskDoNotRetryException$;
import net.shrine.messagequeueservice.Message;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.messagequeueservice.Queue;
import net.shrine.source.ConfigSource$;
import org.apache.log4j.Logger;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.native.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import spray.http.HttpEntity;
import spray.http.HttpEntity$;
import spray.http.HttpMethod;
import spray.http.HttpMethods$;
import spray.http.HttpProtocol;
import spray.http.HttpRequest;
import spray.http.HttpRequest$;
import spray.http.HttpResponse;
import spray.http.StatusCode;
import spray.http.StatusCodes;
import spray.http.StatusCodes$;
import spray.http.Uri;
import spray.http.Uri$;

public final class MessageQueueWebClient$
implements MessageQueueService,
Loggable {
    public static final MessageQueueWebClient$ MODULE$;
    private final ActorSystem system;
    private final String configPath;
    private final Duration webClientTimeOut;
    private final String momUrl;
    private final BoxedUnit unit;
    private final Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$init$0;
    private volatile boolean bitmap$0;

    static {
        new MessageQueueWebClient$();
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        MessageQueueWebClient$ messageQueueWebClient$ = this;
        synchronized (messageQueueWebClient$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.class.net$shrine$log$Loggable$$internalLogger((Loggable)this);
                this.bitmap$0 = true;
            }
            return this.net$shrine$log$Loggable$$internalLogger;
        }
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger : this.net$shrine$log$Loggable$$internalLogger$lzycompute();
    }

    public Logger logger() {
        return Loggable.class.logger((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.class.debugEnabled((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.class.infoEnabled((Loggable)this);
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public final void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public final void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public final void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public final void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public ActorSystem system() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.system;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 33");
    }

    public String configPath() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.configPath;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 35");
    }

    public Config webClientConfig() {
        return ConfigSource$.MODULE$.config().getConfig("shrine.messagequeue.blockingq");
    }

    public Duration webClientTimeOut() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.webClientTimeOut;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 39");
    }

    public String momUrl() {
        if ((byte)(this.bitmap$init$0 & 8) != 0) {
            return this.momUrl;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 76");
    }

    public Try<HttpResponse> webApiTry(HttpRequest request, String operation, Duration timeLimit) {
        return HttpClient$.MODULE$.webApiTry(request, timeLimit, this.system()).transform((Function1)new Serializable(operation){
            public static final long serialVersionUID = 0L;
            public final String operation$1;

            public final Try<HttpResponse> apply(HttpResponse response) {
                return response.status().isSuccess() ? new Success((Object)response) : Try$.MODULE$.apply((Function0)new Serializable(this, response){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.webApiTry.1 $outer;
                    private final HttpResponse response$3;

                    public final HttpResponse apply() {
                        StatusCode statusCode;
                        StatusCode statusCode2 = statusCode = this.response$3.status();
                        StatusCodes.ClientError clientError = StatusCodes$.MODULE$.RequestTimeout();
                        if (!(statusCode2 != null ? !statusCode2.equals(clientError) : clientError != null)) {
                            throw new CouldNotCompleteMomTaskButOKToRetryException(this.$outer.operation$1, (Option)new Some((Object)this.response$3.status()), (Option)new Some((Object)this.response$3.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                        }
                        StatusCode statusCode3 = statusCode;
                        StatusCodes.ServerError serverError = StatusCodes$.MODULE$.NetworkConnectTimeout();
                        if (!(statusCode3 != null ? !statusCode3.equals(serverError) : serverError != null)) {
                            throw new CouldNotCompleteMomTaskButOKToRetryException(this.$outer.operation$1, (Option)new Some((Object)this.response$3.status()), (Option)new Some((Object)this.response$3.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                        }
                        StatusCode statusCode4 = statusCode;
                        StatusCodes.ServerError serverError2 = StatusCodes$.MODULE$.NetworkReadTimeout();
                        if (!(statusCode4 != null ? !statusCode4.equals(serverError2) : serverError2 != null)) {
                            throw new CouldNotCompleteMomTaskButOKToRetryException(this.$outer.operation$1, (Option)new Some((Object)this.response$3.status()), (Option)new Some((Object)this.response$3.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                        }
                        StatusCode statusCode5 = statusCode;
                        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.NotFound();
                        if (!(statusCode5 != null ? !statusCode5.equals(clientError2) : clientError2 != null)) {
                            throw new CouldNotCompleteMomTaskDoNotRetryException(this.$outer.operation$1, (Option)new Some((Object)this.response$3.status()), (Option)new Some((Object)this.response$3.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
                        }
                        throw new CouldNotCompleteMomTaskDoNotRetryException(this.$outer.operation$1, (Option)new Some((Object)this.response$3.status()), (Option)new Some((Object)this.response$3.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.response$3 = response$3;
                    }
                });
            }
            {
                this.operation$1 = operation$1;
            }
        }, (Function1)new Serializable(operation){
            public static final long serialVersionUID = 0L;
            private final String operation$1;

            public final Try<HttpResponse> apply(Throwable x0$1) {
                Failure failure;
                Throwable throwable = x0$1;
                if (throwable instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    failure = new Failure((Throwable)new CouldNotCompleteMomTaskButOKToRetryException(this.operation$1, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)timeoutException)));
                } else {
                    failure = new Failure(throwable);
                }
                return failure;
            }
            {
                this.operation$1 = operation$1;
            }
        });
    }

    public Duration webApiTry$default$3() {
        return this.webClientTimeOut();
    }

    public Try<Queue> createQueueIfAbsent(String queueName) {
        Queue proposedQueue = new Queue(queueName);
        String createQueueUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/createQueue/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), proposedQueue.name()}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.PUT(), Uri$.MODULE$.apply(createQueueUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queueName})), this.webApiTry$default$3()).transform((Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            private final String queueName$1;

            public final Try<Queue> apply(HttpResponse response) {
                return MessageQueueWebClient$.MODULE$.queueFromResponse(response, this.queueName$1);
            }
            {
                this.queueName$1 = queueName$1;
            }
        }, (Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$1;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Throwable x = (Throwable)option.get();
                    MessageQueueWebClient$.MODULE$.error((Function0<Object>)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.createQueueIfAbsent.2 $outer;
                        private final Throwable x$13;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create queue ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queueName$1, this.x$13}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x$13 = x$13;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return new Failure(throwable);
            }
            {
                this.queueName$1 = queueName$1;
            }
        });
    }

    public Try<Queue> queueFromResponse(HttpResponse response, String queueName) {
        return Try$.MODULE$.apply((Function0)new Serializable(response, queueName){
            public static final long serialVersionUID = 0L;
            private final HttpResponse response$1;
            private final String queueName$2;

            public final Queue apply() {
                StatusCode statusCode = this.response$1.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.Created();
                if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                    String queueString = this.response$1.entity().asString();
                    Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
                    return (Queue)Serialization$.MODULE$.read(queueString, formats, Predef$.MODULE$.manifest(ManifestFactory$.MODULE$.classType(Queue.class)));
                }
                throw new CouldNotCompleteMomTaskDoNotRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response status is ", ", not Created. Cannot make queue ", " from this response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1.status(), this.queueName$2, this.response$1.entity().asString()})), (Option)new Some((Object)this.response$1.status()), (Option)new Some((Object)this.response$1.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.response$1 = response$1;
                this.queueName$2 = queueName$2;
            }
        }).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Success<Queue> apply(Queue s) {
                return new Success((Object)s);
            }
        }, (Function1)new Serializable(response, queueName){
            public static final long serialVersionUID = 0L;
            private final HttpResponse response$1;
            private final String queueName$2;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Object object;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    Throwable x = (Throwable)option.get();
                    object = new CouldNotInterpretHTTPResponseProblem(x, "create a Queue", this.queueName$2, this.response$1.entity().asString());
                }
                return new Failure(throwable);
            }
            {
                this.response$1 = response$1;
                this.queueName$2 = queueName$2;
            }
        });
    }

    public void unit() {
        if ((byte)(this.bitmap$init$0 & 0x10) != 0) {
            return;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 131");
    }

    public Try<BoxedUnit> deleteQueue(String queueName) {
        Queue proposedQueue = new Queue(queueName);
        String deleteQueueUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/deleteQueue/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), proposedQueue.name()}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.PUT(), Uri$.MODULE$.apply(deleteQueueUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queueName})), this.webApiTry$default$3()).transform((Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$3;

            public final Try<BoxedUnit> apply(HttpResponse r) {
                Success success;
                StatusCode statusCode = r.status();
                StatusCodes.Success success2 = StatusCodes$.MODULE$.OK();
                if (!(statusCode != null ? !statusCode.equals(success2) : success2 != null)) {
                    MessageQueueWebClient$.MODULE$.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.deleteQueue.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully deleted queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queueName$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    success = new Success((Object)BoxedUnit.UNIT);
                } else {
                    MessageQueueWebClient$.MODULE$.debug((Function0<Object>)new Serializable(this, r){
                        public static final long serialVersionUID = 0L;
                        private final HttpResponse r$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to delete queue, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: StatusCodes.OK, Actual StatusCodes: ", "\n             |Response: ", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.r$1.status(), this.r$1})))).stripMargin();
                        }
                        {
                            this.r$1 = r$1;
                        }
                    });
                    success = new Success((Object)BoxedUnit.UNIT);
                }
                return success;
            }
            {
                this.queueName$3 = queueName$3;
            }
        }, (Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$3;

            public final Failure<Nothing$> apply(Throwable t) {
                MessageQueueWebClient$.MODULE$.error((Function0<Object>)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.deleteQueue.2 $outer;
                    private final Throwable t$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to deleteQueue ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queueName$3, this.t$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.t$1 = t$1;
                    }
                });
                return new Failure(t);
            }
            {
                this.queueName$3 = queueName$3;
            }
        });
    }

    public Try<scala.collection.immutable.Seq<Queue>> queues() {
        String getQueuesUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/getQueues"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl()}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(getQueuesUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, "getQueues", this.webApiTry$default$3()).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Try<scala.collection.immutable.Seq<Queue>> apply(HttpResponse response) {
                Failure failure;
                StatusCode statusCode = response.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                    String allQueues = response.entity().asString();
                    Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
                    failure = new Success(Serialization$.MODULE$.read(allQueues, formats, Predef$.MODULE$.manifest(ManifestFactory$.MODULE$.classType(scala.collection.immutable.Seq.class, ManifestFactory$.MODULE$.classType(Queue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))));
                } else {
                    MessageQueueWebClient$.MODULE$.debug((Function0<Object>)new Serializable(this, response){
                        public static final long serialVersionUID = 0L;
                        private final HttpResponse response$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to get all queues, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: StatusCodes.OK, Actual StatusCodes: ", "\n             |HTTP Response: ", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$4.status(), this.response$4})))).stripMargin();
                        }
                        {
                            this.response$4 = response$4;
                        }
                    });
                    failure = new Failure((Throwable)new CouldNotCompleteMomTaskDoNotRetryException("get all queues", (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4()));
                }
                return failure;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Failure<Nothing$> apply(Throwable t) {
                MessageQueueWebClient$.MODULE$.error((Function0<Object>)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get all queues due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$2}));
                    }
                    {
                        this.t$2 = t$2;
                    }
                });
                return new Failure(t);
            }
        });
    }

    public Try<BoxedUnit> send(String contents, Queue to) {
        Duration waitTimeBeforeResent = (Duration)package$.MODULE$.ConfigExtensions(this.webClientConfig()).get("waitTimeBeforeResent", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$2) {
                return Duration$.MODULE$.apply(x$2);
            }
        });
        ObjectRef retrySendResult = ObjectRef.create((Object)this.sendMessageOnce$1(contents, to));
        while (BoxesRunTime.unboxToBoolean((Object)this.keepGoing$1((Try)retrySendResult.elem).get())) {
            this.debug((Function0<Object>)new Serializable(contents, to, waitTimeBeforeResent, retrySendResult){
                public static final long serialVersionUID = 0L;
                private final String contents$1;
                private final Queue to$1;
                private final Duration waitTimeBeforeResent$1;
                private final ObjectRef retrySendResult$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Last attempt to send ", " to queue ", " resulted in ", ". Sleeping ", " before next attempt "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.contents$1, this.to$1, (Try)this.retrySendResult$1.elem, this.waitTimeBeforeResent$1}));
                }
                {
                    this.contents$1 = contents$1;
                    this.to$1 = to$1;
                    this.waitTimeBeforeResent$1 = waitTimeBeforeResent$1;
                    this.retrySendResult$1 = retrySendResult$1;
                }
            });
            Thread.sleep(waitTimeBeforeResent.toMillis());
            retrySendResult.elem = this.sendMessageOnce$1(contents, to);
        }
        this.info((Function0<Object>)new Serializable(retrySendResult){
            public static final long serialVersionUID = 0L;
            private final ObjectRef retrySendResult$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finishing send with result ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Try)this.retrySendResult$1.elem}));
            }
            {
                this.retrySendResult$1 = retrySendResult$1;
            }
        });
        return (Try)retrySendResult.elem;
    }

    public Try<Option<Message>> receive(Queue from, Duration timeout) {
        long seconds = timeout.toSeconds();
        String receiveMessageUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/receiveMessage/", "?timeOutSeconds=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), from.name(), BoxesRunTime.boxToLong((long)seconds)}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(receiveMessageUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"receive from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from.name()})), this.webClientTimeOut().$plus(timeout)).transform((Function1)new Serializable(from){
            public static final long serialVersionUID = 0L;
            private final Queue from$1;

            public final Try<Option<Message>> apply(HttpResponse response) {
                return MessageQueueWebClient$.MODULE$.messageOptionFromResponse(response, this.from$1);
            }
            {
                this.from$1 = from$1;
            }
        }, (Function1)new Serializable(from){
            public static final long serialVersionUID = 0L;
            private final Queue from$1;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CouldNotCompleteMomTaskDoNotRetryException) {
                    CouldNotCompleteMomTaskDoNotRetryException couldNotCompleteMomTaskDoNotRetryException = (CouldNotCompleteMomTaskDoNotRetryException)throwable2;
                    Option status = couldNotCompleteMomTaskDoNotRetryException.status();
                    Option contents = couldNotCompleteMomTaskDoNotRetryException.contents();
                    Option cause = couldNotCompleteMomTaskDoNotRetryException.cause();
                    Object object = status.get();
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.UnprocessableEntity();
                    if (!(object != null ? !object.equals(clientError) : clientError != null)) {
                        throw new CouldNotCompleteMomTaskButOKToRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make a Message from response ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cause, this.from$1.name()})), status, contents, cause);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return new Failure(throwable);
            }
            {
                this.from$1 = from$1;
            }
        });
    }

    public Try<Option<Message>> messageOptionFromResponse(HttpResponse response, Queue from) {
        return Try$.MODULE$.apply((Function0)new Serializable(response, from){
            public static final long serialVersionUID = 0L;
            public final HttpResponse response$2;
            public final Queue from$2;

            public final Option<LocalMessageQueueMiddleware.SimpleMessage> apply() {
                block6: {
                    None$ none$;
                    block5: {
                        block4: {
                            StatusCode statusCode = this.response$2.status();
                            StatusCodes.Success success = StatusCodes$.MODULE$.NoContent();
                            if (statusCode != null ? !statusCode.equals(success) : success != null) break block4;
                            MessageQueueWebClient$.MODULE$.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.messageOptionFromResponse.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No message received from Queue ", ", HTTP Response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.from$2, this.$outer.response$2}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            none$ = None$.MODULE$;
                            break block5;
                        }
                        StatusCode statusCode = this.response$2.status();
                        StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                        if (statusCode != null ? !statusCode.equals(success) : success != null) break block6;
                        MessageQueueWebClient$.MODULE$.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.messageOptionFromResponse.1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non-empty Message received from Queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.from$2}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        String responseString = this.response$2.entity().asString();
                        Some some = new Some((Object)LocalMessageQueueMiddleware.SimpleMessage$.MODULE$.fromJson(responseString));
                        none$ = some;
                    }
                    return none$;
                }
                StatusCode statusCode = this.response$2.status();
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.UnprocessableEntity();
                if (!(statusCode != null ? !statusCode.equals(clientError) : clientError != null)) {
                    Some some;
                    Some some2 = some;
                    Some some3 = some;
                    throw new CouldNotCompleteMomTaskButOKToRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make a Message from response ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2.entity().asString(), this.from$2.name()})), (Option)new Some((Object)this.response$2.status()), (Option)new Some((Object)this.response$2.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                }
                throw new CouldNotCompleteMomTaskDoNotRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make a Message from response ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2.entity().asString(), this.from$2.name()})), (Option)new Some((Object)this.response$2.status()), (Option)new Some((Object)this.response$2.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.response$2 = response$2;
                this.from$2 = from$2;
            }
        }).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Success<Option<MessageQueueWebClient.MessageQueueClientMessage>> apply(Option<LocalMessageQueueMiddleware.SimpleMessage> s) {
                Option messageQueueClientMessageOpt = s.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MessageQueueWebClient.MessageQueueClientMessage apply(LocalMessageQueueMiddleware.SimpleMessage msg) {
                        return MessageQueueWebClient$MessageQueueClientMessage$.MODULE$.apply(msg.deliveryAttemptID(), msg.contents());
                    }
                });
                return new Success((Object)messageQueueClientMessageOpt);
            }
        }, (Function1)new Serializable(response, from){
            public static final long serialVersionUID = 0L;
            private final HttpResponse response$2;
            private final Queue from$2;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Object object;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    Throwable x = (Throwable)option.get();
                    object = new CouldNotInterpretHTTPResponseProblem(x, "create a Message", this.from$2.name(), this.response$2.entity().asString());
                }
                return new Failure(throwable);
            }
            {
                this.response$2 = response$2;
                this.from$2 = from$2;
            }
        });
    }

    private final Try sendMessageOnce$1(String contents$1, Queue to$1) {
        this.debug((Function0<Object>)new Serializable(contents$1, to$1){
            public static final long serialVersionUID = 0L;
            private final String contents$1;
            private final Queue to$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send to ", " '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.to$1, this.contents$1}));
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        });
        String sendMessageUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sendMessage/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), to$1.name()}));
        HttpMethod x$3 = HttpMethods$.MODULE$.PUT();
        Uri x$4 = Uri$.MODULE$.apply(sendMessageUrl);
        HttpEntity x$5 = HttpEntity$.MODULE$.apply(contents$1);
        List x$6 = HttpRequest$.MODULE$.apply$default$3();
        HttpProtocol x$7 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest request = new HttpRequest(x$3, x$4, x$6, x$5, x$7);
        return this.webApiTry(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{to$1.name()})), this.webApiTry$default$3()).transform((Function1)new Serializable(contents$1, to$1){
            public static final long serialVersionUID = 0L;
            public final String contents$1;
            public final Queue to$1;

            public final Try<BoxedUnit> apply(HttpResponse s) {
                StatusCode statusCode = s.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.Accepted();
                if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                    MessageQueueWebClient$.MODULE$.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.sendMessageOnce.1.2 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully sent Message ", " to Queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.contents$1, this.$outer.to$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return new Success((Object)BoxedUnit.UNIT);
                }
                MessageQueueWebClient$.MODULE$.debug((Function0<Object>)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessageOnce.1.2 $outer;
                    private final HttpResponse s$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to sendMessage ", ", HTTPResponse is a success but it does not contain an expected StatusCode\n               |Expected StatusCodes: StatusCodes.Accepted, Actual StatusCodes: ", "\n               |Response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.contents$1, this.s$1.status(), this.s$1})))).stripMargin();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.s$1 = s$1;
                    }
                });
                throw new CouldNotCompleteMomTaskDoNotRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send a Message to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.to$1.name()})), (Option)new Some((Object)s.status()), (Option)new Some((Object)s.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        }, (Function1)new Serializable(contents$1, to$1){
            public static final long serialVersionUID = 0L;
            public final String contents$1;
            public final Queue to$1;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CouldNotCompleteMomTaskDoNotRetryException) {
                    CouldNotCompleteMomTaskDoNotRetryException couldNotCompleteMomTaskDoNotRetryException = (CouldNotCompleteMomTaskDoNotRetryException)throwable2;
                    Option status = couldNotCompleteMomTaskDoNotRetryException.status();
                    Option content = couldNotCompleteMomTaskDoNotRetryException.contents();
                    Option cause = couldNotCompleteMomTaskDoNotRetryException.cause();
                    Object object = status.get();
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.UnprocessableEntity();
                    if (!(object != null ? !object.equals(clientError) : clientError != null)) {
                        throw new CouldNotCompleteMomTaskButOKToRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send a Message to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.to$1.name()})), status, content, cause);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                MessageQueueWebClient$.MODULE$.error((Function0<Object>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessageOnce.1.3 $outer;
                    private final Throwable throwable$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to send Message ", " to Queue ", " due to Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.contents$1, this.$outer.to$1, this.throwable$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.throwable$1 = throwable$1;
                    }
                }, throwable);
                return new Failure(throwable);
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        });
    }

    private final Try keepGoing$1(Try lastAttempt) {
        return lastAttempt.transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Success<Object> apply(BoxedUnit s) {
                return new Success((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Try<Object> apply(Throwable x0$2) {
                Throwable throwable = x0$2;
                Object object = throwable instanceof CouldNotCompleteMomTaskButOKToRetryException ? new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Failure(throwable);
                return object;
            }
        });
    }

    private MessageQueueWebClient$() {
        MODULE$ = this;
        Loggable.class.$init$((Loggable)this);
        this.system = ActorSystem$.MODULE$.apply("momServer", ConfigSource$.MODULE$.config());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.configPath = "shrine.messagequeue.blockingq";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.webClientTimeOut = (Duration)package$.MODULE$.ConfigExtensions(this.webClientConfig()).get("webClientTimeOut", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$1) {
                return Duration$.MODULE$.apply(x$1);
            }
        });
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.momUrl = this.webClientConfig().getString("serverUrl");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.unit = BoxedUnit.UNIT;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

