/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.sonatype.gossip.EffectiveProfile;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.listener.ConsoleListener;
import org.sonatype.gossip.model.ListenerNode;
import org.sonatype.gossip.model.LoggerNode;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.model.ModelMerger;
import org.sonatype.gossip.model.ProfileNode;
import org.sonatype.gossip.model.SourceNode;
import org.sonatype.gossip.model.TriggerNode;
import org.sonatype.gossip.source.Source;
import org.sonatype.gossip.source.URLSource;
import org.sonatype.gossip.trigger.AlwaysTrigger;

public final class Configurator {
    private static final String BOOTSTRAP_RESOURCE = "bootstrap.properties";
    private final Logger log = Log.getLogger(this.getClass());

    public EffectiveProfile configure() {
        this.log.debug("Configuring");
        EffectiveProfile profile = new EffectiveProfile();
        try {
            Model bootstrap = this.loadBootstrap();
            Model config = this.resolve(bootstrap);
            this.configureActiveProfiles(profile, config);
        }
        catch (Throwable t) {
            this.log.error("Failed to configure; using fall-back provider", t);
        }
        if (profile.getProfiles().isEmpty()) {
            this.log.debug("No profiles were activated; using fall-back");
            ProfileNode p = this.createFallbackProfile();
            profile.addProfile(p);
        }
        return profile;
    }

    private Model resolve(Model bootstrap) {
        assert (bootstrap != null);
        Model config = new Model();
        ModelMerger merger = new ModelMerger();
        HashMap hints = new HashMap();
        for (SourceNode source : bootstrap.getSources()) {
            try {
                Source loader = source.create();
                merger.merge(config, loader.load(), true, hints);
            }
            catch (Exception e) {
                this.log.error("Failed to resolve source: " + source, (Throwable)e);
            }
        }
        this.resolveIncludes(config);
        return config;
    }

    private void resolveIncludes(Model model) {
        assert (model != null);
        for (ProfileNode profile : model.getProfiles()) {
            this.log.trace("Processing includes for: {}", (Object)profile);
            for (String include : profile.getIncludes()) {
                ProfileNode includedProfile = model.findProfile(include);
                if (includedProfile == null) {
                    this.log.warn("Unable to include non-existant profile: {}", (Object)includedProfile);
                    continue;
                }
                this.log.debug("Including {} profile into: {}", (Object)include, (Object)profile);
                for (Object name : includedProfile.getProperties().keySet()) {
                    if (profile.getProperties().containsKey(name)) continue;
                    profile.getProperties().put(name, includedProfile.getProperties().get(name));
                    this.log.trace("Appending property: {}", name);
                }
                for (LoggerNode logger : includedProfile.getLoggers()) {
                    if (profile.getLoggers().contains(logger)) continue;
                    profile.getLoggers().add(logger);
                    this.log.trace("Appending logger: {}", (Object)logger);
                }
                for (ListenerNode listener : includedProfile.getListeners()) {
                    if (profile.getListeners().contains(listener)) continue;
                    profile.getListeners().add(listener);
                    this.log.trace("Appending listener: {}", (Object)listener);
                }
                for (TriggerNode trigger : includedProfile.getTriggers()) {
                    if (profile.getTriggers().contains(trigger)) continue;
                    profile.getTriggers().add(trigger);
                    this.log.trace("Appending trigger: {}", (Object)trigger);
                }
            }
        }
    }

    private void configureActiveProfiles(EffectiveProfile profile, Model model) throws Exception {
        ProfileNode node;
        assert (profile != null);
        assert (model != null);
        this.log.debug("Activating profiles");
        for (ProfileNode node2 : model.getProfiles()) {
            if (!this.isProfileActive(node2)) continue;
            this.log.debug("Active profile: {}", (Object)node2);
            profile.addProfile(node2);
        }
        if (profile.getProfiles().isEmpty() && (node = model.findProfile("default")) != null) {
            this.log.debug("Using default profile: {}", (Object)node);
            profile.addProfile(node);
        }
    }

    private boolean isProfileActive(ProfileNode profile) {
        assert (profile != null);
        this.log.trace("Checking if profile is active: {}", (Object)profile);
        for (TriggerNode trigger : profile.getTriggers()) {
            try {
                if (!trigger.create().isActive()) continue;
                this.log.debug("Active trigger: {}", (Object)trigger);
                return true;
            }
            catch (Exception e) {
                this.log.error("Failed to evaluate trigger: " + trigger, (Throwable)e);
            }
        }
        return false;
    }

    private ProfileNode createFallbackProfile() {
        ProfileNode p = new ProfileNode();
        p.setName("fall-back");
        TriggerNode trigger = new TriggerNode();
        trigger.setType(AlwaysTrigger.class);
        p.getTriggers().add(trigger);
        ListenerNode listenerNode = new ListenerNode();
        listenerNode.setType(ConsoleListener.class);
        p.getListeners().add(listenerNode);
        return p;
    }

    private Model loadBootstrap() throws Exception {
        URL url = this.getClass().getResource(BOOTSTRAP_RESOURCE);
        assert (url != null) : "Unable to load bootstrap resource: bootstrap.properties";
        this.log.trace("Using bootstrap URL: {}", (Object)url);
        URLSource source = new URLSource();
        source.setUrl(url);
        return source.load();
    }
}

