/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.source;

import java.io.File;
import org.sonatype.gossip.MissingPropertyException;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.source.SourceSupport;

public class HomeDirectorySource
extends SourceSupport {
    private String path;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Model load() throws Exception {
        if (this.path == null) {
            throw new MissingPropertyException("path");
        }
        File homeDir = new File(System.getProperty("user.home"));
        File file = new File(homeDir, this.path);
        return this.load(file);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "path='" + this.path + '\'' + '}';
    }
}

