/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.Gossip;
import org.sonatype.gossip.Level;
import org.sonatype.gossip.LoggerDelegate;
import org.sonatype.gossip.LoggerSupport;
import org.sonatype.gossip.render.PatternRenderer;

public final class Log {
    private static final Map<String, LoggerDelegate> delegates = new HashMap<String, LoggerDelegate>();
    private static final Level level = Level.valueOf(System.getProperty(Log.class.getName() + ".level", Level.WARN.toString()).toUpperCase());
    private static final Level internalLevel = Level.valueOf(System.getProperty(Log.class.getName() + ".internal.level", Level.WARN.toString()).toUpperCase());
    private static final PatternRenderer renderer = new PatternRenderer();
    private static boolean configured;

    static void configure() {
        if (!configured) {
            for (Map.Entry<String, LoggerDelegate> entry : delegates.entrySet()) {
                Gossip.LoggerImpl logger = Gossip.getInstance().getLogger(entry.getKey());
                entry.getValue().setDelegate(logger);
            }
            delegates.clear();
            configured = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        assert (name != null);
        if (name.startsWith("org.sonatype.gossip")) {
            return new LoggerImpl(name);
        }
        if (!configured) {
            Map<String, LoggerDelegate> map = delegates;
            synchronized (map) {
                LoggerDelegate delegate = new LoggerDelegate(new LoggerImpl(name));
                delegates.put(name, delegate);
                return delegate;
            }
        }
        return Gossip.getInstance().getLogger(name);
    }

    public static Logger getLogger(Class type) {
        assert (type != null);
        return Log.getLogger(type.getName());
    }

    private static class LoggerImpl
    extends LoggerSupport {
        private LoggerImpl(String name) {
            super(name);
        }

        protected boolean isEnabled(Level l) {
            assert (l != null);
            Level threashold = level;
            if (this.getName().startsWith("org.sonatype.gossip")) {
                threashold = internalLevel;
            }
            return threashold.id <= l.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doLog(Level level, String message, Throwable cause) {
            PrintStream out;
            assert (message != null);
            PrintStream printStream = out = System.out;
            synchronized (printStream) {
                out.print(renderer.render(new Event(this, level, message, cause)));
                out.flush();
            }
        }
    }
}

