/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.sonatype.gossip.Level;

public abstract class LoggerSupport
extends MarkerIgnoringBase
implements Logger,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ROOT = "*";
    private final String name;

    protected LoggerSupport(String name) {
        assert (name != null);
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]@" + System.identityHashCode(this);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Logger that = (Logger)obj;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }

    protected abstract boolean isEnabled(Level var1);

    protected abstract void doLog(Level var1, String var2, Throwable var3);

    private void log(Level level, String msg, Throwable cause) {
        if (this.isEnabled(level)) {
            this.doLog(level, msg, cause);
        }
    }

    private void log(Level level, String msg) {
        if (this.isEnabled(level)) {
            this.doLog(level, msg, null);
        }
    }

    private void log(Level level, String format, Object arg) {
        if (this.isEnabled(level)) {
            if (arg instanceof Throwable) {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg), (Throwable)arg);
            } else {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg), null);
            }
        }
    }

    private void log(Level level, String format, Object arg1, Object arg2) {
        if (this.isEnabled(level)) {
            if (arg2 instanceof Throwable) {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2), (Throwable)arg2);
            } else {
                this.doLog(level, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2), null);
            }
        }
    }

    private void log(Level level, String format, Object[] args) {
        if (this.isEnabled(level)) {
            if (args != null && args.length != 0 && args[args.length - 1] instanceof Throwable) {
                this.doLog(level, MessageFormatter.arrayFormat((String)format, (Object[])args), (Throwable)args[args.length - 1]);
            } else {
                this.doLog(level, MessageFormatter.arrayFormat((String)format, (Object[])args), null);
            }
        }
    }

    public final boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public final void trace(String msg) {
        this.log(Level.TRACE, msg);
    }

    public final void trace(String format, Object arg) {
        this.log(Level.TRACE, format, arg);
    }

    public final void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, format, arg1, arg2);
    }

    public final void trace(String format, Object ... args) {
        this.log(Level.TRACE, format, args);
    }

    public final void trace(String msg, Throwable cause) {
        this.log(Level.TRACE, msg, cause);
    }

    public final boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public final void debug(String msg) {
        this.log(Level.DEBUG, msg);
    }

    public final void debug(String format, Object arg) {
        this.log(Level.DEBUG, format, arg);
    }

    public final void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, format, arg1, arg2);
    }

    public final void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public final void debug(String msg, Throwable cause) {
        this.log(Level.DEBUG, msg, cause);
    }

    public final boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public final void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public final void info(String format, Object arg) {
        this.log(Level.INFO, format, arg);
    }

    public final void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, arg1, arg2);
    }

    public final void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public final void info(String msg, Throwable cause) {
        this.log(Level.INFO, msg, cause);
    }

    public final boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public final void warn(String msg) {
        this.log(Level.WARN, msg);
    }

    public final void warn(String format, Object arg) {
        this.log(Level.WARN, format, arg);
    }

    public final void warn(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public final void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, format, arg1, arg2);
    }

    public final void warn(String msg, Throwable cause) {
        this.log(Level.WARN, msg, cause);
    }

    public final boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public final void error(String msg) {
        this.log(Level.ERROR, msg);
    }

    public final void error(String format, Object arg) {
        this.log(Level.ERROR, format, arg);
    }

    public final void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, format, arg1, arg2);
    }

    public final void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public final void error(String msg, Throwable cause) {
        this.log(Level.ERROR, msg, cause);
    }
}

