/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gshell.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.sonatype.gossip.Log;
import org.sonatype.gshell.io.StreamSet;

public class StreamJack {
    private static final Logger log = Log.getLogger(StreamJack.class);
    private static final InheritableThreadLocal<StreamRegistration> registrations = new InheritableThreadLocal();
    private static StreamSet previous;
    private static boolean installed;

    public static synchronized boolean isInstalled() {
        return installed;
    }

    private static synchronized void ensureInstalled() {
        if (!StreamJack.isInstalled()) {
            throw new IllegalStateException("Not installed");
        }
    }

    public static synchronized void install() {
        if (installed) {
            throw new IllegalStateException("Already installed");
        }
        previous = new StreamSet(System.in, System.out, System.err);
        System.setIn(new DelegateInputStream());
        System.setOut(new DelegateOutputStream(StreamSet.OutputType.OUT));
        System.setErr(new DelegateOutputStream(StreamSet.OutputType.ERR));
        installed = true;
        log.debug("Installed");
    }

    public static synchronized void install(InputStream in, PrintStream out, PrintStream err) {
        StreamJack.install();
        StreamJack.register(in, out, err);
    }

    public static synchronized void install(InputStream in, PrintStream out) {
        StreamJack.install();
        StreamJack.register(in, out);
    }

    public static synchronized void install(StreamSet set) {
        StreamJack.install();
        StreamJack.register(set);
    }

    public static synchronized void maybeInstall() {
        if (!StreamJack.isInstalled()) {
            StreamJack.install();
        }
    }

    public static synchronized void maybeInstall(StreamSet set) {
        if (!StreamJack.isInstalled()) {
            StreamJack.install(set);
        } else {
            StreamJack.register(set);
        }
    }

    public static synchronized void uninstall() {
        StreamJack.ensureInstalled();
        System.setIn(StreamJack.previous.in);
        System.setOut(StreamJack.previous.out);
        System.setErr(StreamJack.previous.err);
        previous = null;
        installed = false;
        log.debug("Uninstalled");
    }

    private static synchronized StreamRegistration registration(boolean required) {
        if (required) {
            StreamJack.ensureRegistered();
        }
        return (StreamRegistration)registrations.get();
    }

    public static synchronized boolean isRegistered() {
        return StreamJack.registration(false) != null;
    }

    private static synchronized void ensureRegistered() {
        StreamJack.ensureInstalled();
        if (!StreamJack.isRegistered()) {
            throw new IllegalStateException(MessageFormat.format("Not registered: {0}", Thread.currentThread()));
        }
    }

    public static synchronized void register(InputStream in, PrintStream out, PrintStream err) {
        StreamJack.ensureInstalled();
        log.trace("Registering: {} -> {}, {}, {}", new Object[]{Thread.currentThread(), in, out, err});
        StreamRegistration prev = StreamJack.registration(false);
        StreamSet set = new StreamSet(in, out, err);
        StreamRegistration next = new StreamRegistration(set, prev);
        registrations.set(next);
    }

    public static synchronized void register(InputStream in, PrintStream out) {
        StreamJack.register(in, out, out);
    }

    public static synchronized void register(StreamSet set) {
        assert (set != null);
        StreamJack.register(set.in, set.out, set.err);
    }

    public static synchronized void deregister() {
        StreamRegistration cur = StreamJack.registration(true);
        registrations.set(cur.previous);
        log.trace("De-registered: {}, using streams: {}", (Object)Thread.currentThread(), cur.previous == null ? "null" : cur.previous.streams);
    }

    public static synchronized StreamSet current() {
        StreamRegistration reg = StreamJack.registration(false);
        if (reg == null) {
            return previous;
        }
        return reg.streams;
    }

    public static synchronized void restore(StreamSet streams) {
        assert (streams != null);
        StreamSet.system(streams);
        previous = null;
        installed = false;
    }

    public static synchronized void restore() {
        StreamJack.restore(StreamSet.system());
    }

    private static class DelegateInputStream
    extends InputStream {
        private InputStream get() {
            return StreamJack.current().getInput();
        }

        public int read() throws IOException {
            return this.get().read();
        }

        public int read(byte[] b) throws IOException {
            return this.get().read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.get().read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.get().skip(n);
        }

        public int available() throws IOException {
            return this.get().available();
        }

        public void close() throws IOException {
            this.get().close();
        }

        public void mark(int readLimit) {
            this.get().mark(readLimit);
        }

        public void reset() throws IOException {
            this.get().reset();
        }

        public boolean markSupported() {
            return this.get().markSupported();
        }
    }

    private static class DelegateOutputStream
    extends PrintStream {
        private static final ByteArrayOutputStream NULL_OUTPUT = new ByteArrayOutputStream();
        private final StreamSet.OutputType type;

        public DelegateOutputStream(StreamSet.OutputType type) {
            super(NULL_OUTPUT);
            assert (type != null);
            this.type = type;
        }

        private PrintStream get() {
            return StreamJack.current().getOutput(this.type);
        }

        public void write(int b) {
            this.get().write(b);
        }

        public void write(byte[] b) throws IOException {
            this.get().write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) {
            this.get().write(b, off, len);
        }

        public void flush() {
            this.get().flush();
        }

        public void close() {
            this.get().close();
        }
    }

    private static class StreamRegistration {
        public final StreamSet streams;
        public final StreamRegistration previous;

        public StreamRegistration(StreamSet streams, StreamRegistration previous) {
            assert (streams != null);
            this.streams = streams;
            this.previous = previous;
        }
    }
}

