/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.listener;

import java.io.PrintStream;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.listener.ListenerSupport;

public class ConsoleListener
extends ListenerSupport {
    private Stream stream;

    public ConsoleListener() {
        this.setStream(Stream.OUT);
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        assert (stream != null);
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event) {
        PrintStream out;
        assert (event != null);
        if (!this.isLoggable(event)) {
            return;
        }
        Stream stream = this.getStream();
        switch (stream) {
            case OUT: {
                out = System.out;
                break;
            }
            case ERR: {
                out = System.err;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print(this.render(event));
            out.flush();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "stream=" + (Object)((Object)this.stream) + ", threshold=" + (Object)((Object)this.getThreshold()) + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stream {
        OUT,
        ERR;

    }
}

