/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.render;

import org.sonatype.gossip.Event;
import org.sonatype.gossip.render.Renderer;

public class PatternRenderer
implements Renderer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_PATTERN = "[%l] %c - %m%n%x";
    private String pattern = "[%l] %c - %m%n%x";

    public String toString() {
        return "PatternRenderer{pattern=" + this.pattern + '}';
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        assert (pattern != null);
        this.pattern = pattern;
    }

    public String render(Event event) {
        assert (event != null);
        assert (this.pattern != null);
        StringBuilder buff = new StringBuilder();
        int len = this.pattern.length();
        block15: for (int i = 0; i < len; ++i) {
            char c = this.pattern.charAt(i);
            if (c == '%') {
                if (i + 1 >= len) {
                    throw new IllegalArgumentException("Invalid pattern: " + this.pattern);
                }
                char t = this.pattern.charAt(++i);
                switch (t) {
                    case '%': {
                        buff.append(t);
                        break;
                    }
                    case 'd': {
                        this.renderTimeStamp(event, buff);
                        break;
                    }
                    case 'c': {
                        this.renderName(event, buff, true);
                        break;
                    }
                    case 'C': {
                        this.renderName(event, buff, false);
                        break;
                    }
                    case 'l': {
                        this.renderLevel(event, buff);
                        break;
                    }
                    case 't': {
                        this.renderThreadName(event, buff);
                        break;
                    }
                    case 'T': {
                        if (event.getTrace() == null) continue block15;
                        this.renderTraceClass(event, buff);
                        break;
                    }
                    case 'F': {
                        if (event.getTrace() == null) continue block15;
                        this.renderTraceFile(event, buff);
                        break;
                    }
                    case 'M': {
                        if (event.getTrace() == null) continue block15;
                        this.renderTraceMethod(event, buff);
                        break;
                    }
                    case 'L': {
                        if (event.getTrace() == null) continue block15;
                        this.renderTraceLine(event, buff);
                        break;
                    }
                    case 'm': {
                        this.renderMessage(event, buff);
                        break;
                    }
                    case 'x': {
                        if (event.getCause() == null) continue block15;
                        this.renderCause(event, buff);
                        break;
                    }
                    case 'n': {
                        this.renderNewLine(buff);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid pattern token: " + t);
                    }
                }
                continue;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    protected void renderNewLine(StringBuilder buff) {
        assert (buff != null);
        buff.append(NEWLINE);
    }

    protected void renderTimeStamp(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        buff.append(event.getTimeStamp());
    }

    protected void renderLevel(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        buff.append(event.getLevel().name());
    }

    protected void renderName(Event event, StringBuilder buff, boolean shortName) {
        int i;
        assert (event != null);
        assert (buff != null);
        String name = event.getName();
        if (shortName && (i = name.lastIndexOf(".")) != -1) {
            name = name.substring(i + 1, name.length());
        }
        buff.append(name);
    }

    protected void renderThreadName(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        buff.append(event.getThreadName());
    }

    protected void renderMessage(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        buff.append(event.getMessage());
    }

    protected void renderCause(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        Throwable cause = event.getCause();
        buff.append(cause);
        buff.append(NEWLINE);
        while (cause != null) {
            for (StackTraceElement e : cause.getStackTrace()) {
                buff.append("    at ").append(e.getClassName()).append(".").append(e.getMethodName());
                buff.append(" (").append(this.getLocation(e)).append(")");
                buff.append(NEWLINE);
            }
            if ((cause = cause.getCause()) == null) continue;
            buff.append("Caused by ").append(cause.getClass().getName()).append(": ");
            buff.append(cause.getMessage());
            buff.append(NEWLINE);
        }
    }

    protected void renderTraceFile(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        StackTraceElement[] trace = event.getTrace();
        assert (trace != null);
        buff.append(trace[0].getFileName());
    }

    protected void renderTraceClass(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        StackTraceElement[] trace = event.getTrace();
        assert (trace != null);
        buff.append(trace[0].getClassName());
    }

    protected void renderTraceMethod(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        StackTraceElement[] trace = event.getTrace();
        assert (trace != null);
        buff.append(trace[0].getMethodName());
    }

    protected void renderTraceLine(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        StackTraceElement[] trace = event.getTrace();
        assert (trace != null);
        buff.append(trace[0].getLineNumber());
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }
}

