/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.render;

import org.fusesource.jansi.Ansi;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.render.PatternRenderer;

public class ColorRenderer
extends PatternRenderer {
    protected void renderLevel(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        switch (event.getLevel()) {
            case TRACE: 
            case DEBUG: {
                buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.YELLOW).a(event.getLevel().name()).reset());
                break;
            }
            case INFO: {
                buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.GREEN).a(event.getLevel().name()).reset());
                break;
            }
            case WARN: 
            case ERROR: {
                buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.RED).a(event.getLevel().name()).reset());
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    protected void renderName(Event event, StringBuilder buff, boolean shortName) {
        StringBuilder tmp = new StringBuilder();
        super.renderName(event, tmp, shortName);
        buff.append(Ansi.ansi().fg(Ansi.Color.GREEN).a((CharSequence)tmp).reset());
    }

    protected void renderCause(Event event, StringBuilder buff) {
        assert (event != null);
        assert (buff != null);
        Throwable cause = event.getCause();
        buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.RED).a(cause.getClass().getName()).reset());
        if (cause.getMessage() != null) {
            buff.append(": ");
            buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.RED).a(cause.getMessage()).reset());
        }
        this.renderNewLine(buff);
        while (cause != null) {
            for (StackTraceElement e : cause.getStackTrace()) {
                buff.append("    ");
                buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("at").reset().a(" ").a(e.getClassName()).a(".").a(e.getMethodName()));
                buff.append(Ansi.ansi().a(" (").a(Ansi.Attribute.INTENSITY_BOLD).a(this.getLocation(e)).reset().a(")"));
                this.renderNewLine(buff);
            }
            if ((cause = cause.getCause()) == null) continue;
            buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("Caused by").reset().a(" ").a(cause.getClass().getName()));
            if (cause.getMessage() != null) {
                buff.append(": ");
                buff.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.RED).a(cause.getMessage()).reset());
            }
            this.renderNewLine(buff);
        }
    }
}

