/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.sonatype.gossip.Configurator;
import org.sonatype.gossip.EffectiveProfile;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.Level;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.LoggerSupport;
import org.sonatype.gossip.model.LoggerNode;

public final class Gossip
implements ILoggerFactory {
    private static final Logger log = Log.getLogger(Gossip.class);
    private static final Gossip INSTANCE = new Gossip();
    private final Map<String, Loggerish> loggers = new HashMap<String, Loggerish>();
    private final LoggerImpl root = new LoggerImpl("ROOT", Level.WARN);
    private final EffectiveProfile effectiveProfile = new Configurator().configure();

    public static Gossip getInstance() {
        return INSTANCE;
    }

    private Gossip() {
        this.prime();
    }

    public LoggerImpl getRoot() {
        return this.root;
    }

    public EffectiveProfile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    private void prime() {
        log.trace("Priming");
        for (Map.Entry<String, LoggerNode> entry : this.effectiveProfile.loggers().entrySet()) {
            String name = entry.getKey();
            LoggerNode node = entry.getValue();
            LoggerImpl logger = "*".equals(name) ? this.root : this.getLogger(name);
            logger.level = node.asLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerImpl getLogger(String name) {
        LoggerImpl logger;
        assert (name != null);
        Map<String, Loggerish> map = this.loggers;
        synchronized (map) {
            Loggerish obj = this.loggers.get(name);
            if (obj == null) {
                logger = new LoggerImpl(name);
                this.loggers.put(name, logger);
                log.trace("Created logger: {}", (Object)logger);
                this.updateParents(logger);
            } else if (obj instanceof ProvisionNode) {
                logger = new LoggerImpl(name);
                this.loggers.put(name, logger);
                log.trace("Replaced provision node with logger: {}", (Object)logger);
                this.updateChildren((ProvisionNode)obj, logger);
                this.updateParents(logger);
            } else if (obj instanceof LoggerImpl) {
                logger = (LoggerImpl)obj;
                log.trace("Using cached logger: {}", (Object)logger);
            } else {
                throw new InternalError();
            }
        }
        return logger;
    }

    private void updateParents(LoggerImpl logger) {
        assert (logger != null);
        String name = logger.getName();
        int length = name.length();
        boolean parentFound = false;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            String key = name.substring(0, i);
            Loggerish obj = this.loggers.get(key);
            if (obj == null) {
                ProvisionNode pn = new ProvisionNode(logger);
                this.loggers.put(key, pn);
            } else {
                if (obj instanceof LoggerImpl) {
                    parentFound = true;
                    logger.parent = (LoggerImpl)obj;
                    break;
                }
                if (obj instanceof ProvisionNode) {
                    ((ProvisionNode)obj).add(logger);
                } else {
                    throw new InternalError();
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (!parentFound) {
            logger.parent = this.root;
        }
    }

    private void updateChildren(ProvisionNode pn, LoggerImpl logger) {
        assert (pn != null);
        assert (logger != null);
        int last = pn.size();
        for (int i = 0; i < last; ++i) {
            LoggerImpl l = (LoggerImpl)pn.get(i);
            if (l.parent.getName().startsWith(logger.getName())) continue;
            logger.parent = l.parent;
            l.parent = logger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProvisionNode
    extends ArrayList<Object>
    implements Loggerish {
        private ProvisionNode(LoggerImpl logger) {
            assert (logger != null);
            this.add(logger);
        }
    }

    private final class LoggerImpl
    extends LoggerSupport
    implements Loggerish {
        private Level level;
        private Level cachedLevel;
        private LoggerImpl parent;

        private LoggerImpl(String name, Level level) {
            super(name);
            this.level = level;
        }

        private LoggerImpl(String name) {
            this(name, (Level)null);
        }

        private Level findEffectiveLevel() {
            LoggerImpl logger = this;
            while (logger != null) {
                if (logger.level != null) {
                    return logger.level;
                }
                logger = logger.parent;
            }
            return null;
        }

        private Level getEffectiveLevel() {
            if (this.cachedLevel == null) {
                this.cachedLevel = this.findEffectiveLevel();
            }
            return this.cachedLevel;
        }

        protected boolean isEnabled(Level level) {
            assert (level != null);
            return this.getEffectiveLevel().id <= level.id;
        }

        protected void doLog(Level level, String message, Throwable cause) {
            Gossip.this.effectiveProfile.dispatch(new Event(this, level, message, cause));
        }

        public String toString() {
            return "Logger[" + this.getName() + "]@" + System.identityHashCode(this);
        }
    }

    private static interface Loggerish {
    }
}

