/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.source;

import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.model.io.props.GossipPropertiesReader;
import org.sonatype.gossip.source.Source;

public abstract class SourceSupport
implements Source {
    protected final Logger log = Log.getLogger(this.getClass());

    protected Model load(URL url) throws Exception {
        assert (url != null);
        this.log.debug("Loading model from: {}", (Object)url);
        GossipPropertiesReader reader = new GossipPropertiesReader();
        return reader.read(url);
    }

    protected Model load(File file) throws Exception {
        assert (file != null);
        if (!file.exists()) {
            this.log.trace("File does not exist; skipping: {}", (Object)file);
            return null;
        }
        return this.load(file.toURI().toURL());
    }
}

