/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import net.shrine.monitor.scanner.QueryDefIterator;
import net.shrine.serializers.crc.QueryDefBuilder;
import org.spin.tools.Util;

public class FlatFileIterator
extends QueryDefIterator {
    public static String COMMENT_LINE = "#";
    File file;
    BufferedReader reader;
    Annotation previous = null;
    Annotation current = null;

    public FlatFileIterator(File file) throws FileNotFoundException {
        this.file = file;
        this.reader = new BufferedReader(new FileReader(file));
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.ready() && this.current != Annotation.end;
        }
        catch (Exception e) {
            log.error((Object)"Could not determine if Flat File has more Query Items", (Throwable)e);
            return false;
        }
    }

    @Override
    public QueryDefinitionType next() {
        QueryDefinitionType definition = null;
        ArrayList itemKeys = Util.makeArrayList();
        ArrayList panels = Util.makeArrayList();
        try {
            while (this.hasNext() && definition == null) {
                String lineNext = this.reader.readLine();
                log.debug((Object)("CURRENT:" + lineNext));
                if (lineNext.startsWith(COMMENT_LINE)) {
                    System.out.println(COMMENT_LINE);
                    continue;
                }
                if (Annotation.isAnnotation(lineNext)) {
                    this.current = Annotation.parse(lineNext);
                    if (itemKeys.size() > 0) {
                        panels.add(QueryDefBuilder.getPanel((List)itemKeys));
                        itemKeys.clear();
                    }
                    if (this.current == Annotation.panel || panels.size() <= 0) continue;
                    log.debug((Object)"Returning buffer of panels within query definition.");
                    definition = QueryDefBuilder.getQueryDefinition((List)panels);
                    panels.clear();
                    continue;
                }
                if (lineNext.length() <= 0) continue;
                itemKeys.add(QueryDefBuilder.getItem((String)lineNext));
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not read next query definition", (Throwable)e);
        }
        return definition;
    }

    public static enum Annotation {
        def,
        panel,
        item,
        end;


        public String print() {
            return "@" + this.name();
        }

        public static boolean isAnnotation(String string) {
            return string.contains("@");
        }

        public static Annotation parse(String string) {
            return Annotation.valueOf(string.replaceFirst("@", ""));
        }
    }
}

