/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.shrine.monitor.scanner.QueryDefIterator;
import net.shrine.monitor.scanner.ReqResPair;
import net.shrine.monitor.scanner.ReqThread;
import net.shrine.monitor.scanner.RuntimeArgs;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.crc.QueryDefBuilder;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;

class Main {
    Main() {
    }

    public static void main(String[] args) throws ConfigException {
        if (args.length < 1) {
            Main.showUsage();
            System.exit(0);
        } else {
            try {
                PKITool.getInstance();
                RuntimeArgs runtime = new RuntimeArgs(args[0]);
                Main.println("Runtime Settings: ");
                Main.println(runtime.toString());
                if (runtime.source == null) {
                    Main.println("Source was not set");
                    Main.showUsage();
                    System.exit(0);
                }
                Main main = new Main();
                main.run(runtime);
            }
            catch (ConfigException e) {
                Main.println("Config problem?" + e.getMessage());
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                Main.println("Exception:" + e.getMessage());
            }
        }
    }

    public void run(RuntimeArgs runtime) throws ConfigException, SerializationException, IOException, InterruptedException, ExecutionException {
        int COUNT_ERROR = 0;
        int COUNT_COMPLETE = 0;
        int COUNT_INCOMPLETE = 0;
        do {
            QueryDefIterator input = runtime.queryDefIterator();
            ExecutorService executor = Executors.newFixedThreadPool(runtime.threads);
            while (input.hasNext()) {
                HashMap futures = Util.makeHashMap();
                for (int t = 1; t <= runtime.threads; ++t) {
                    QueryDefinitionType definition = (QueryDefinitionType)input.next();
                    definition.setQueryName("Heartbeat " + System.currentTimeMillis());
                    RequestMessageType request = QueryDefBuilder.getRequestPSM((QueryDefinitionType)definition, (SecurityType)runtime.getSecurityType(), (String)runtime.project);
                    request.getMessageHeader().setProjectId(runtime.project);
                    if (runtime.queryTopicID > 0) {
                        CRCSerializer.setQueryTopicId((RequestMessageType)request, (Long)Long.valueOf(runtime.queryTopicID));
                    }
                    Main.println("Submitting RequestExecutor thread " + t);
                    futures.put(t, executor.submit(new ReqThread(runtime.crc, request)));
                    Main.println("Sleeping for ms: " + runtime.sleep);
                    Thread.sleep(runtime.sleep);
                }
                block8: for (Integer t : futures.keySet()) {
                    Main.println("Waiting on thread " + t);
                    ReqResPair pair = (ReqResPair)((Future)futures.get(t)).get();
                    switch (pair.getStatus()) {
                        case COMPLETED: {
                            ++COUNT_COMPLETE;
                            continue block8;
                        }
                        case INCOMPLETE: {
                            ++COUNT_INCOMPLETE;
                            continue block8;
                        }
                        case ERROR: {
                            ++COUNT_ERROR;
                            continue block8;
                        }
                    }
                    throw new RuntimeException("Unheard of status returned by CRC: " + pair.getStatus().name());
                }
                Main.println("COMPLETED=" + COUNT_COMPLETE + " ERROR=" + COUNT_ERROR + " INCOMPLETE=" + COUNT_INCOMPLETE);
            }
        } while (runtime.repeat);
    }

    public static void showUsage() {
        Main.println("net.shrine.monitor.scanner.Main scanner.properties ");
        Main.println("options: ");
        for (String arg : RuntimeArgs.supported()) {
            Main.println(arg);
        }
    }

    private static void println(String line) {
        System.out.println(line);
    }
}

