/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.networkhealth;

import cats.Applicative;
import cats.Foldable;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import cats.implicits$;
import cats.syntax.NestedFoldableOps$;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.shrine.config.ConfigSource$;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.BouncyKeyStoreCollection$;
import net.shrine.http4s.catsio.IOScheduler;
import net.shrine.http4s.catsio.IOScheduler$;
import net.shrine.hub.HubDispatcher$;
import net.shrine.hub.data.store.ConnectivityTestResult;
import net.shrine.hub.data.store.ConnectivityTestResult$;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Log$;
import net.shrine.networkhealth.ConnectivityTestData;
import net.shrine.networkhealth.ConnectivityTestData$;
import net.shrine.networkhealth.ConnectivityTestException;
import net.shrine.networkhealth.template.NetworkHealthEmailer$;
import net.shrine.protocol.version.NodeName;
import net.shrine.protocol.version.QueryId;
import net.shrine.protocol.version.v1.CrcResult;
import net.shrine.protocol.version.v1.Node;
import net.shrine.protocol.version.v1.Query;
import net.shrine.protocol.version.v1.Query$;
import net.shrine.protocol.version.v1.QueryProgress;
import net.shrine.protocol.version.v1.Researcher;
import net.shrine.protocol.version.v1.Result;
import net.shrine.protocol.version.v1.RunQueryAtHub;
import net.shrine.protocol.version.v1.RunQueryAtHub$;
import net.shrine.protocol.version.v1.Topic;
import net.shrine.protocol.version.v1.VersionInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class NetworkHealthScheduler$ {
    public static NetworkHealthScheduler$ MODULE$;
    private Timer<IO> timer;
    private final Option<IOScheduler> scheduler;
    private volatile boolean bitmap$0;
    private volatile boolean bitmap$init$0;

    static {
        new NetworkHealthScheduler$();
    }

    private Timer<IO> timer$lzycompute() {
        NetworkHealthScheduler$ networkHealthScheduler$ = this;
        synchronized (networkHealthScheduler$) {
            if (!this.bitmap$0) {
                this.timer = IO$.MODULE$.timer((ExecutionContext)ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newScheduledThreadPool(2)));
                this.bitmap$0 = true;
            }
        }
        return this.timer;
    }

    public Timer<IO> timer() {
        return !this.bitmap$0 ? this.timer$lzycompute() : this.timer;
    }

    private Option<IOScheduler> scheduler() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/network-health/service/src/main/scala/net/shrine/networkhealth/NetworkHealthScheduler.scala: 27");
        }
        return this.scheduler;
    }

    public IO<BoxedUnit> restart() {
        return (IO)this.scheduler().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.unit(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.restart());
    }

    public IO<BoxedUnit> stop() {
        return (IO)this.scheduler().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.unit(), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.stop());
    }

    private Option<IOScheduler> scheduleConnectivityTest() {
        Option<ConnectivityTestData> connectivityTestDataOption = ConnectivityTestData$.MODULE$.fromConfig();
        BouncyKeyStoreCollection certCollection = BouncyKeyStoreCollection$.MODULE$.fromConfig();
        return connectivityTestDataOption.map((Function1 & Serializable & scala.Serializable)connectivityTestData -> {
            Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "Starting the connectivity test scheduler");
            return IOScheduler$.MODULE$.scheduleIndefinitely(connectivityTestData.delay(), connectivityTestData.interval(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.connectivityTest((ConnectivityTestData)connectivityTestData, certCollection), "NetworkHealthScheduler", MODULE$.timer());
        });
    }

    private IO<Query> runQuery(long queryId, Query originalQuery, Researcher researcher, Topic topic, BouncyKeyStoreCollection certCollection) {
        String x$1 = originalQuery.queryDefinitionXml();
        String x$2 = originalQuery.outputTypesXml();
        String x$3 = new StringBuilder(17).append("ConnectivityTest_").append(System.currentTimeMillis()).toString();
        long x$4 = originalQuery.nodeOfOriginId();
        long x$5 = researcher.id();
        long x$6 = originalQuery.topicId();
        String x$7 = originalQuery.projectName();
        BouncyKeyStoreCollection x$8 = certCollection;
        long x$9 = Query$.MODULE$.create$default$1();
        VersionInfo x$10 = Query$.MODULE$.create$default$10();
        QueryProgress query = Query$.MODULE$.create(x$9, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$10);
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("About to run the connectivity test with new query id ").append(new QueryId(query.id())).toString())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> HubDispatcher$.MODULE$.sendQueryToAdaptersIO(new RunQueryAtHub(query, researcher, topic, RunQueryAtHub$.MODULE$.apply$default$4()), 0).flatMap((Function1 & Serializable & scala.Serializable)_ -> NetworkHealthScheduler$.$anonfun$runQuery$4(query, BoxesRunTime.unboxToBoolean((Object)_))));
    }

    private IO<BoxedUnit> updateConnectivityTestResults(Query query) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "Updating the database with the latest connectivity test results")).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            ConnectivityTestResult connectivityTest = ConnectivityTestResult$.MODULE$.apply(((QueryId)query.id()).underlying());
            return new Tuple2(x$3, (Object)connectivityTest);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ConnectivityTestResult connectivityTest = (ConnectivityTestResult)tuple2._2();
            IO iO = HubDb$.MODULE$.db().insertConnectivityTestResultIO(connectivityTest).map((Function1 & Serializable & scala.Serializable)_ -> {
                NetworkHealthScheduler$.$anonfun$updateConnectivityTestResults$5(_);
                return BoxedUnit.UNIT;
            });
            return iO;
        });
    }

    private IO<BoxedUnit> sendEmailsIO(Query query, Iterable<Result> queryResults) {
        return (IO)NestedFoldableOps$.MODULE$.sequence_$extension(implicits$.MODULE$.catsSyntaxNestedFoldable((Object)((TraversableOnce)queryResults.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IO iO;
            Result result = x0$1;
            if (result instanceof CrcResult) {
                CrcResult crcResult = (CrcResult)result;
                iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Successfully ran connectivity test on node ").append(new NodeName(crcResult.adapterNodeName())).toString()));
            } else {
                iO = HubDb$.MODULE$.db().selectTheNetworkIO().map((Function1 & Serializable & scala.Serializable)x$5 -> new Some(x$5)).handleErrorWith((Function1 & Serializable & scala.Serializable)x$6 -> IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)network -> HubDb$.MODULE$.db().selectNodeIO(result.adapterNodeId()).map((Function1 & Serializable & scala.Serializable)maybeNode -> {
                    maybeNode.foreach((Function1 & Serializable & scala.Serializable)node -> {
                        NetworkHealthScheduler$.$anonfun$sendEmailsIO$9(network$1, query$3, x1$1, node);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }));
            }
            return iO;
        }, Iterable$.MODULE$.canBuildFrom())).toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()), (Foldable)implicits$.MODULE$.catsStdInstancesForList(), (Applicative)IO$.MODULE$.ioEffect());
    }

    private IO<BoxedUnit> checkAndReportErrorsIO(Query query) {
        return HubDb$.MODULE$.db().selectMostRecentResultsForQueryIO(((QueryId)query.id()).underlying()).flatMap((Function1 & Serializable & scala.Serializable)queryResultsIO -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Checking for and reporting any errors with running the connectivity test query with id ").append(query.id()).toString())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.sendEmailsIO(query, (Iterable<Result>)queryResultsIO).map((Function1 & Serializable & scala.Serializable)_ -> {
            NetworkHealthScheduler$.$anonfun$checkAndReportErrorsIO$5(_);
            return BoxedUnit.UNIT;
        })));
    }

    private IO<BoxedUnit> testAfterTimeLimit(Query query) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "Connectivity test time limit reached... performing update")).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.updateConnectivityTestResults(query).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.checkAndReportErrorsIO(query).map((Function1 & Serializable & scala.Serializable)_ -> {
            NetworkHealthScheduler$.$anonfun$testAfterTimeLimit$5(_);
            return BoxedUnit.UNIT;
        })));
    }

    private IO<BoxedUnit> connectivityTest(ConnectivityTestData testData, BouncyKeyStoreCollection certCollection) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.info((Function0 & Serializable & scala.Serializable)() -> "Starting the connectivity test")).flatMap((Function1 & Serializable & scala.Serializable)_ -> HubDb$.MODULE$.db().selectQueryIO(testData.queryId()).map((Function1 & Serializable & scala.Serializable)x$7 -> (Query)x$7.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConnectivityTestException("Error retrieving query from the database");
        })).flatMap((Function1 & Serializable & scala.Serializable)query -> HubDb$.MODULE$.db().selectResearcherByIdIO(testData.researcherId()).flatMap((Function1 & Serializable & scala.Serializable)researcher -> HubDb$.MODULE$.db().selectTopicByIdIO(query.topicId()).flatMap((Function1 & Serializable & scala.Serializable)topic -> MODULE$.runQuery(testData.queryId(), (Query)query, (Researcher)researcher.get(), (Topic)topic.get(), certCollection).flatMap((Function1 & Serializable & scala.Serializable)queryRan -> IOScheduler$.MODULE$.scheduleOnce(testData.timeLimit(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.testAfterTimeLimit((Query)queryRan), "NetworkHealthScheduler.testAfterTimeLimit", MODULE$.timer()).restart().map((Function1 & Serializable & scala.Serializable)_ -> {
            NetworkHealthScheduler$.$anonfun$connectivityTest$11(_);
            return BoxedUnit.UNIT;
        }))))));
    }

    public static final /* synthetic */ IO $anonfun$runQuery$4(QueryProgress query$1, boolean _2) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.info((Function0 & Serializable & scala.Serializable)() -> "Finished starting the connectivity test")).map((Function1 & Serializable & scala.Serializable)_ -> query$1);
    }

    public static final /* synthetic */ void $anonfun$updateConnectivityTestResults$5(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$sendEmailsIO$9(Option network$1, Query query$3, Result x1$1, Node node) {
        if (new StringOps(Predef$.MODULE$.augmentString(node.adminEmail())).nonEmpty()) {
            Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Sending email for connectivity test for node ").append(new NodeName(node.name())).append(" to ").append(node.adminEmail()).toString());
            .colon.colon toList = new .colon.colon((Object)node.adminEmail(), (List)Nil$.MODULE$);
            List ccList = (List)network$1.fold((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Function1 & Serializable & scala.Serializable)n -> new .colon.colon((Object)n.adminEmail(), (List)Nil$.MODULE$));
            NetworkHealthEmailer$.MODULE$.apply(ConfigSource$.MODULE$.config()).sendConnectivityIssueEmail(query$3, x1$1, (List<String>)toList, (List<String>)ccList);
        } else {
            Log$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Could not find email for connectivity test for ").append(new NodeName(node.name())).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$checkAndReportErrorsIO$5(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$testAfterTimeLimit$5(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$connectivityTest$11(BoxedUnit _) {
    }

    private NetworkHealthScheduler$() {
        MODULE$ = this;
        this.scheduler = this.scheduleConnectivityTest();
        this.bitmap$init$0 = true;
    }
}

