/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.networkhealth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.shrine.log.Log$;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.util.control.NonFatal$;

public final class ZipUtil$ {
    public static ZipUtil$ MODULE$;

    static {
        new ZipUtil$();
    }

    public Tuple2<ZipOutputStream, ByteArrayOutputStream> createZipStream(String jar) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ZipOutputStream zipStream = new ZipOutputStream(byteArrayOutputStream);
        try {
            JarFile jf = new JarFile(jar);
            Enumeration<JarEntry> iter = jf.entries();
            while (iter.hasMoreElements()) {
                JarEntry entry = iter.nextElement();
                if (!entry.getName().contains("webpage")) continue;
                this.addToZipFile(entry.getName(), entry.getLastModifiedTime().toMillis(), jf.getInputStream(entry), zipStream);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                Log$.MODULE$.error((Function0 & java.io.Serializable & Serializable)() -> "Error while zipping.", e);
                if (zipStream != null) {
                    zipStream.close();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
        return new Tuple2((Object)zipStream, (Object)byteArrayOutputStream);
    }

    private void addToZipFile(String inputFileName, long lastModified, InputStream inputStream, ZipOutputStream zipStream) {
        try {
            try {
                ZipEntry entry = new ZipEntry(inputFileName);
                entry.setCreationTime(FileTime.fromMillis(lastModified));
                entry.setComment("Created by SHRINE");
                zipStream.putNextEntry(entry);
                Log$.MODULE$.info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(25).append("Generated new entry for: ").append(inputFileName).toString());
                byte[] readBuffer = new byte[2048];
                int amountRead = 0;
                IntRef written = IntRef.create((int)0);
                amountRead = inputStream.read(readBuffer);
                while (amountRead > 0) {
                    zipStream.write(readBuffer, 0, amountRead);
                    written.elem += amountRead;
                    amountRead = inputStream.read(readBuffer);
                }
                Log$.MODULE$.info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(17).append("Stored ").append(written$1.elem).append(" bytes to ").append(inputFileName).toString());
            }
            catch (IOException e) {
                throw new Exception(new StringBuilder(18).append("Unable to process ").append(inputFileName).toString(), e);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private ZipUtil$() {
        MODULE$ = this;
    }
}

