/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub.setup;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.implicits$;
import ch.qos.logback.classic.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.hub.mom.ShrineMomClient$;
import net.shrine.hub.setup.ShrineNetworkLifecycle;
import net.shrine.hub.setup.ShrineNetworkLifecycle$CreateNetwork$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$CreateNode$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$DeleteNetworkQueues$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$DownstreamNodeMomArgs$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$Help$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$ListNetworkQueues$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$ListNodes$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$ModifyNetwork$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$ModifyNode$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$RecreateNetworkQueues$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$RestoreNode$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$RetireNode$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$ShowNetwork$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$ShowNode$;
import net.shrine.hub.setup.ShrineNetworkLifecycle$SwitchMomSystem$;
import net.shrine.hub.setup.WrongArgumentsException;
import net.shrine.log.Loggable;
import net.shrine.messagequeueservice.MomQueue;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.version.MomQueueName;
import net.shrine.protocol.version.v2.Network;
import net.shrine.protocol.version.v2.Node;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ShrineNetworkLifecycle$
implements Loggable {
    public static final ShrineNetworkLifecycle$ MODULE$ = new ShrineNetworkLifecycle$();
    private static Seq<ShrineNetworkLifecycle.Command> commands;
    private static Map<String, ShrineNetworkLifecycle.Command> namesToCommands;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile int bitmap$init$0;
    private static volatile byte bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        ShrineNetworkLifecycle$ shrineNetworkLifecycle$ = this;
        synchronized (shrineNetworkLifecycle$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public void main(String[] args) {
        int n;
        try {
            try {
                this.executeCommand(args);
                n = 0;
            }
            catch (WrongArgumentsException wax) {
                Predef$.MODULE$.println((Object)wax.getMessage());
                this.printUsage();
                n = 1;
            }
            catch (Throwable x) {
                x.printStackTrace();
                n = 2;
            }
        }
        finally {
            ExecutionContexts$.MODULE$.shutdownIO().unsafeRunSync(implicits$.MODULE$.global());
        }
        int status = n;
        System.exit(status);
    }

    public void executeCommand(String[] args) {
        Object object;
        String[] stringArray = args;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0) == 0) {
            throw new WrongArgumentsException(new StringBuilder(42).append("Requires at least one command argument of ").append(((IterableOnceOps)this.commands().map((Function1 & Serializable)x$1 -> x$1.name())).mkString(", ")).toString());
        }
        this.namesToCommands().get((Object)args[0]).map((Function1 & Serializable)x$2 -> x$2.doIt(args)).map((Function1 & Serializable)x$3 -> {
            x$3.unsafeRunSync(implicits$.MODULE$.global());
            return BoxedUnit.UNIT;
        }).orElse((Function0 & Serializable)() -> {
            throw new WrongArgumentsException(new StringBuilder(36).append(args[0]).append(" is not a valid command. Use one of ").append(((IterableOnceOps)MODULE$.commands().map((Function1 & Serializable)x$4 -> x$4.name())).mkString(", ")).toString());
        });
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("./shrineLifecycle help - to see a list of commands\n      ")));
    }

    private Seq<ShrineNetworkLifecycle.Command> commands$lzycompute() {
        ShrineNetworkLifecycle$ shrineNetworkLifecycle$ = this;
        synchronized (shrineNetworkLifecycle$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                commands = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShrineNetworkLifecycle.Command[]{ShrineNetworkLifecycle$CreateNetwork$.MODULE$, ShrineNetworkLifecycle$ModifyNetwork$.MODULE$, ShrineNetworkLifecycle$ShowNetwork$.MODULE$, ShrineNetworkLifecycle$ListNodes$.MODULE$, ShrineNetworkLifecycle$CreateNode$.MODULE$, ShrineNetworkLifecycle$ModifyNode$.MODULE$, ShrineNetworkLifecycle$ShowNode$.MODULE$, ShrineNetworkLifecycle$DownstreamNodeMomArgs$.MODULE$, ShrineNetworkLifecycle$RetireNode$.MODULE$, ShrineNetworkLifecycle$RestoreNode$.MODULE$, ShrineNetworkLifecycle$DeleteNetworkQueues$.MODULE$, ShrineNetworkLifecycle$RecreateNetworkQueues$.MODULE$, ShrineNetworkLifecycle$ListNetworkQueues$.MODULE$, ShrineNetworkLifecycle$SwitchMomSystem$.MODULE$, ShrineNetworkLifecycle$Help$.MODULE$}));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return commands;
    }

    public Seq<ShrineNetworkLifecycle.Command> commands() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.commands$lzycompute();
        }
        return commands;
    }

    private Map<String, ShrineNetworkLifecycle.Command> namesToCommands$lzycompute() {
        ShrineNetworkLifecycle$ shrineNetworkLifecycle$ = this;
        synchronized (shrineNetworkLifecycle$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                namesToCommands = ((IterableOnceOps)this.commands().map((Function1 & Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.name()), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return namesToCommands;
    }

    public Map<String, ShrineNetworkLifecycle.Command> namesToCommands() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.namesToCommands$lzycompute();
        }
        return namesToCommands;
    }

    public IO<BoxedUnit> setUpNode(Node node, Network network) {
        return ShrineMomClient$.MODULE$.serviceIO().flatMap((Function1 & Serializable)shrineMomClient -> shrineMomClient.createQueueIfAbsentIO(node.momQueueName()).flatMap((Function1 & Serializable)x$42 -> {
            MomQueue momQueue = x$42;
            return shrineMomClient.addReceiverPermissionToQueueIO(node.momQueueName(), node.momId()).flatMap((Function1 & Serializable)x$41 -> {
                BoxedUnit boxedUnit = x$41;
                return shrineMomClient.addSenderPermissionToQueueIO(node.momQueueName(), network.momId()).flatMap((Function1 & Serializable)x$40 -> {
                    BoxedUnit boxedUnit = x$40;
                    return shrineMomClient.addSenderPermissionToQueueIO(network.hubQueueName(), node.momId()).flatMap((Function1 & Serializable)x$39 -> {
                        BoxedUnit boxedUnit = x$39;
                        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(8).append("Created ").append(new MomQueueName(node.momQueueName())).toString())).map((Function1 & Serializable)x$38 -> {
                            boxedUnit = x$38;
                            return BoxedUnit.UNIT;
                        });
                    });
                });
            });
        }));
    }

    public IO<BoxedUnit> createAllNeededQueues(Network network) {
        boolean createSqsQueues;
        boolean bl = createSqsQueues = network.awsSqsConfig().isDefined() || network.kafkaConfig().isDefined();
        if (createSqsQueues) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("About to create all the queues for ").append(network.networkName()).toString());
            IO networkAndNodesIO = ShrineMomClient$.MODULE$.serviceIOFromNetwork(network).flatMap((Function1 & Serializable)momService -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("mom service to create ").append(new MomQueueName(network.hubQueueName())).toString())).flatMap((Function1 & Serializable)x$50 -> {
                BoxedUnit boxedUnit = x$50;
                return momService.createQueueIfAbsentIO(network.hubQueueName()).flatMap((Function1 & Serializable)x$49 -> {
                    MomQueue momQueue = x$49;
                    return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("add receiver permission to ").append(new MomQueueName(network.hubQueueName())).toString())).flatMap((Function1 & Serializable)x$48 -> {
                        BoxedUnit boxedUnit = x$48;
                        return momService.addReceiverPermissionToQueueIO(network.hubQueueName(), network.momId()).flatMap((Function1 & Serializable)x$47 -> {
                            BoxedUnit boxedUnit = x$47;
                            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(8).append("Created ").append(new MomQueueName(network.hubQueueName())).toString())).flatMap((Function1 & Serializable)x$46 -> {
                                BoxedUnit boxedUnit = x$46;
                                return HubDb$.MODULE$.db().selectLatestNodesIO().map((Function1 & Serializable)x$43 -> x$43.toSeq()).map((Function1 & Serializable)x$44 -> (Seq)x$44.map((Function1 & Serializable)x$45 -> (Node)x$45.get())).map((Function1 & Serializable)nodes -> new Tuple2((Object)network, nodes));
                            });
                        });
                    });
                });
            }));
            return networkAndNodesIO.flatMap((Function1 & Serializable)networkAndNodes -> {
                Seq ios = (Seq)((IterableOps)networkAndNodes._2()).map((Function1 & Serializable)node -> MODULE$.setUpNode((Node)node, (Network)networkAndNodes._1()));
                Seq streams = (Seq)ios.map((Function1 & Serializable)fo -> Stream$.MODULE$.eval(fo));
                return (IO)((Stream)streams.foldLeft((Object)Stream$.MODULE$.empty(), (Function2 & Serializable)(soFar, next) -> soFar.append((Function0 & Serializable)() -> next))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
            });
        }
        return IO$.MODULE$.unit();
    }

    private ShrineNetworkLifecycle$() {
    }
}

