/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub.setup;

import cats.effect.unsafe.implicits$;
import java.io.Serializable;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.hub.setup.ShrineNetworkLifecycle;
import net.shrine.hub.setup.ShrineNetworkLifecycle$;
import net.shrine.hub.setup.WrongArgumentsException;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.ItemVersion$;
import net.shrine.protocol.version.MomQueueName$;
import net.shrine.protocol.version.NetworkId$;
import net.shrine.protocol.version.v2.Network;
import net.shrine.protocol.version.v2.Network$;
import net.shrine.protocol.version.v2.Node;
import net.shrine.protocol.version.v2.Node$;
import net.shrine.protocol.version.v2.VersionInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005e4AAE\n\u00019!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0003A\u0003BB \u0001A\u0003%\u0011\u0006C\u0003A\u0001\u0011\u0005\u0011\tC\u0004S\u0001\t\u0007I\u0011A*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u0015A\u0006\u0001\"\u0001B\u0011\u0015Q\u0006\u0001\"\u0001B\u0011\u0015\u0001\u0007\u0001\"\u0001B\u0011\u0015\u0011\u0007\u0001\"\u0001B\u0011\u0015!\u0007\u0001\"\u0001B\u0011\u00151\u0007\u0001\"\u0001B\u0011\u0015A\u0007\u0001\"\u0001B\u0011\u0015Q\u0007\u0001\"\u0001B\u0011\u0015a\u0007\u0001\"\u0001B\u0011\u0015y\u0007\u0001\"\u0001B\u0011\u0015!\b\u0001\"\u0001B\u0005i\u0019\u0006N]5oK:+Go^8sW2Kg-Z2zG2,G+Z:u\u0015\t!R#A\u0003tKR,\bO\u0003\u0002\u0017/\u0005\u0019\u0001.\u001e2\u000b\u0005aI\u0012AB:ie&tWMC\u0001\u001b\u0003\rqW\r^\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003M\tQ#\u001a=qK\u000e$X\r\u001a(pI\u0016$V-\u001c9mCR,7/F\u0001*!\rQ#'\u000e\b\u0003WAr!\u0001L\u0018\u000e\u00035R!AL\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013BA\u0019 \u0003\u001d\u0001\u0018mY6bO\u0016L!a\r\u001b\u0003\u0007M+\u0017O\u0003\u00022?A\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\u0003mJR!AO\u001e\u0002\u000fY,'o]5p]*\u0011AhF\u0001\taJ|Go\\2pY&\u0011ah\u000e\u0002\u0005\u001d>$W-\u0001\ffqB,7\r^3e\u001d>$W\rV3na2\fG/Z:!\u0003!!Xm\u001d;IK2\u0004H#\u0001\"\u0011\u0005y\u0019\u0015B\u0001# \u0005\u0011)f.\u001b;)\u0005\u00111\u0005CA$Q\u001b\u0005A%BA%K\u0003\r\t\u0007/\u001b\u0006\u0003\u00172\u000bqA[;qSR,'O\u0003\u0002N\u001d\u0006)!.\u001e8ji*\tq*A\u0002pe\u001eL!!\u0015%\u0003\tQ+7\u000f^\u0001\u0010i\u0016l\u0007\u000f\\1uK:+Go^8sWV\tA\u000b\u0005\u00027+&\u0011ak\u000e\u0002\b\u001d\u0016$xo\u001c:l\u0003A!X-\u001c9mCR,g*\u001a;x_J\\\u0007%A\tuKN$8I]3bi\u0016tU\r^<pe.D#a\u0002$\u0002-Q,7\u000f^\"sK\u0006$XmS1gW\u0006tU\r^<pe.D#\u0001\u0003$)\u0005!i\u0006CA$_\u0013\ty\u0006J\u0001\u0005ESN\f'\r\\3e\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a(fi^|'o\u001b+xS\u000e,7\u000b[8vY\u00124\u0015-\u001b7)\u0005%1\u0015!\u0005;fgRlu\u000eZ5gs:+Go^8sW\"\u0012!BR\u0001\u0018i\u0016\u001cHo\u00155po:+Go^8sW\u0006sGMT8eKND#a\u0003$\u0002\u001dQ,7\u000f^\"sK\u0006$XMT8eK\"\u0012ABR\u0001\u000fi\u0016\u001cH/T8eS\u001aLhj\u001c3fQ\tia)A\u000buKN$(+\u001a;je\u0016\u0014Vm\u001d;pe\u0016tu\u000eZ3)\u000591\u0015a\u0005;fgR\u001cv/\u001b;dQ6{WnU=ti\u0016l\u0007FA\bGQ\tyQ,\u0001\u0006cK\u001a|'/Z#bG\"D#\u0001E9\u0011\u0005\u001d\u0013\u0018BA:I\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\nC\u001a$XM]#bG\"D#!\u0005<\u0011\u0005\u001d;\u0018B\u0001=I\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000e")
public class ShrineNetworkLifecycleTest {
    private final Seq<Node> expectedNodeTemplates;
    private final Network templateNetwork;
    private volatile byte bitmap$init$0;

    public Seq<Node> expectedNodeTemplates() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ShrineNetworkLifecycleTest.scala: 12");
        }
        return this.expectedNodeTemplates;
    }

    @Test
    public void testHelp() {
        ShrineNetworkLifecycle.Help$.MODULE$.doIt((String[])((Object[])new String[]{"help"})).unsafeRunSync(implicits$.MODULE$.global());
        ShrineNetworkLifecycle$.MODULE$.commands().foreach((Function1 & Serializable)command -> {
            ShrineNetworkLifecycleTest.$anonfun$testHelp$1(command);
            return BoxedUnit.UNIT;
        });
    }

    public Network templateNetwork() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ShrineNetworkLifecycleTest.scala: 57");
        }
        return this.templateNetwork;
    }

    @Test
    public void testCreateNetwork() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync(implicits$.MODULE$.global());
        VersionInfo x$1 = network.versionInfo();
        long x$22 = this.templateNetwork().copy$default$1();
        String x$32 = this.templateNetwork().copy$default$3();
        String x$4 = this.templateNetwork().copy$default$4();
        String x$5 = this.templateNetwork().copy$default$5();
        String x$6 = this.templateNetwork().copy$default$6();
        Option x$7 = this.templateNetwork().copy$default$7();
        Option x$8 = this.templateNetwork().copy$default$8();
        Network expectedNetwork = this.templateNetwork().copy(x$22, x$1, x$32, x$4, x$5, x$6, x$7, x$8);
        Assertions.assertEquals((Object)expectedNetwork, (Object)network);
        Seq nodes = (Seq)((IterableOnceOps)((IterableOps)HubDb$.MODULE$.db().selectLatestNodesIO().unsafeRunSync(implicits$.MODULE$.global())).map((Function1 & Serializable)x$2 -> (Node)x$2.get())).toSeq().sortBy((Function1 & Serializable)x$3 -> x$3.key(), (Ordering)Ordering.String$.MODULE$);
        Seq expectedNodes = (Seq)((IterableOps)this.expectedNodeTemplates().zip((IterableOnce)nodes)).map((Function1 & Serializable)nodePair -> ((Node)nodePair._1()).copy(((Node)nodePair._2()).id(), ((Node)nodePair._2()).versionInfo(), ((Node)nodePair._1()).copy$default$3(), ((Node)nodePair._1()).copy$default$4(), ((Node)nodePair._1()).copy$default$5(), ((Node)nodePair._1()).copy$default$6(), ((Node)nodePair._1()).copy$default$7(), ((Node)nodePair._1()).copy$default$8(), ((Node)nodePair._1()).copy$default$9(), ((Node)nodePair._1()).copy$default$10()));
        Assertions.assertEquals((Object)expectedNodes, (Object)nodes);
    }

    @Test
    @Disabled
    public void testCreateKafkaNetwork() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "../../docker/scripts/src/main/docker/dev-environments/shrine-hub/network-setup/network.conf"}));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync(implicits$.MODULE$.global());
        VersionInfo x$1 = network.versionInfo();
        long x$2 = this.templateNetwork().copy$default$1();
        String x$3 = this.templateNetwork().copy$default$3();
        String x$42 = this.templateNetwork().copy$default$4();
        String x$52 = this.templateNetwork().copy$default$5();
        String x$6 = this.templateNetwork().copy$default$6();
        Option x$7 = this.templateNetwork().copy$default$7();
        Option x$8 = this.templateNetwork().copy$default$8();
        Network expectedNetwork = this.templateNetwork().copy(x$2, x$1, x$3, x$42, x$52, x$6, x$7, x$8);
        Seq nodes = (Seq)((IterableOnceOps)((IterableOps)HubDb$.MODULE$.db().selectLatestNodesIO().unsafeRunSync(implicits$.MODULE$.global())).map((Function1 & Serializable)x$4 -> (Node)x$4.get())).toSeq().sortBy((Function1 & Serializable)x$5 -> x$5.key(), (Ordering)Ordering.String$.MODULE$);
        Seq expectedNodes = (Seq)((IterableOps)this.expectedNodeTemplates().zip((IterableOnce)nodes)).map((Function1 & Serializable)nodePair -> ((Node)nodePair._1()).copy(((Node)nodePair._2()).id(), ((Node)nodePair._2()).versionInfo(), ((Node)nodePair._1()).copy$default$3(), ((Node)nodePair._1()).copy$default$4(), ((Node)nodePair._1()).copy$default$5(), ((Node)nodePair._1()).copy$default$6(), ((Node)nodePair._1()).copy$default$7(), ((Node)nodePair._1()).copy$default$8(), ((Node)nodePair._1()).copy$default$9(), ((Node)nodePair._1()).copy$default$10()));
    }

    @Test
    public void testCreateNetworkTwiceShouldFail() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Assertions.assertThrows(WrongArgumentsException.class, () -> ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"})));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync(implicits$.MODULE$.global());
        VersionInfo x$1 = network.versionInfo();
        long x$2 = this.templateNetwork().copy$default$1();
        String x$3 = this.templateNetwork().copy$default$3();
        String x$4 = this.templateNetwork().copy$default$4();
        String x$5 = this.templateNetwork().copy$default$5();
        String x$62 = this.templateNetwork().copy$default$6();
        Option x$72 = this.templateNetwork().copy$default$7();
        Option x$8 = this.templateNetwork().copy$default$8();
        Network expectedNetwork = this.templateNetwork().copy(x$2, x$1, x$3, x$4, x$5, x$62, x$72, x$8);
        Assertions.assertEquals((Object)expectedNetwork, (Object)network);
        Seq nodes = (Seq)((IterableOnceOps)((IterableOps)HubDb$.MODULE$.db().selectLatestNodesIO().unsafeRunSync(implicits$.MODULE$.global())).map((Function1 & Serializable)x$6 -> (Node)x$6.get())).toSeq().sortBy((Function1 & Serializable)x$7 -> x$7.key(), (Ordering)Ordering.String$.MODULE$);
        Seq expectedNodes = (Seq)((IterableOps)this.expectedNodeTemplates().zip((IterableOnce)nodes)).map((Function1 & Serializable)nodePair -> ((Node)nodePair._1()).copy(((Node)nodePair._2()).id(), ((Node)nodePair._2()).versionInfo(), ((Node)nodePair._1()).copy$default$3(), ((Node)nodePair._1()).copy$default$4(), ((Node)nodePair._1()).copy$default$5(), ((Node)nodePair._1()).copy$default$6(), ((Node)nodePair._1()).copy$default$7(), ((Node)nodePair._1()).copy$default$8(), ((Node)nodePair._1()).copy$default$9(), ((Node)nodePair._1()).copy$default$10()));
        Assertions.assertEquals((Object)expectedNodes, (Object)nodes);
    }

    @Test
    public void testModifyNetwork() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"modifyNetwork", "name=Better-named-network"}));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync(implicits$.MODULE$.global());
        long x$1 = NetworkId$.MODULE$.oneNetwork();
        String x$2 = "Better-named-network";
        String x$3 = MomQueueName$.MODULE$.apply("hub");
        String x$4 = "yourEmail@your.ctsa.edu";
        String x$5 = "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName";
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        VersionInfo x$8 = Network$.MODULE$.apply$default$2();
        Network qual$1 = new Network(x$1, x$8, "Better-named-network", x$3, "yourEmail@your.ctsa.edu", "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName", (Option)x$6, (Option)x$7);
        VersionInfo x$9 = network.versionInfo();
        long x$10 = qual$1.copy$default$1();
        String x$11 = qual$1.copy$default$3();
        String x$12 = qual$1.copy$default$4();
        String x$13 = qual$1.copy$default$5();
        String x$14 = qual$1.copy$default$6();
        Option x$15 = qual$1.copy$default$7();
        Option x$16 = qual$1.copy$default$8();
        Network expectedNetwork = qual$1.copy(x$10, x$9, x$11, x$12, x$13, x$14, x$15, x$16);
        Assertions.assertEquals((Object)expectedNetwork, (Object)network);
        Assertions.assertEquals((int)2, (int)network.versionInfo().itemVersion());
    }

    @Test
    public void testShowNetworkAndNodes() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"showNetwork"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"listNodes"}));
        String nodeKey = ((Node)this.expectedNodeTemplates().head()).key();
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"showNode", nodeKey}));
    }

    @Test
    public void testCreateNode() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNode", "key=h4", "name=Hospital 4", "userDomainName=h4Land", "adminEmail=yourself@h4.edu", "queueName=h4q", "momId=h4IsMe"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"showNode", "h4"}));
        Option node = (Option)HubDb$.MODULE$.db().selectNodeByKeyIO("h4").unsafeRunSync(implicits$.MODULE$.global());
        String x$1 = "Hospital 4";
        String x$2 = "h4";
        String x$3 = "h4Land";
        String x$4 = "yourself@h4.edu";
        Option x$5 = Option$.MODULE$.apply((Object)"h4q");
        String x$6 = "h4IsMe";
        boolean x$7 = Node$.MODULE$.create$default$6();
        VersionInfo x$8 = Node$.MODULE$.create$default$8();
        int x$9 = Node$.MODULE$.create$default$9();
        Node qual$1 = Node$.MODULE$.create("Hospital 4", "h4", "h4Land", "yourself@h4.edu", x$5, x$7, "h4IsMe", x$8, x$9);
        long x$10 = ((Node)node.get()).id();
        VersionInfo x$11 = ((Node)node.get()).versionInfo();
        String x$12 = qual$1.copy$default$3();
        String x$13 = qual$1.copy$default$4();
        String x$14 = qual$1.copy$default$5();
        String x$15 = qual$1.copy$default$6();
        String x$16 = qual$1.copy$default$7();
        boolean x$17 = qual$1.copy$default$8();
        int x$18 = qual$1.copy$default$9();
        String x$19 = qual$1.copy$default$10();
        Node expectedNode = qual$1.copy(x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        Assertions.assertEquals((Object)expectedNode, (Object)node.get());
    }

    @Test
    public void testModifyNode() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"modifyNode", "shrine-dev-hub", "name=Best CTSA"}));
        Option nodeOpt = (Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-hub").unsafeRunSync(implicits$.MODULE$.global());
        Node node = (Node)nodeOpt.get();
        Node qual$1 = Node$.MODULE$.create("Best CTSA", "shrine-dev-hub", "shrine-dev-hub", "yourEmail@your.ctsa.edu", Option$.MODULE$.apply((Object)"shrinedevhub"), false, "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName", new VersionInfo(1, "3.3.2", ItemVersion$.MODULE$.one(), node.versionInfo().createDate(), node.versionInfo().changeDate()), Node$.MODULE$.create$default$9());
        long x$1 = node.id();
        VersionInfo x$2 = node.versionInfo();
        String x$3 = qual$1.copy$default$3();
        String x$4 = qual$1.copy$default$4();
        String x$5 = qual$1.copy$default$5();
        String x$6 = qual$1.copy$default$6();
        String x$7 = qual$1.copy$default$7();
        boolean x$8 = qual$1.copy$default$8();
        int x$9 = qual$1.copy$default$9();
        String x$10 = qual$1.copy$default$10();
        Node expectedNode = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        Assertions.assertEquals((Object)expectedNode, (Object)node);
    }

    @Test
    public void testRetireRestoreNode() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Node beforeNode = (Node)((Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-node01").unsafeRunSync(implicits$.MODULE$.global())).get();
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"retireNode", "shrine-dev-node01"}));
        Node retiredNode = (Node)((Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-node01").unsafeRunSync(implicits$.MODULE$.global())).get();
        VersionInfo x$1 = retiredNode.versionInfo();
        boolean x$2 = false;
        long x$3 = beforeNode.copy$default$1();
        String x$4 = beforeNode.copy$default$3();
        String x$5 = beforeNode.copy$default$4();
        String x$6 = beforeNode.copy$default$5();
        String x$7 = beforeNode.copy$default$6();
        String x$8 = beforeNode.copy$default$7();
        int x$9 = beforeNode.copy$default$9();
        String x$10 = beforeNode.copy$default$10();
        Node expectedNode = beforeNode.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, false, x$9, x$10);
        Assertions.assertEquals((Object)expectedNode, (Object)retiredNode);
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"restoreNode", "shrine-dev-node01"}));
        Node restoredNode = (Node)((Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-node01").unsafeRunSync(implicits$.MODULE$.global())).get();
        VersionInfo x$11 = restoredNode.versionInfo();
        boolean x$12 = true;
        long x$13 = beforeNode.copy$default$1();
        String x$14 = beforeNode.copy$default$3();
        String x$15 = beforeNode.copy$default$4();
        String x$16 = beforeNode.copy$default$5();
        String x$17 = beforeNode.copy$default$6();
        String x$18 = beforeNode.copy$default$7();
        int x$19 = beforeNode.copy$default$9();
        String x$20 = beforeNode.copy$default$10();
        Node expectedRestoredNode = beforeNode.copy(x$13, x$11, x$14, x$15, x$16, x$17, x$18, true, x$19, x$20);
        Assertions.assertEquals((Object)expectedRestoredNode, (Object)restoredNode);
    }

    @Test
    @Disabled
    public void testSwitchMomSystem() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Network startNetwork = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync(implicits$.MODULE$.global());
        VersionInfo x$1 = startNetwork.versionInfo();
        long x$2 = this.templateNetwork().copy$default$1();
        String x$3 = this.templateNetwork().copy$default$3();
        String x$4 = this.templateNetwork().copy$default$4();
        String x$5 = this.templateNetwork().copy$default$5();
        String x$6 = this.templateNetwork().copy$default$6();
        Option x$7 = this.templateNetwork().copy$default$7();
        Option x$82 = this.templateNetwork().copy$default$8();
        Network expectedStartNetwork = this.templateNetwork().copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$82);
        Assertions.assertEquals((Object)expectedStartNetwork, (Object)startNetwork);
        Seq startNodes = (Seq)((IterableOnceOps)((IterableOps)HubDb$.MODULE$.db().selectLatestNodesIO().unsafeRunSync(implicits$.MODULE$.global())).map((Function1 & Serializable)x$8 -> (Node)x$8.get())).toSeq().sortBy((Function1 & Serializable)x$9 -> x$9.key(), (Ordering)Ordering.String$.MODULE$);
        Seq expectedStartNodes = (Seq)((IterableOps)this.expectedNodeTemplates().zip((IterableOnce)startNodes)).map((Function1 & Serializable)nodePair -> ((Node)nodePair._1()).copy(((Node)nodePair._2()).id(), ((Node)nodePair._2()).versionInfo(), ((Node)nodePair._1()).copy$default$3(), ((Node)nodePair._1()).copy$default$4(), ((Node)nodePair._1()).copy$default$5(), ((Node)nodePair._1()).copy$default$6(), ((Node)nodePair._1()).copy$default$7(), ((Node)nodePair._1()).copy$default$8(), ((Node)nodePair._1()).copy$default$9(), ((Node)nodePair._1()).copy$default$10()));
        Assertions.assertEquals((Object)expectedStartNodes, (Object)startNodes);
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"switchMomSystem", "src/test/inputs/switch-network-to-kafka.conf"}));
        Network kafkaNetwork = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync(implicits$.MODULE$.global());
    }

    @BeforeEach
    public void beforeEach() {
        HubDb$.MODULE$.db().createTables();
    }

    @AfterEach
    public void afterEach() {
        HubDb$.MODULE$.db().dropTables();
    }

    public static final /* synthetic */ void $anonfun$testHelp$1(ShrineNetworkLifecycle.Command command) {
        ShrineNetworkLifecycle.Help$.MODULE$.doIt((String[])((Object[])new String[]{"help", command.name()})).unsafeRunSync(implicits$.MODULE$.global());
    }

    public ShrineNetworkLifecycleTest() {
        String x$12 = "Famous Hospital 2";
        String x$2 = "shrine-dev-node02";
        String x$3 = "shrine-dev-node02";
        String x$4 = "admin@hospital.famousUniversity2.edu";
        Option x$5 = Option$.MODULE$.apply((Object)"shrinedevnode02");
        String x$6 = "arn:aws:iam::Node2AWSAccountNumber:user/node02UserName";
        VersionInfo x$7 = new VersionInfo(1, "3.3.2", ItemVersion$.MODULE$.one(), DateStamp$.MODULE$.now(), DateStamp$.MODULE$.now());
        int x$8 = 1;
        boolean x$9 = Node$.MODULE$.create$default$6();
        String x$10 = "Famous Hospital 1";
        String x$11 = "shrine-dev-node01";
        String x$122 = "shrine-dev-node01";
        String x$13 = "admin@hospital.famousUniversity1.edu";
        Option x$14 = Option$.MODULE$.apply((Object)"shrinedevnode01");
        String x$15 = "arn:aws:iam::Node1AWSAccountNumber:user/node01UserName";
        boolean x$16 = Node$.MODULE$.create$default$6();
        VersionInfo x$17 = Node$.MODULE$.create$default$8();
        int x$18 = Node$.MODULE$.create$default$9();
        this.expectedNodeTemplates = (Seq)new .colon.colon((Object)Node$.MODULE$.create("Test CTSA", "shrine-dev-hub", "shrine-dev-hub", "yourEmail@your.ctsa.edu", Option$.MODULE$.apply((Object)"shrinedevhub"), false, "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName", Node$.MODULE$.create$default$8(), Node$.MODULE$.create$default$9()), (List)new .colon.colon((Object)Node$.MODULE$.create("Famous Hospital 2", "shrine-dev-node02", "shrine-dev-node02", "admin@hospital.famousUniversity2.edu", x$5, x$9, "arn:aws:iam::Node2AWSAccountNumber:user/node02UserName", x$7, x$8), (List)new .colon.colon((Object)Node$.MODULE$.create("Famous Hospital 1", "shrine-dev-node01", "shrine-dev-node01", "admin@hospital.famousUniversity1.edu", x$14, x$16, "arn:aws:iam::Node1AWSAccountNumber:user/node01UserName", x$17, x$18), (List)Nil$.MODULE$))).sortBy((Function1 & Serializable)x$1 -> x$1.key(), (Ordering)Ordering.String$.MODULE$);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        long x$19 = NetworkId$.MODULE$.oneNetwork();
        String x$20 = "SHRINE Dev test network";
        String x$21 = MomQueueName$.MODULE$.apply("hub");
        String x$22 = "yourEmail@your.ctsa.edu";
        String x$23 = "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName";
        None$ x$24 = None$.MODULE$;
        None$ x$25 = None$.MODULE$;
        VersionInfo x$26 = Network$.MODULE$.apply$default$2();
        this.templateNetwork = new Network(x$19, x$26, "SHRINE Dev test network", x$21, "yourEmail@your.ctsa.edu", "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName", (Option)x$24, (Option)x$25);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

