/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub.metrics;

import java.io.Serializable;
import net.shrine.api.ontology.CodeCategory;
import net.shrine.api.ontology.OntologyPath;
import net.shrine.hub.metrics.CommonMaps$;
import net.shrine.hub.metrics.QueryRow;
import net.shrine.protocol.version.DateStamp;
import net.shrine.protocol.version.NodeId;
import net.shrine.protocol.version.NodeKey;
import net.shrine.protocol.version.NodeName;
import net.shrine.protocol.version.QueryId;
import net.shrine.protocol.version.ResearcherId;
import net.shrine.protocol.version.UserDomainName;
import net.shrine.protocol.version.UserName;
import net.shrine.protocol.version.v2.CountResult;
import net.shrine.protocol.version.v2.ErrorResult;
import net.shrine.protocol.version.v2.Node;
import net.shrine.protocol.version.v2.Query;
import net.shrine.protocol.version.v2.QueryError;
import net.shrine.protocol.version.v2.QueryStatus;
import net.shrine.protocol.version.v2.QueryStatus$;
import net.shrine.protocol.version.v2.Researcher;
import net.shrine.protocol.version.v2.Result;
import net.shrine.qep.BasicQuery$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple18;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.XML$;

public final class QueryRow$
implements Serializable {
    public static final QueryRow$ MODULE$ = new QueryRow$();
    private static Map<OntologyPath, CodeCategory> codeCategoryMap;
    private static final Set<QueryStatus> ignoreStatuses;
    private static final Seq<QueryStatus> statusOrder;
    private static final String[] header;
    private static volatile byte bitmap$init$0;
    private static volatile boolean bitmap$0;

    static {
        ignoreStatuses = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QueryStatus[]{QueryStatus.UnknownFinal$.MODULE$, QueryStatus.UnknownInTransit$.MODULE$, QueryStatus.IdAssigned$.MODULE$, QueryStatus.SentToHub$.MODULE$}))).$plus$plus((IterableOnce)QueryStatus$.MODULE$.statuses().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isFinal())));
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        statusOrder = (Seq)QueryStatus$.MODULE$.statuses().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)QueryRow$.$anonfun$statusOrder$1(elem)));
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        String[] fixedNames = (String[])((Object[])new String[]{"Query ID", "Query Name", "Origin Node Key", "Origin Node Name", "Researcher User Name", "Researcher Authentication Domain", "Start Date", "Status", "Sites With Counts", "Total Patient Count", "Sites With Errors", "Sites Still Pending", "Query Error Codec", "Query Error Summary"});
        Seq stateNames = (Seq)((IterableOps)MODULE$.statusOrder().map((Function1 & Serializable)x$4 -> x$4.statusName())).map((Function1 & Serializable)x -> new StringBuilder(13).append("Time in ").append((String)x).append(" (ms)").toString());
        header = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])fixedNames), (IterableOnce)stateNames, ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{"Query Terms", "Query Text", "Query Json"}, ClassTag$.MODULE$.apply(String.class));
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    public Set<QueryStatus> ignoreStatuses() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueryCsv.scala: 79");
        }
        return ignoreStatuses;
    }

    public Seq<QueryStatus> statusOrder() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueryCsv.scala: 86");
        }
        return statusOrder;
    }

    public String[] header() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueryCsv.scala: 88");
        }
        return header;
    }

    private Map<OntologyPath, CodeCategory> codeCategoryMap$lzycompute() {
        QueryRow$ queryRow$ = this;
        synchronized (queryRow$) {
            if (!bitmap$0) {
                codeCategoryMap = Predef$.MODULE$.Map().empty().withDefaultValue((Object)new CodeCategory(""));
                bitmap$0 = true;
            }
        }
        return codeCategoryMap;
    }

    private Map<OntologyPath, CodeCategory> codeCategoryMap() {
        if (!bitmap$0) {
            return this.codeCategoryMap$lzycompute();
        }
        return codeCategoryMap;
    }

    public QueryRow apply(Seq<Query> queryHistory, Seq<Result> latestResults) {
        String string;
        String string2;
        Query latestQuery = (Query)queryHistory.head();
        Node node = (Node)CommonMaps$.MODULE$.nodeIdToNode().apply((Object)new NodeId(latestQuery.nodeOfOriginId()));
        Researcher researcher = (Researcher)CommonMaps$.MODULE$.researcherIdToResearcher().apply((Object)new ResearcherId(latestQuery.researcherId()));
        Seq countResults = (Seq)latestResults.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Result, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CountResult) {
                    CountResult countResult = (CountResult)A1;
                    return (B1)countResult;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Result x1) {
                Result result = x1;
                return result instanceof CountResult;
            }
        });
        Seq errorResults = (Seq)latestResults.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Result, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof ErrorResult) {
                    ErrorResult errorResult = (ErrorResult)A1;
                    return (B1)errorResult;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Result x2) {
                Result result = x2;
                return result instanceof ErrorResult;
            }
        });
        int sitesPending = latestResults.size() - (errorResults.size() + countResults.size());
        Seq queryStatesAndDateStamps = (Seq)((SeqOps)queryHistory.map((Function1 & Serializable)q -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)q.status()), (Object)new DateStamp(q.versionInfo().changeDate())))).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)QueryRow$.$anonfun$apply$2(x$5)), (Ordering)Ordering.Long$.MODULE$);
        Seq zippedQueryStatesAndDateStamps = (Seq)queryStatesAndDateStamps.zip((IterableOnce)queryStatesAndDateStamps.tail());
        Map queryStatesToTimeInState = ((IterableOnceOps)zippedQueryStatesAndDateStamps.map((Function1 & Serializable)zippedQsDs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((Tuple2)zippedQsDs._1())._1()), (Object)BoxesRunTime.boxToLong((long)(((DateStamp)((Tuple2)zippedQsDs._2())._2()).underlying() - ((DateStamp)((Tuple2)zippedQsDs._1())._2()).underlying()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq queryTerms = latestQuery.queryDefinition().expression().flattenedConcepts();
        String queryAsHtml = new StringBuilder(21).append("<outerTag>").append(BasicQuery$.MODULE$.fromV2Query(latestQuery).htmlQueryText(this.codeCategoryMap())).append("</outerTag>").toString();
        String queryAsText = ((Elem)XML$.MODULE$.loadString(queryAsHtml)).text();
        long x$1 = ((QueryId)latestQuery.id()).underlying();
        String x$2 = latestQuery.queryName();
        String x$3 = node.key();
        String x$4 = node.name();
        String x$52 = researcher.userName();
        String x$62 = researcher.userDomainName();
        long x$72 = latestQuery.versionInfo().createDate();
        QueryStatus x$82 = latestQuery.status();
        Query query = latestQuery;
        if (query instanceof QueryError) {
            QueryError queryError = (QueryError)query;
            string2 = queryError.problemDigest().codec();
        } else {
            string2 = "";
        }
        String x$9 = string2;
        Query query2 = latestQuery;
        if (query2 instanceof QueryError) {
            QueryError queryError = (QueryError)query2;
            string = queryError.problemDigest().summary();
        } else {
            string = "";
        }
        String x$10 = string;
        int x$11 = countResults.size();
        int x$12 = errorResults.size();
        int x$13 = sitesPending;
        int x$14 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)countResults.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.count()))).filterNot((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 == -1)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Map x$15 = queryStatesToTimeInState;
        Query x$16 = latestQuery;
        Seq x$17 = (Seq)queryTerms.map((Function1 & Serializable)x$8 -> x$8.displayName());
        String x$18 = queryAsText;
        return new QueryRow(x$1, x$2, x$3, x$4, x$52, x$62, x$72, x$82, x$11, x$14, x$12, x$13, x$9, x$10, (Map<QueryStatus, Object>)x$15, x$16, (Seq<String>)x$17, x$18);
    }

    public QueryRow apply(long id, String queryName, String originShortName, String originName, String researcherUserName, String researcherDomainName, long createDate, QueryStatus status, int sitesThatReturnedCounts, int totalCount, int sitesThatErrored, int sitesPending, String errorCodec, String errorSummary, Map<QueryStatus, Object> queryStatesToTimeInState, Query query, Seq<String> queryTerms, String queryAsText) {
        return new QueryRow(id, queryName, originShortName, originName, researcherUserName, researcherDomainName, createDate, status, sitesThatReturnedCounts, totalCount, sitesThatErrored, sitesPending, errorCodec, errorSummary, queryStatesToTimeInState, query, queryTerms, queryAsText);
    }

    public Option<Tuple18<QueryId, String, NodeKey, NodeName, UserName, UserDomainName, DateStamp, QueryStatus, Object, Object, Object, Object, String, String, Map<QueryStatus, Object>, Query, Seq<String>, String>> unapply(QueryRow x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple18((Object)new QueryId(x$0.id()), (Object)x$0.queryName(), (Object)new NodeKey(x$0.originShortName()), (Object)new NodeName(x$0.originName()), (Object)new UserName(x$0.researcherUserName()), (Object)new UserDomainName(x$0.researcherDomainName()), (Object)new DateStamp(x$0.createDate()), (Object)x$0.status(), (Object)BoxesRunTime.boxToInteger((int)x$0.sitesThatReturnedCounts()), (Object)BoxesRunTime.boxToInteger((int)x$0.totalCount()), (Object)BoxesRunTime.boxToInteger((int)x$0.sitesThatErrored()), (Object)BoxesRunTime.boxToInteger((int)x$0.sitesPending()), (Object)x$0.errorCodec(), (Object)x$0.errorSummary(), x$0.queryStatesToTimeInState(), (Object)x$0.query(), x$0.queryTerms(), (Object)x$0.queryAsText()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueryRow$.class);
    }

    public static final /* synthetic */ boolean $anonfun$statusOrder$1(QueryStatus elem) {
        return MODULE$.ignoreStatuses().contains((Object)elem);
    }

    public static final /* synthetic */ long $anonfun$apply$2(Tuple2 x$5) {
        return ((DateStamp)x$5._2()).underlying();
    }

    private QueryRow$() {
    }
}

