/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Functor;
import cats.effect.Clock;
import cats.effect.Clock$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import org.http4s.HttpDate;
import org.http4s.ParseFailure;
import org.http4s.ParseResult$;
import org.http4s.parser.AdditionalRules$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class HttpDate$ {
    public static final HttpDate$ MODULE$ = new HttpDate$();
    private static final long MinEpochSecond = -2208988800L;
    private static final long MaxEpochSecond = 253402300799L;
    private static final HttpDate MinValue = MODULE$.unsafeFromEpochSecond(MODULE$.MinEpochSecond());
    private static final HttpDate MaxValue = MODULE$.unsafeFromEpochSecond(MODULE$.MaxEpochSecond());
    private static final HttpDate Epoch = MODULE$.unsafeFromEpochSecond(0L);

    private long MinEpochSecond() {
        return MinEpochSecond;
    }

    private long MaxEpochSecond() {
        return MaxEpochSecond;
    }

    public HttpDate MinValue() {
        return MinValue;
    }

    public HttpDate MaxValue() {
        return MaxValue;
    }

    public HttpDate now() {
        return this.unsafeFromInstant(Instant.now());
    }

    public <F> F current(Functor<F> evidence$1, Clock<F> evidence$2) {
        return (F)package.all$.MODULE$.toFunctorOps(Clock$.MODULE$.apply(evidence$2).realTime(TimeUnit.SECONDS), evidence$1).map((Function1 & Serializable)epochSecond -> HttpDate$.MODULE$.unsafeFromEpochSecond(BoxesRunTime.unboxToLong((Object)epochSecond)));
    }

    public HttpDate Epoch() {
        return Epoch;
    }

    public Either<ParseFailure, HttpDate> fromString(String s2) {
        return AdditionalRules$.MODULE$.httpDate(s2);
    }

    public HttpDate unsafeFromString(String s2) {
        return (HttpDate)this.fromString(s2).fold((Function1 & Serializable)x$1 -> {
            throw x$1;
        }, (Function1 & Serializable)x -> (HttpDate)Predef$.MODULE$.identity(x));
    }

    public Either<ParseFailure, HttpDate> fromEpochSecond(long epochSecond) {
        return epochSecond < this.MinEpochSecond() || epochSecond > this.MaxEpochSecond() ? ParseResult$.MODULE$.fail("Invalid HTTP date", new StringBuilder(61).append(epochSecond).append(" out of range for HTTP date. Must be between ").append(this.MinEpochSecond()).append(" and ").append(this.MaxEpochSecond()).append(", inclusive").toString()) : ParseResult$.MODULE$.success(new HttpDate(epochSecond));
    }

    public HttpDate unsafeFromEpochSecond(long epochSecond) {
        return (HttpDate)this.fromEpochSecond(epochSecond).fold((Function1 & Serializable)x$2 -> {
            throw x$2;
        }, (Function1 & Serializable)x -> (HttpDate)Predef$.MODULE$.identity(x));
    }

    public Either<ParseFailure, HttpDate> fromInstant(Instant instant) {
        return this.fromEpochSecond(instant.toEpochMilli() / 1000L);
    }

    public HttpDate unsafeFromInstant(Instant instant) {
        return this.unsafeFromEpochSecond(instant.toEpochMilli() / 1000L);
    }

    public Either<ParseFailure, HttpDate> fromZonedDateTime(ZonedDateTime dateTime) {
        return this.fromInstant(dateTime.toInstant());
    }

    public HttpDate unsafeFromZonedDateTime(ZonedDateTime dateTime) {
        return this.unsafeFromInstant(dateTime.toInstant());
    }

    private HttpDate$() {
    }
}

