/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.api.ontology;

import cats.Applicative;
import cats.Apply;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.implicits$;
import ch.qos.logback.classic.Logger;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import net.shrine.api.ontology.CODE_CATEGORY;
import net.shrine.api.ontology.CODE_SET;
import net.shrine.api.ontology.CaseInsensitiveSort$;
import net.shrine.api.ontology.CodeCategory;
import net.shrine.api.ontology.CodeCategoryTerm;
import net.shrine.api.ontology.CodeCategoryTerm$;
import net.shrine.api.ontology.ConceptInfo;
import net.shrine.api.ontology.ConceptInfo$;
import net.shrine.api.ontology.ConceptType;
import net.shrine.api.ontology.FilterData;
import net.shrine.api.ontology.FilterOption;
import net.shrine.api.ontology.FilterType;
import net.shrine.api.ontology.FilterableType;
import net.shrine.api.ontology.HtmlHighlighter$;
import net.shrine.api.ontology.LuceneSearcher;
import net.shrine.api.ontology.NO_FILTER;
import net.shrine.api.ontology.OntologyPath;
import net.shrine.api.ontology.OntologyTerm;
import net.shrine.api.ontology.SearchQuery;
import net.shrine.api.ontology.SearchResults;
import net.shrine.api.ontology.SearchResultsMetadata;
import net.shrine.api.ontology.Trie;
import net.shrine.api.ontology.TrieNode;
import net.shrine.api.ontology.VisualAttributes;
import net.shrine.api.ontology.VisualAttributes$;
import net.shrine.config.ConfigSource$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.log.Loggable;
import net.shrine.ontology.LabDetail;
import net.shrine.problem.RawProblem;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.http4s.EntityDecoder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapView;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import shapeless.;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.lazily$;
import shapeless.ops.hlist;

public final class LuceneSearcher$
implements Loggable {
    public static final LuceneSearcher$ MODULE$ = new LuceneSearcher$();
    private static String indexFileLocation;
    private static File indexDir;
    private static FSDirectory directory;
    private static IndexSearcher searcher;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile byte bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    private String indexFileLocation$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                indexFileLocation = ConfigSource$.MODULE$.config().getString("shrine.lucene.directory");
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return indexFileLocation;
    }

    private String indexFileLocation() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.indexFileLocation$lzycompute();
        }
        return indexFileLocation;
    }

    private File indexDir$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                indexDir = new File(this.indexFileLocation());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return indexDir;
    }

    private File indexDir() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.indexDir$lzycompute();
        }
        return indexDir;
    }

    private FSDirectory directory$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                directory = FSDirectory.open((Path)this.indexDir().toPath());
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return directory;
    }

    private FSDirectory directory() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.directory$lzycompute();
        }
        return directory;
    }

    private IndexSearcher searcher$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.directory()));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return searcher;
    }

    public IndexSearcher searcher() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.searcher$lzycompute();
        }
        return searcher;
    }

    private CodeCategoryTerm createCodeCategoryTerm(String displayName, List<OntologyTerm> children) {
        String x$1 = displayName;
        List<OntologyTerm> x$2 = children;
        ConceptType x$3 = CodeCategoryTerm$.MODULE$.apply$default$2();
        boolean x$4 = CodeCategoryTerm$.MODULE$.apply$default$3();
        return new CodeCategoryTerm(x$1, x$3, x$4, x$2);
    }

    public IO<List<CodeCategoryTerm>> getRootTerms() {
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1 & Serializable)foundDocs -> {
            Map docsToCodeCategories = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs), (Function1 & Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"));
            SortedMap sortedDocsToCategories = (SortedMap)SortedMap$.MODULE$.apply((Seq)docsToCodeCategories.toSeq().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$), (Ordering)Ordering.String$.MODULE$);
            Iterable codeCategoryTerms = (Iterable)sortedDocsToCategories.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String codeCategory = (String)tuple2._1();
                    ScoreDoc[] scoreDocs = (ScoreDoc[])tuple2._2();
                    if (codeCategory != null) {
                        String string = codeCategory;
                        if (scoreDocs != null) {
                            ScoreDoc[] scoreDocArray = scoreDocs;
                            List ontologyTermsList = Predef$.MODULE$.wrapRefArray((Object[])scoreDocArray).toList().map((Function1 & Serializable)sd -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)sd, MODULE$.extractOntologyTermFromScoreDoc$default$2()));
                            return MODULE$.createCodeCategoryTerm(string, (List<OntologyTerm>)ontologyTermsList);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return codeCategoryTerms.toList();
        });
    }

    public IO<Option<OntologyTerm>> getSingleTermByPathAndDisplayName(String path, String displayName) {
        BooleanQuery pathAndNameQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("path", path)), BooleanClause.Occur.MUST).build();
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults((Query)pathAndNameQuery);
        return scoreDocsIO.map((Function1 & Serializable)sds -> {
            if (sds.size() > 1) {
                MODULE$.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("displayName and path should be unique to an ontology term. ").append("For path (").append(path).append(") and displayName (").append(displayName).append(") found ").append(sds.size()).append(" results").toString());
                Option displayNameOrisRootMatch = sds.find((Function1 & Serializable)scoreDoc -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getSingleTermByPathAndDisplayName$3(displayName, scoreDoc)));
                return (Option)displayNameOrisRootMatch.fold((Function0 & Serializable)() -> sds.headOption().map((Function1 & Serializable)x$2 -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)x$2, MODULE$.extractOntologyTermFromScoreDoc$default$2())), (Function1 & Serializable)x$3 -> displayNameOrisRootMatch.map((Function1 & Serializable)x$4 -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)x$4, MODULE$.extractOntologyTermFromScoreDoc$default$2())));
            }
            return sds.headOption().map((Function1 & Serializable)x$5 -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)x$5, MODULE$.extractOntologyTermFromScoreDoc$default$2()));
        });
    }

    public IO<List<FilterOption>> getFilterOptions() {
        FilterOption defaultOption = new FilterOption(new NO_FILTER(), "All Concepts", "All Concepts");
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1 & Serializable)foundDocs -> {
            String[] allCodeCategories = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs), (Function1 & Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"), ClassTag$.MODULE$.apply(String.class))));
            List codeCategoryOptions = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])allCodeCategories), (Function1 & Serializable)codeCategory -> {
                String string;
                block6: {
                    String string2 = codeCategory;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -1893092320: {
                            if (!"Procedures".equals(string2)) break;
                            string = "Procedures (All)";
                            break block6;
                        }
                        case -1094006187: {
                            if (!"Diagnoses".equals(string2)) break;
                            string = "Diagnoses (All)";
                            break block6;
                        }
                        case -788711580: {
                            if (!"Medications".equals(string2)) break;
                            string = "Medications (RxNORM)";
                            break block6;
                        }
                        case 912348020: {
                            if (!"Laboratory Tests".equals(string2)) break;
                            string = "Laboratory Tests (LOINC)";
                            break block6;
                        }
                    }
                    string = string2;
                }
                String displayableName = string;
                return new FilterOption(new CODE_CATEGORY(), (String)codeCategory, displayableName);
            }, ClassTag$.MODULE$.apply(FilterOption.class))).toList();
            MapView codeSetMap = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs), (Function1 & Serializable)sd -> new Tuple2((Object)MODULE$.searcher().doc(sd.doc).get("codeCategory"), (Object)MODULE$.searcher().doc(sd.doc).get("codeSet")), ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getFilterOptions$5(c)))), (Function1 & Serializable)x$6 -> (String)x$6._1()).view().mapValues((Function1 & Serializable)arrayOfCodeCategoriesAndCodeSet -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])arrayOfCodeCategoriesAndCodeSet), (Function1 & Serializable)codeCategoryAndCodeSet -> new FilterOption(new CODE_SET(), (String)codeCategoryAndCodeSet._2(), (String)codeCategoryAndCodeSet._2()), ClassTag$.MODULE$.apply(FilterOption.class))).toList());
            List codeSetAndCategoryOptions = ((ListBuffer)codeCategoryOptions.foldLeft(ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(acc, cur) -> {
                acc.$plus$eq(cur);
                Object object = codeSetMap.contains((Object)cur.filterValue()) ? acc.$plus$plus$eq((IterableOnce)codeSetMap.apply((Object)cur.filterValue())) : BoxedUnit.UNIT;
                return acc;
            })).toList();
            List allOptions = (List)codeSetAndCategoryOptions.$plus$colon((Object)defaultOption);
            return allOptions;
        });
    }

    public IO<Map<OntologyPath, CodeCategory>> getCodeCategoriesMap() {
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1 & Serializable)foundDocs -> {
            Tuple2[] pathToCodeCategory = (Tuple2[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs), (Function1 & Serializable)sd -> {
                String codeCategory = MODULE$.searcher().doc(sd.doc).get("codeCategory");
                String path = MODULE$.searcher().doc(sd.doc).get("path");
                return new Tuple2((Object)new OntologyPath(path), (Object)new CodeCategory(codeCategory));
            }, ClassTag$.MODULE$.apply(Tuple2.class))));
            return Predef$.MODULE$.wrapRefArray((Object[])pathToCodeCategory).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        });
    }

    public IO<List<ScoreDoc>> getRawSearchResults(Query query) {
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable)() -> {
            int maxHits = Integer.MAX_VALUE;
            TopFieldDocs foundDocs = MODULE$.searcher().search(query, maxHits, CaseInsensitiveSort$.MODULE$.apply("displayName"));
            return Predef$.MODULE$.wrapRefArray((Object[])foundDocs.scoreDocs).toList();
        }));
    }

    public IO<List<OntologyTerm>> getChildren(OntologyPath ontologyPath) {
        String parentPath = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(ontologyPath.path()), 1);
        TermQuery childrenQuery = new TermQuery(new Term("parentPath", parentPath));
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults((Query)childrenQuery);
        return scoreDocsIO.map((Function1 & Serializable)scoreDocs -> {
            List searchHits = scoreDocs.map((Function1 & Serializable)sd -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)sd, MODULE$.extractOntologyTermFromScoreDoc$default$2()));
            return searchHits;
        });
    }

    public IO<Option<ConceptInfo>> getConceptInfo(OntologyPath ontologyPath) {
        TermQuery pathQuery = new TermQuery(new Term("path", ontologyPath.path()));
        TermQuery childrenQuery = new TermQuery(new Term("parentPath", StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(ontologyPath.path()), 1)));
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)pathQuery, BooleanClause.Occur.SHOULD).add((Query)childrenQuery, BooleanClause.Occur.SHOULD).build();
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults((Query)booleanQuery);
        return scoreDocsIO.map((Function1 & Serializable)scoreDocs -> {
            List childConcepts = scoreDocs.filter((Function1 & Serializable)sd -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$2(ontologyPath, sd))).map((Function1 & Serializable)x$7 -> ConceptInfo$.MODULE$.apply((ScoreDoc)x$7, ConceptInfo$.MODULE$.apply$default$2(), ConceptInfo$.MODULE$.apply$default$3()));
            Option scoreDocOption = scoreDocs.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$4(ontologyPath, p)));
            Option conceptInfoTerm = scoreDocOption.map((Function1 & Serializable)scoreDoc -> {
                ConceptInfo conceptInfo;
                block3: {
                    Tuple3 tuple3;
                    block2: {
                        ConceptInfo conceptInfo2;
                        String nPath = MODULE$.searcher().doc(scoreDoc.doc).get("nPath");
                        String visAttrPath = new StringBuilder(3).append("\\CA").append(MODULE$.searcher().doc(scoreDoc.doc).get("visPath")).toString();
                        String[] pathElements = (String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])nPath.split("\\\\")), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$6(x$8)));
                        String[] pathElementsReverse = (String[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements));
                        String[] visPathElementsReverse = (String[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])visAttrPath.split("\\\\")), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$7(x$9)))));
                        ConceptInfo selectedConceptInfo = ConceptInfo$.MODULE$.apply(nPath, (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])pathElementsReverse)), VisualAttributes$.MODULE$.apply((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])visPathElementsReverse))), (Option<List<ConceptInfo>>)Option$.MODULE$.apply((Object)childConcepts), true);
                        tuple3 = (Tuple3)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])pathElementsReverse), 1)), (Object)new Tuple3((Object)selectedConceptInfo, ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])visPathElementsReverse), 1), ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements), 1)), (Function2 & Serializable)(items, pathElem) -> {
                            String[] visPaths = (String[])items._2();
                            String[] nPaths = (String[])items._3();
                            String path = new StringBuilder(2).append("\\").append(Predef$.MODULE$.wrapRefArray((Object[])nPaths).mkString("\\")).append("\\").toString();
                            .colon.colon childConcepts = new .colon.colon((Object)((ConceptInfo)items._1()), (List)Nil$.MODULE$);
                            ConceptInfo conceptInfo = ConceptInfo$.MODULE$.apply(path, (String)pathElem, VisualAttributes$.MODULE$.apply((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])visPaths))), (Option<List<ConceptInfo>>)Option$.MODULE$.apply((Object)childConcepts), false);
                            return new Tuple3((Object)conceptInfo, ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])visPaths), 1), ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])nPaths), 1));
                        });
                        if (tuple3 == null || (conceptInfo2 = (ConceptInfo)tuple3._1()) == null) break block2;
                        conceptInfo = conceptInfo2;
                        if (tuple3._2() != null) break block3;
                    }
                    throw new MatchError((Object)tuple3);
                }
                ConceptInfo conceptInfo3 = conceptInfo;
                return conceptInfo3;
            });
            return conceptInfoTerm;
        });
    }

    public OntologyTerm extractOntologyTermFromScoreDoc(ScoreDoc sd, Option<List<ScoreDoc>> childrenScoreDocs) {
        String path = this.searcher().doc(sd.doc).get("path");
        String displayName = this.searcher().doc(sd.doc).get("displayName");
        Option labFieldOption = Option$.MODULE$.apply((Object)this.searcher().doc(sd.doc).getField("labDetail"));
        boolean isLab = BoxesRunTime.unboxToBoolean((Object)labFieldOption.fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$extractOntologyTermFromScoreDoc$2(x$10))));
        String visualAttributes = this.searcher().doc(sd.doc).get("visualAttributes");
        String conceptCategory = this.searcher().doc(sd.doc).get("conceptCategory");
        Option metadata = Option$.MODULE$.apply((Object)this.searcher().doc(sd.doc).get("tooltip"));
        return this.extractOntologyTerm(path, displayName, visualAttributes, conceptCategory, isLab, (Option<String>)metadata, childrenScoreDocs, this.extractOntologyTerm$default$8());
    }

    public OntologyTerm extractOntologyTerm(String path, String displayName, String visualAttr, String conceptCategory, boolean isLab, Option<String> metadata, Option<List<ScoreDoc>> childrenScoreDocs, Option<String> highlightedName) {
        VisualAttributes<ConceptType> visualAttributes = VisualAttributes$.MODULE$.apply(visualAttr);
        List childrenOntologyTerms = (List)childrenScoreDocs.fold((Function0 & Serializable)() -> Nil$.MODULE$, (Function1 & Serializable)csd -> csd.map((Function1 & Serializable)doc -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)doc, MODULE$.extractOntologyTermFromScoreDoc$default$2())));
        String x$1 = displayName;
        Option<String> x$2 = highlightedName;
        String x$3 = path;
        String x$4 = conceptCategory;
        ConceptType x$5 = visualAttributes.conceptType();
        boolean x$6 = visualAttributes.isActive();
        Option<String> x$7 = metadata;
        Option x$8 = Option$.MODULE$.apply((Object)childrenOntologyTerms);
        boolean x$9 = isLab;
        OntologyTerm ontTerm = new OntologyTerm(x$1, x$2, x$3, x$4, x$5, x$6, x$9, x$7, (Option<List<OntologyTerm>>)x$8);
        return ontTerm;
    }

    public Option<List<ScoreDoc>> extractOntologyTermFromScoreDoc$default$2() {
        return None$.MODULE$;
    }

    public Option<List<ScoreDoc>> extractOntologyTerm$default$7() {
        return None$.MODULE$;
    }

    public Option<String> extractOntologyTerm$default$8() {
        return None$.MODULE$;
    }

    public IO<SearchResults> searchIO(SearchQuery searchQuery) {
        String sortTerm = "nPath";
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable)() -> {
            QueryParser displayNameQueryParser = new QueryParser("displayName", (Analyzer)new StandardAnalyzer());
            displayNameQueryParser.setDefaultOperator(QueryParser.Operator.AND);
            String escapedSearchString = searchQuery.searchString().matches(".*\\s+$") ? QueryParserBase.escape((String)searchQuery.searchString().trim()) : new StringBuilder(1).append(QueryParserBase.escape((String)searchQuery.searchString())).append("*").toString();
            Query displayNameQuery = displayNameQueryParser.parse(escapedSearchString);
            TermQuery basecodeQuery = new TermQuery(new Term("basecode", searchQuery.searchString()));
            BooleanQuery displayNameAndBasecodeQuery = new BooleanQuery.Builder().add(displayNameQuery, BooleanClause.Occur.SHOULD).add((Query)basecodeQuery, BooleanClause.Occur.SHOULD).setMinimumNumberShouldMatch(1).build();
            Query filteredQuery = LuceneSearcher$.makeFilteredQuery$1((Query)displayNameAndBasecodeQuery, searchQuery.filterData());
            int maxResults = ConfigSource$.MODULE$.config().getInt("shrine.lucene.maxSearchResults");
            Sort sort = CaseInsensitiveSort$.MODULE$.apply(sortTerm);
            Option<SearchResultsMetadata> previousSearchMetadataOption = searchQuery.previousSearchMetadata();
            TopFieldDocs foundDocs = (TopFieldDocs)previousSearchMetadataOption.fold((Function0 & Serializable)() -> MODULE$.searcher().search(filteredQuery, maxResults, sort), (Function1 & Serializable)searchMetadata -> {
                BytesRef field = new BytesRef((CharSequence)searchMetadata.sortFieldValue());
                Object[] fields = new Object[]{field};
                FieldDoc lastScoreDoc = new FieldDoc(searchMetadata.lastDocId(), Float.NaN, fields);
                return MODULE$.searcher().searchAfter((ScoreDoc)lastScoreDoc, filteredQuery, maxResults, sort, false);
            });
            Highlighter highlighter = HtmlHighlighter$.MODULE$.createHighlighter(filteredQuery);
            return new Tuple2((Object)foundDocs, (Object)highlighter);
        }).flatMap((Function1 & Serializable)params -> {
            TopFieldDocs topFieldDocs;
            Highlighter highlighter;
            block6: {
                Tuple2 tuple2;
                block5: {
                    tuple2 = params;
                    if (tuple2 == null) break block5;
                    TopFieldDocs allDocs = (TopFieldDocs)tuple2._1();
                    highlighter = (Highlighter)tuple2._2();
                    if (allDocs == null) break block5;
                    topFieldDocs = allDocs;
                    if (highlighter != null) break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            Highlighter highlighter2 = highlighter;
            Tuple2 tuple2 = new Tuple2((Object)topFieldDocs, (Object)highlighter2);
            TopFieldDocs allDocs = (TopFieldDocs)tuple2._1();
            Highlighter highlighter3 = (Highlighter)tuple2._2();
            ScoreDoc[] scoreDocs = allDocs.scoreDocs;
            TotalHits totalHits = allDocs.totalHits;
            Map codeCategoriesToDocsWithNulls = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])scoreDocs), (Function1 & Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"));
            Tuple2 tuple22 = codeCategoriesToDocsWithNulls.partition((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$searchIO$6(x$12)));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Map codeCategoriesToDocs = (Map)tuple22._1();
            Map nullsToDocs = (Map)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)codeCategoriesToDocs, (Object)nullsToDocs);
            Map codeCategoriesToDocs2 = (Map)tuple23._1();
            Map nullsToDocs2 = (Map)tuple23._2();
            if (nullsToDocs2.nonEmpty()) {
                MODULE$.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Some docs have null code categories: ").append(Predef$.MODULE$.wrapRefArray((Object[])nullsToDocs2.apply(null)).mkString(", ")).toString());
            }
            SortedMap sortedDocsToCategories = (SortedMap)SortedMap$.MODULE$.apply(codeCategoriesToDocs2.iterator().toSeq(), (Ordering)Ordering.String$.MODULE$);
            Iterable codeCategoryTerms = (Iterable)sortedDocsToCategories.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String codeCategory = (String)tuple2._1();
                    ScoreDoc[] scoreDocs = (ScoreDoc[])tuple2._2();
                    if (codeCategory != null) {
                        String string = codeCategory;
                        if (scoreDocs != null) {
                            ScoreDoc[] scoreDocArray = scoreDocs;
                            Trie trie = new Trie(highlighter3);
                            ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])scoreDocArray), (Function1 & Serializable)sd -> {
                                trie.insert(sd);
                                return BoxedUnit.UNIT;
                            }, (ClassTag)ClassTag$.MODULE$.Unit());
                            IO ontTermsIO = IO$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.buildOntologyTerms(trie.root(), MODULE$.buildOntologyTerms$default$2()));
                            return ontTermsIO.flatMap((Function1 & Serializable)ontTermsList -> IO$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.createCodeCategoryTerm(string, (List<OntologyTerm>)ontTermsList)));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            IO codeCategoryIO = (IO)implicits$.MODULE$.toTraverseOps((Object)codeCategoryTerms.toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.ioEffect());
            return codeCategoryIO.flatMap((Function1 & Serializable)terms -> {
                Option lastScoreDocOption = ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.refArrayOps((Object[])scoreDocs));
                Option searchResultsMetadataOption = lastScoreDocOption.map((Function1 & Serializable)lastScoreDoc -> new SearchResultsMetadata(lastScoreDoc.doc, MODULE$.searcher().doc(lastScoreDoc.doc).get(sortTerm)));
                return IO$.MODULE$.apply((Function0 & Serializable)() -> new SearchResults(totalHits$1.value, (Option<SearchResultsMetadata>)searchResultsMetadataOption, (List<CodeCategoryTerm>)terms));
            });
        }));
    }

    public List<OntologyTerm> buildOntologyTerms(TrieNode node, String path) {
        Iterable ontTermResults = (Iterable)node.children().map((Function1 & Serializable)childItem -> {
            String childKey = (String)childItem._1();
            TrieNode child = (TrieNode)node.children().apply((Object)childKey);
            String currentPath = new StringBuilder(1).append(path).append(childKey).append("\\").toString();
            Option<OntologyTerm> ontTermOption = child.ontTerm();
            List<OntologyTerm> childOntTerms = MODULE$.buildOntologyTerms(child, String.valueOf(currentPath));
            return ((OntologyTerm)ontTermOption.get()).updateChildren((Option<List<OntologyTerm>>)new Some(childOntTerms));
        });
        return ontTermResults.toList();
    }

    public String buildOntologyTerms$default$2() {
        return "";
    }

    public IO<Option<LabDetail>> getLabDetailsIO(OntologyPath ontologyPath) {
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable)() -> {
            TermQuery nPathQuery = new TermQuery(new Term("path", ontologyPath.path()));
            TopDocs foundDocs = MODULE$.searcher().search((Query)nPathQuery, 1);
            Option res = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).flatMap((Function1 & Serializable)scoreDoc -> MODULE$.extractLabDetail((ScoreDoc)scoreDoc));
            return res;
        }));
    }

    private Option<LabDetail> extractLabDetail(ScoreDoc scoreDoc) {
        Option labFieldOption = Option$.MODULE$.apply((Object)this.searcher().doc(scoreDoc.doc).getField("labDetail"));
        public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1
        implements Serializable {
            private DerivedDecoder<LabDetail> inst$macro$1;
            private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$10;
            private volatile byte bitmap$0;

            private DerivedDecoder<LabDetail> inst$macro$1$lzycompute() {
                Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1
                        implements Generic<LabDetail> {
                            public .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> to(LabDetail p) {
                                LabDetail labDetail = p;
                                if (labDetail != null) {
                                    Option pat$macro$6 = labDetail.flagValues();
                                    Option pat$macro$7 = labDetail.units();
                                    Option pat$macro$8 = labDetail.enumValues();
                                    return new .colon.colon((Object)pat$macro$6, (HList)new .colon.colon((Object)pat$macro$7, (HList)new .colon.colon((Object)pat$macro$8, (HList)HNil$.MODULE$)));
                                }
                                throw new MatchError((Object)labDetail);
                            }

                            public LabDetail from(.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> p) {
                                .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> colon2 = p;
                                if (colon2 != null) {
                                    Option pat$macro$6 = (Option)colon2.head();
                                    .colon.colon colon3 = (.colon.colon)colon2.tail();
                                    if (colon3 != null) {
                                        Option pat$macro$7 = (Option)colon3.head();
                                        .colon.colon colon4 = (.colon.colon)colon3.tail();
                                        if (colon4 != null) {
                                            Option pat$macro$8 = (Option)colon4.head();
                                            HNil hNil = (HNil)colon4.tail();
                                            if (HNil$.MODULE$.equals(hNil)) {
                                                return new LabDetail(pat$macro$6, pat$macro$7, pat$macro$8);
                                            }
                                        }
                                    }
                                }
                                throw new MatchError(colon2);
                            }

                            public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1(Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 $outer) {
                            }
                        }
                        this.inst$macro$1 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<LabDetail>(null){

                            public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>> apply() {
                                return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "flagValues"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "units"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "enumValues"), (HList)HNil$.MODULE$)));
                            }
                        }, (Generic)new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "enumValues"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "units"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "flagValues"))), (.less.colon.less)$less$colon$less$.MODULE$.refl()), Lazy$.MODULE$.apply((Function0 & Serializable)() -> this.inst$macro$10()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$1;
            }

            public DerivedDecoder<LabDetail> inst$macro$1() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.inst$macro$1$lzycompute();
                }
                return this.inst$macro$1;
            }

            private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$10$lzycompute() {
                Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.inst$macro$10 = new ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>>(null){
                            private final Decoder<Option<Seq<String>>> circeGenericDecoderForunits;
                            private final Decoder<Option<List<String>>> circeGenericDecoderForenumValues;
                            private volatile byte bitmap$init$0;

                            public final Either<DecodingFailure, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> apply(HCursor c) {
                                return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecode(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                            }

                            public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> decodeAccumulating(HCursor c) {
                                return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecodeAccumulating(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                            }
                            {
                                this.circeGenericDecoderForunits = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                this.circeGenericDecoderForenumValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$10;
            }

            public ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$10() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.inst$macro$10$lzycompute();
                }
                return this.inst$macro$10;
            }

            public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(net.shrine.api.ontology.LuceneSearcher$anon$importedDecoder$macro$11$1 )}, serializedLambda);
            }
        }
        DerivedDecoder<LabDetail> inst$macro$12 = new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1().inst$macro$1();
        EntityDecoder labDetailDecoder = org.http4s.circe.package$.MODULE$.jsonOf((Sync)IO$.MODULE$.ioEffect(), Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply((Function0 & Serializable)() -> inst$macro$12))));
        Option ontTerm = labFieldOption.flatMap((Function1 & Serializable)labField -> {
            DerivedDecoder<LabDetail> inst$macro$24;
            String labDetailJson = labField.stringValue();
            public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1
            implements Serializable {
                private DerivedDecoder<LabDetail> inst$macro$13;
                private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$22;
                private volatile byte bitmap$0;

                private DerivedDecoder<LabDetail> inst$macro$13$lzycompute() {
                    Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 1) == 0) {
                            public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1
                            implements Generic<LabDetail> {
                                public .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> to(LabDetail p) {
                                    LabDetail labDetail = p;
                                    if (labDetail != null) {
                                        Option pat$macro$18 = labDetail.flagValues();
                                        Option pat$macro$19 = labDetail.units();
                                        Option pat$macro$20 = labDetail.enumValues();
                                        return new .colon.colon((Object)pat$macro$18, (HList)new .colon.colon((Object)pat$macro$19, (HList)new .colon.colon((Object)pat$macro$20, (HList)HNil$.MODULE$)));
                                    }
                                    throw new MatchError((Object)labDetail);
                                }

                                public LabDetail from(.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> p) {
                                    .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> colon2 = p;
                                    if (colon2 != null) {
                                        Option pat$macro$18 = (Option)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 != null) {
                                            Option pat$macro$19 = (Option)colon3.head();
                                            .colon.colon colon4 = (.colon.colon)colon3.tail();
                                            if (colon4 != null) {
                                                Option pat$macro$20 = (Option)colon4.head();
                                                HNil hNil = (HNil)colon4.tail();
                                                if (HNil$.MODULE$.equals(hNil)) {
                                                    return new LabDetail(pat$macro$18, pat$macro$19, pat$macro$20);
                                                }
                                            }
                                        }
                                    }
                                    throw new MatchError(colon2);
                                }

                                public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1(Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 $outer) {
                                }
                            }
                            this.inst$macro$13 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<LabDetail>(null){

                                public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>> apply() {
                                    return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "flagValues"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "units"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "enumValues"), (HList)HNil$.MODULE$)));
                                }
                            }, (Generic)new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "enumValues"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "units"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "flagValues"))), (.less.colon.less)$less$colon$less$.MODULE$.refl()), Lazy$.MODULE$.apply((Function0 & Serializable)() -> this.inst$macro$22()));
                            this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                        }
                    }
                    return this.inst$macro$13;
                }

                public DerivedDecoder<LabDetail> inst$macro$13() {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        return this.inst$macro$13$lzycompute();
                    }
                    return this.inst$macro$13;
                }

                private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$22$lzycompute() {
                    Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 2) == 0) {
                            this.inst$macro$22 = new ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>>(null){
                                private final Decoder<Option<Seq<String>>> circeGenericDecoderForunits;
                                private final Decoder<Option<List<String>>> circeGenericDecoderForenumValues;
                                private volatile byte bitmap$init$0;

                                public final Either<DecodingFailure, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> apply(HCursor c) {
                                    return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecode(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                                }

                                public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> decodeAccumulating(HCursor c) {
                                    return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecodeAccumulating(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                                }
                                {
                                    this.circeGenericDecoderForunits = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                    this.circeGenericDecoderForenumValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                                }
                            };
                            this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                        }
                    }
                    return this.inst$macro$22;
                }

                public ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$22() {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        return this.inst$macro$22$lzycompute();
                    }
                    return this.inst$macro$22;
                }

                public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1() {
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$13$1(net.shrine.api.ontology.LuceneSearcher$anon$importedDecoder$macro$23$1 )}, serializedLambda);
                }
            }
            Either either = package$.MODULE$.decode(labDetailJson, Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply(() -> LuceneSearcher$.$anonfun$extractLabDetail$3(inst$macro$24 = new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1().inst$macro$13())))));
            if (either instanceof Right) {
                Right right = (Right)either;
                LabDetail labDetail = (LabDetail)right.value();
                return Option$.MODULE$.apply((Object)labDetail);
            }
            if (either instanceof Left) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        });
        return ontTerm;
    }

    private IO<TopFieldDocs> getRootFieldDocs() {
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable)() -> {
            int maxHits = Integer.MAX_VALUE;
            QueryParser qp = new QueryParser("isRoot", (Analyzer)new StandardAnalyzer());
            Query rootQuery = qp.parse("true");
            return MODULE$.searcher().search(rootQuery, maxHits, CaseInsensitiveSort$.MODULE$.apply("displayName"));
        }));
    }

    public static final /* synthetic */ boolean $anonfun$getSingleTermByPathAndDisplayName$3(String displayName$1, ScoreDoc scoreDoc) {
        String string = MODULE$.searcher().doc(scoreDoc.doc).get("displayName");
        String string2 = displayName$1;
        return !(string == null ? string2 != null : !string.equals(string2)) || StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(MODULE$.searcher().doc(scoreDoc.doc).get("isRoot")));
    }

    public static final /* synthetic */ boolean $anonfun$getFilterOptions$5(Tuple2 c) {
        return c._2() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)c._2()));
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$2(OntologyPath ontologyPath$1, ScoreDoc sd) {
        String string = MODULE$.searcher().doc(sd.doc).get("path");
        String string2 = ontologyPath$1.path();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$4(OntologyPath ontologyPath$1, ScoreDoc p) {
        String string = MODULE$.searcher().doc(p.doc).get("path");
        String string2 = ontologyPath$1.path();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$6(String x$8) {
        String string = x$8;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$7(String x$9) {
        String string = x$9;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractOntologyTermFromScoreDoc$2(IndexableField x$10) {
        return true;
    }

    private static final Query makeFilteredQuery$1(Query baseQuery, FilterData filter) {
        FilterType filterType = filter.filterType();
        if (filterType instanceof FilterableType) {
            FilterableType filterableType = (FilterableType)filterType;
            TermQuery filterQuery = new TermQuery(new Term(filterableType.value(), filter.filterValue()));
            return new BooleanQuery.Builder().add(baseQuery, BooleanClause.Occur.MUST).add((Query)filterQuery, BooleanClause.Occur.MUST).build();
        }
        if (filterType instanceof NO_FILTER) {
            return baseQuery;
        }
        throw new MatchError((Object)filterType);
    }

    public static final /* synthetic */ boolean $anonfun$searchIO$6(Tuple2 x$12) {
        return x$12._1() != null;
    }

    public static final /* synthetic */ DerivedDecoder $anonfun$extractLabDetail$3(DerivedDecoder inst$macro$24$1) {
        return inst$macro$24$1;
    }

    private LuceneSearcher$() {
    }
}

