/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfigLoader;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.impl.uri.PathPattern;
import com.sun.jersey.server.impl.wadl.WadlApplicationContextImpl;
import com.sun.jersey.server.impl.wadl.WadlMethodFactory;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;

public final class WadlFactory {
    private static final Logger LOGGER = Logger.getLogger(WadlFactory.class.getName());
    private final boolean isWadlEnabled;
    private final WadlGenerator wadlGenerator;
    private WadlApplicationContext wadlApplicationContext;

    public WadlFactory(ResourceConfig resourceConfig) {
        this.isWadlEnabled = WadlFactory.isWadlEnabled(resourceConfig);
        this.wadlGenerator = this.isWadlEnabled ? WadlGeneratorConfigLoader.loadWadlGeneratorsFromConfig(resourceConfig) : null;
    }

    public boolean isSupported() {
        return this.isWadlEnabled;
    }

    public WadlApplicationContext createWadlApplicationContext(Set<AbstractResource> rootResources) {
        if (!this.isSupported()) {
            return null;
        }
        return new WadlApplicationContextImpl(rootResources, this.wadlGenerator);
    }

    public void init(InjectableProviderFactory ipf, Set<AbstractResource> rootResources) {
        if (!this.isSupported()) {
            return;
        }
        this.wadlApplicationContext = new WadlApplicationContextImpl(rootResources, this.wadlGenerator);
        ipf.add((InjectableProvider)new SingletonTypeInjectableProvider<Context, WadlApplicationContext>(WadlApplicationContext.class, this.wadlApplicationContext){});
    }

    public ResourceMethod createWadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, PathPattern p) {
        if (!this.isSupported()) {
            return null;
        }
        if (p == null) {
            return new WadlMethodFactory.WadlOptionsMethod(methods, resource, null, this.wadlGenerator, this.wadlApplicationContext);
        }
        String path = p.getTemplate().getTemplate().substring(1);
        return new WadlMethodFactory.WadlOptionsMethod(methods, resource, path, this.wadlGenerator, this.wadlApplicationContext);
    }

    private static boolean isWadlEnabled(ResourceConfig resourceConfig) {
        return !resourceConfig.getFeature("com.sun.jersey.config.feature.DisableWADL");
    }
}

