/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import org.spin.tools.Optional;

public final class Maybe<T> {
    private final T value;
    private final Throwable error;

    private Maybe(T value, Throwable error) {
        this.value = value;
        this.error = error;
    }

    public static <T> Maybe<T> error(Throwable error) {
        return new Maybe<Object>(null, error);
    }

    public static <T> Maybe<T> valid(T value) {
        return new Maybe<T>(value, null);
    }

    public static <T> Maybe<T> empty() {
        return new Maybe<Object>(null, null);
    }

    public Optional<T> getValue() {
        return this.value != null ? Optional.some(this.value) : Optional.none();
    }

    public Optional<Throwable> getError() {
        return this.error != null ? Optional.some(this.error) : Optional.none();
    }

    public boolean isValid() {
        return !this.isError();
    }

    public boolean isError() {
        return this.error != null;
    }

    public String toString() {
        return "Maybe [value=" + this.value + ", error=" + this.error + "]";
    }
}

