/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.spin.tools.TimeException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NetworkTime", propOrder={"calendar"})
@XmlRootElement
public final class NetworkTime {
    @XmlElement(required=true)
    @XmlSchemaType(name="dateTime")
    private final XMLGregorianCalendar calendar;
    private static DatatypeFactory datatypeFactory;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDataTypeFactoryIfNecessary() {
        Object object = lock;
        synchronized (object) {
            if (datatypeFactory == null) {
                try {
                    datatypeFactory = DatatypeFactory.newInstance();
                }
                catch (DatatypeConfigurationException e) {
                    throw new TimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatatypeFactory getDatatypeFactory() {
        Object object = lock;
        synchronized (object) {
            NetworkTime.initDataTypeFactoryIfNecessary();
            return datatypeFactory;
        }
    }

    public NetworkTime() {
        this(new GregorianCalendar());
    }

    public NetworkTime(Date date) {
        this(NetworkTime.makeXMLGregorianCalendar(date));
    }

    public NetworkTime(GregorianCalendar gregorianCalendar) {
        this(NetworkTime.makeXMLGregorianCalendar(gregorianCalendar));
    }

    public NetworkTime(String lexicalRepresentation) {
        this(NetworkTime.makeXMLGregorianCalendar(lexicalRepresentation));
    }

    public NetworkTime(XMLGregorianCalendar calendar) {
        this.calendar = calendar;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkTime other = (NetworkTime)obj;
        return !(this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar));
    }

    public boolean before(NetworkTime other) {
        return this.calendar.compare(other.calendar) == -1;
    }

    public boolean sameTime(NetworkTime other) {
        return this.calendar.compare(other.calendar) == 0;
    }

    public boolean after(NetworkTime other) {
        return this.calendar.compare(other.calendar) == 1;
    }

    public XMLGregorianCalendar getXMLGregorianCalendar() {
        return this.calendar;
    }

    public Calendar toCalendar() {
        return this.calendar.toGregorianCalendar();
    }

    public String toString() {
        return this.calendar.toString();
    }

    public long toMilliSeconds() {
        return this.calendar.toGregorianCalendar().getTimeInMillis();
    }

    public NetworkTime addMilliseconds(long amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration(amount));
        return result;
    }

    public NetworkTime addSeconds(int amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        boolean isPositive = amount > 0;
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, 0, 0, 0, 0, 0, Math.abs(amount)));
        return result;
    }

    public NetworkTime addMinutes(int amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        boolean isPositive = amount > 0;
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, 0, 0, 0, 0, Math.abs(amount), 0));
        return result;
    }

    public NetworkTime addHours(int amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        boolean isPositive = amount > 0;
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, 0, 0, 0, Math.abs(amount), 0, 0));
        return result;
    }

    public NetworkTime addDays(int amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        boolean isPositive = amount > 0;
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, 0, 0, Math.abs(amount), 0, 0, 0));
        return result;
    }

    public NetworkTime addMonths(int amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        boolean isPositive = amount > 0;
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration((isPositive ? "" : "-") + "P0Y0M" + Math.abs(amount) + "DT0H0M"));
        return result;
    }

    public NetworkTime addYears(int amount) {
        NetworkTime result = NetworkTime.copyOf(this);
        boolean isPositive = amount > 0;
        result.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, Math.abs(amount), 0, 0, 0, 0, 0));
        return result;
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(String lexicalRepresentation) {
        return NetworkTime.getDatatypeFactory().newXMLGregorianCalendar(lexicalRepresentation);
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(GregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return NetworkTime.getDatatypeFactory().newXMLGregorianCalendar(calendar);
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return NetworkTime.getDatatypeFactory().newXMLGregorianCalendar(cal);
    }

    public static final Date toDate(XMLGregorianCalendar xmlGC) {
        if (xmlGC == null) {
            return null;
        }
        return xmlGC.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar copyOf(XMLGregorianCalendar xmlGC) {
        if (xmlGC == null) {
            return null;
        }
        return NetworkTime.makeXMLGregorianCalendar(xmlGC.toXMLFormat());
    }

    public static final NetworkTime copyOf(NetworkTime other) {
        if (other == null) {
            return null;
        }
        return new NetworkTime(NetworkTime.copyOf(other.calendar));
    }

    static {
        lock = new Object();
    }
}

