/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.bus.spring.BusApplicationContextResourceResolver;
import org.apache.cxf.bus.spring.SpringBeanLocator;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;

public class SpringBus
extends ExtensionManagerBus
implements ApplicationContextAware,
ApplicationListener {
    AbstractApplicationContext ctx;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = (AbstractApplicationContext)applicationContext;
        this.ctx.addApplicationListener((ApplicationListener)this);
        for (ApplicationContext ac = applicationContext.getParent(); ac != null; ac = ac.getParent()) {
            if (!(ac instanceof AbstractApplicationContext)) continue;
            ((AbstractApplicationContext)ac).addApplicationListener((ApplicationListener)this);
        }
        this.setExtension(new ConfigurerImpl(applicationContext), Configurer.class);
        ResourceManager m = this.getExtension(ResourceManager.class);
        m.addResourceResolver((ResourceResolver)new BusApplicationContextResourceResolver(applicationContext));
        this.setExtension(applicationContext, ApplicationContext.class);
        ConfiguredBeanLocator loc = this.getExtension(ConfiguredBeanLocator.class);
        if (!(loc instanceof SpringBeanLocator)) {
            this.setExtension(new SpringBeanLocator(applicationContext, this), ConfiguredBeanLocator.class);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.ctx == null) {
            return;
        }
        boolean doIt = false;
        for (AbstractApplicationContext ac = this.ctx; ac != null && !doIt; ac = ac.getParent()) {
            if (event.getSource() != ac) continue;
            doIt = true;
            break;
        }
        if (doIt) {
            if (event instanceof ContextRefreshedEvent) {
                this.initialize();
            } else if (event instanceof ContextClosedEvent) {
                this.getExtension(BusLifeCycleManager.class).postShutdown();
            }
        }
    }

    public void destroyBeans() {
        this.ctx.close();
        super.destroyBeans();
    }
}

