/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.node.cache.QueryState;
import org.spin.node.cache.ReadOnlyResultStore;
import org.spin.tools.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CacheInfo")
@XmlRootElement
public final class CacheInfo {
    private final int numEntries;
    private final Map<String, Long> ageOfEntries;

    private CacheInfo() {
        this.numEntries = Integer.MIN_VALUE;
        this.ageOfEntries = null;
    }

    public CacheInfo(ReadOnlyResultStore resultStore) {
        this.numEntries = resultStore.size();
        this.ageOfEntries = Util.makeHashMap();
        this.calculateAgeOfQueryIds(resultStore);
    }

    private final void calculateAgeOfQueryIds(ReadOnlyResultStore resultStore) {
        Set storedQueryIds = resultStore.getStoredQueryIdsAsJavaSet();
        for (String storedQueryId : storedQueryIds) {
            QueryState queryState = (QueryState)resultStore.get(storedQueryId).get();
            long now = new GregorianCalendar().getTimeInMillis();
            long delta = 1000L;
            long ageOfEntry = now - 1000L - queryState.timestamp();
            this.ageOfEntries.put(storedQueryId, ageOfEntry);
        }
    }

    public final int getNumEntries() {
        return this.numEntries;
    }

    public final Map<String, Long> getAgeOfEntries() {
        return this.ageOfEntries;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ageOfEntries == null ? 0 : this.ageOfEntries.hashCode());
        result = 31 * result + this.numEntries;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheInfo other = (CacheInfo)obj;
        if (this.ageOfEntries == null ? other.ageOfEntries != null : !this.ageOfEntries.equals(other.ageOfEntries)) {
            return false;
        }
        return this.numEntries == other.numEntries;
    }
}

