/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.service;

import javax.xml.datatype.XMLGregorianCalendar;
import net.shrine.aggregation.Aggregator;
import net.shrine.aggregation.DeleteQueryAggregator;
import net.shrine.aggregation.ReadInstanceResultsAggregator;
import net.shrine.aggregation.ReadPdoResponseAggregator;
import net.shrine.aggregation.ReadPreviousQueriesAggregator;
import net.shrine.aggregation.ReadQueryDefinitionAggregator;
import net.shrine.aggregation.RenameQueryAggregator;
import net.shrine.authentication.AuthenticationResult;
import net.shrine.authentication.NotAuthenticatedException;
import net.shrine.authorization.AuthorizationResult;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.BaseShrineRequest;
import net.shrine.protocol.BaseShrineResponse;
import net.shrine.protocol.Credential;
import net.shrine.protocol.DeleteQueryRequest;
import net.shrine.protocol.ErrorResponse;
import net.shrine.protocol.QueryInstance;
import net.shrine.protocol.ReadApprovedQueryTopicsRequest;
import net.shrine.protocol.ReadApprovedQueryTopicsResponse;
import net.shrine.protocol.ReadInstanceResultsRequest;
import net.shrine.protocol.ReadPdoRequest;
import net.shrine.protocol.ReadPreviousQueriesRequest;
import net.shrine.protocol.ReadQueryDefinitionRequest;
import net.shrine.protocol.ReadQueryInstancesRequest;
import net.shrine.protocol.ReadQueryInstancesResponse;
import net.shrine.protocol.RenameQueryRequest;
import net.shrine.protocol.RunQueryRequest;
import net.shrine.service.AbstractShrineService;
import net.shrine.service.AbstractShrineService$;
import net.shrine.util.Util$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class AbstractShrineService$class {
    public static BaseShrineResponse doRunQuery(AbstractShrineService $this, RunQueryRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)$this.runQueryAggregatorFor().apply((Object)request), shouldBroadcast);
    }

    public static BaseShrineResponse doReadQueryDefinition(AbstractShrineService $this, ReadQueryDefinitionRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)new ReadQueryDefinitionAggregator(), shouldBroadcast);
    }

    public static BaseShrineResponse doReadPdo(AbstractShrineService $this, ReadPdoRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)new ReadPdoResponseAggregator(), shouldBroadcast);
    }

    public static BaseShrineResponse doReadInstanceResults(AbstractShrineService $this, ReadInstanceResultsRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)new ReadInstanceResultsAggregator(request.shrineNetworkQueryId(), false), shouldBroadcast);
    }

    public static BaseShrineResponse doReadQueryInstances(AbstractShrineService $this, ReadQueryInstancesRequest request, boolean shouldBroadcast) {
        return (BaseShrineResponse)$this.afterAuthenticating((BaseShrineRequest)request, new Serializable($this, request){
            public static final long serialVersionUID = 0L;
            private final ReadQueryInstancesRequest request$1;

            public final BaseResp apply(AuthenticationResult.Authenticated authResult) {
                XMLGregorianCalendar now = Util$.MODULE$.now();
                long networkQueryId = this.request$1.queryId();
                String username = this.request$1.authn().username();
                String groupId = this.request$1.projectId();
                QueryInstance instance = new QueryInstance(((Object)BoxesRunTime.boxToLong((long)networkQueryId)).toString(), ((Object)BoxesRunTime.boxToLong((long)networkQueryId)).toString(), username, groupId, now, now);
                return (BaseResp)new ReadQueryInstancesResponse(networkQueryId, authResult.username(), groupId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryInstance[]{instance})));
            }
            {
                this.request$1 = request$1;
            }
        });
    }

    public static BaseShrineResponse doReadPreviousQueries(AbstractShrineService $this, ReadPreviousQueriesRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)new ReadPreviousQueriesAggregator(), shouldBroadcast);
    }

    public static BaseShrineResponse doRenameQuery(AbstractShrineService $this, RenameQueryRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)new RenameQueryAggregator(), shouldBroadcast);
    }

    public static BaseShrineResponse doDeleteQuery(AbstractShrineService $this, DeleteQueryRequest request, boolean shouldBroadcast) {
        return $this.doBroadcastQuery((BaseShrineRequest)request, (Aggregator)new DeleteQueryAggregator(), shouldBroadcast);
    }

    public static BaseShrineResponse doReadApprovedQueryTopics(AbstractShrineService $this, ReadApprovedQueryTopicsRequest request, boolean shouldBroadcast) {
        return (BaseShrineResponse)$this.afterAuthenticating((BaseShrineRequest)request, new Serializable($this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractShrineService $outer;
            private final ReadApprovedQueryTopicsRequest request$2;

            public final BaseResp apply(AuthenticationResult.Authenticated x$1) {
                Either either;
                block4: {
                    ErrorResponse errorResponse;
                    block3: {
                        block2: {
                            ErrorResponse errorResponse2;
                            either = this.$outer.authorizationService().readApprovedEntries(this.request$2);
                            if (!(either instanceof Left)) break block2;
                            Left left = (Left)either;
                            errorResponse = errorResponse2 = (ErrorResponse)left.a();
                            break block3;
                        }
                        if (!(either instanceof Right)) break block4;
                        Right right = (Right)either;
                        ReadApprovedQueryTopicsResponse validResponse = (ReadApprovedQueryTopicsResponse)right.b();
                        errorResponse = validResponse;
                    }
                    return (BaseResp)errorResponse;
                }
                throw new MatchError((Object)either);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$2 = request$2;
            }
        });
    }

    public static BaseShrineResponse doBroadcastQuery(AbstractShrineService $this, BaseShrineRequest request, Aggregator aggregator, boolean shouldBroadcast) {
        return (BaseShrineResponse)$this.afterAuthenticating(request, new Serializable($this, request, aggregator, shouldBroadcast){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractShrineService $outer;
            public final BaseShrineRequest request$3;
            public final Aggregator aggregator$1;
            public final boolean shouldBroadcast$1;

            public final BaseResp apply(AuthenticationResult.Authenticated authResult) {
                BaseShrineResponse baseShrineResponse;
                AuthenticationInfo networkAuthn = new AuthenticationInfo(authResult.domain(), authResult.username(), new Credential("", false));
                BaseShrineRequest baseShrineRequest = this.request$3;
                if (baseShrineRequest instanceof RunQueryRequest) {
                    RunQueryRequest runQueryRequest = (RunQueryRequest)baseShrineRequest;
                    baseShrineResponse = (BaseShrineResponse)this.$outer.afterAuditingAndAuthorizing(runQueryRequest, new Serializable(this, networkAuthn){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AbstractShrineService$.anonfun.doBroadcastQuery.1 $outer;
                        private final AuthenticationInfo networkAuthn$1;

                        public final BaseResp apply() {
                            return (BaseResp)AbstractShrineService$class.doSynchronousQuery$1(this.$outer.net$shrine$service$AbstractShrineService$$anonfun$$$outer(), this.networkAuthn$1, this.$outer.request$3, this.$outer.aggregator$1, this.$outer.shouldBroadcast$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.networkAuthn$1 = networkAuthn$1;
                        }
                    });
                } else {
                    baseShrineResponse = AbstractShrineService$class.doSynchronousQuery$1(this.$outer, networkAuthn, this.request$3, this.aggregator$1, this.shouldBroadcast$1);
                }
                return (BaseResp)baseShrineResponse;
            }

            public /* synthetic */ AbstractShrineService net$shrine$service$AbstractShrineService$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$3 = request$3;
                this.aggregator$1 = var3_3;
                this.shouldBroadcast$1 = shouldBroadcast$1;
            }
        });
    }

    public static Object waitFor(AbstractShrineService $this, Future futureResponse) {
        return Util$.MODULE$.time("Waiting for aggregated results", (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractShrineService $outer;

            public final void apply(String x$2) {
                this.$outer.debug((Function0)new Serializable(this, x$2){
                    public static final long serialVersionUID = 0L;
                    private final String x$2$1;

                    public final String apply() {
                        return this.x$2$1;
                    }
                    {
                        this.x$2$1 = x$2$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable($this, futureResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractShrineService $outer;
            private final Future futureResponse$1;

            public final R apply() {
                return (R)Await$.MODULE$.result((Awaitable)this.futureResponse$1, this.$outer.queryTimeout());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.futureResponse$1 = futureResponse$1;
            }
        });
    }

    public static Object afterAuditingAndAuthorizing(AbstractShrineService $this, RunQueryRequest request, Function0 body) {
        return $this.auditTransactionally(request, new Serializable($this, request, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractShrineService $outer;
            private final RunQueryRequest request$4;
            private final Function0 body$1;

            public final T apply() {
                AuthorizationResult authorizationResult = this.$outer.authorizationService().authorizeRunQueryRequest(this.request$4);
                if (authorizationResult instanceof AuthorizationResult.NotAuthorized) {
                    AuthorizationResult.NotAuthorized notAuthorized = (AuthorizationResult.NotAuthorized)authorizationResult;
                    throw notAuthorized.toException();
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (T)this.body$1.apply();
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$4 = request$4;
                this.body$1 = var3_3;
            }
        });
    }

    public static Object auditTransactionally(AbstractShrineService $this, RunQueryRequest request, Function0 body) {
        try {
            return body.apply();
        }
        finally {
            $this.auditDao().addAuditEntry(request.projectId(), request.authn().domain(), request.authn().username(), request.queryDefinition().toI2b2String(), (Option<String>)request.topicId());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object afterAuthenticating(AbstractShrineService $this, BaseShrineRequest request, Function1 f) {
        AuthenticationInfo authenticationInfo = request.authn();
        if (authenticationInfo != null) {
            Tuple2 tuple2;
            String domain = authenticationInfo.domain();
            String username = authenticationInfo.username();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)domain, (Object)username);
            String domain2 = (String)tuple22._1();
            String username2 = (String)tuple22._2();
            AuthenticationResult authResult = $this.authenticator().authenticate(request.authn());
            AuthenticationResult authenticationResult = authResult;
            if (authenticationResult instanceof AuthenticationResult.Authenticated) {
                AuthenticationResult.Authenticated authenticated = (AuthenticationResult.Authenticated)authenticationResult;
                Object object = f.apply((Object)authenticated);
                return object;
            }
            if (authenticationResult instanceof AuthenticationResult.NotAuthenticated) {
                void var9_9;
                void var8_8;
                AuthenticationResult.NotAuthenticated notAuthenticated = (AuthenticationResult.NotAuthenticated)authenticationResult;
                String reason = notAuthenticated.message();
                throw new NotAuthenticatedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", ":", " could not be authenticated: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_8, var9_9, reason})));
            }
            throw new MatchError((Object)authenticationResult);
        }
        throw new MatchError((Object)authenticationInfo);
    }

    public static final BaseShrineResponse doSynchronousQuery$1(AbstractShrineService $this, AuthenticationInfo networkAuthn, BaseShrineRequest request$3, Aggregator aggregator$1, boolean shouldBroadcast$1) {
        return (BaseShrineResponse)$this.waitFor($this.broadcastService().sendAndAggregate(networkAuthn, request$3, aggregator$1, shouldBroadcast$1));
    }

    public static void $init$(AbstractShrineService $this) {
        $this.net$shrine$service$AbstractShrineService$_setter_$runQueryAggregatorFor_$eq((Function1)new AbstractShrineService$.anonfun.1($this));
    }
}

