/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import net.shrine.crypto.KeyStoreCertCollection;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreType;
import net.shrine.protocol.CertId;
import net.shrine.util.Loggable;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class KeyStoreCertCollection$
implements Loggable,
Serializable {
    public static final KeyStoreCertCollection$ MODULE$;
    private final Logger net$shrine$util$Loggable$$internalLogger;
    private volatile boolean bitmap$0;

    static {
        new KeyStoreCertCollection$();
    }

    private Logger net$shrine$util$Loggable$$internalLogger$lzycompute() {
        KeyStoreCertCollection$ keyStoreCertCollection$ = this;
        synchronized (keyStoreCertCollection$) {
            if (!this.bitmap$0) {
                this.net$shrine$util$Loggable$$internalLogger = Loggable.class.net$shrine$util$Loggable$$internalLogger((Loggable)this);
                this.bitmap$0 = true;
            }
            return this.net$shrine$util$Loggable$$internalLogger;
        }
    }

    public Logger net$shrine$util$Loggable$$internalLogger() {
        return this.bitmap$0 ? this.net$shrine$util$Loggable$$internalLogger : this.net$shrine$util$Loggable$$internalLogger$lzycompute();
    }

    public Logger logger() {
        return Loggable.class.logger((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.class.debugEnabled((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.class.infoEnabled((Loggable)this);
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public final void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public final void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public final void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public final void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public KeyStoreCertCollection fromFileRecoverWithClassPath(KeyStoreDescriptor descriptor) {
        return new File(descriptor.file()).exists() ? this.fromFile(descriptor) : this.fromClassPathResource(descriptor);
    }

    public KeyStoreCertCollection fromFile(KeyStoreDescriptor descriptor) {
        Predef$.MODULE$.require(new File(descriptor.file()).exists(), (Function0)new Serializable(descriptor){
            public static final long serialVersionUID = 0L;
            private final KeyStoreDescriptor descriptor$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keystore file '", "' exists? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.descriptor$1.file(), BoxesRunTime.boxToBoolean((boolean)new File(this.descriptor$1.file()).exists())}));
            }
            {
                this.descriptor$1 = descriptor$1;
            }
        });
        return this.fromStream(descriptor, (Function1<String, InputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileInputStream apply(String x$2) {
                return new FileInputStream(x$2);
            }
        });
    }

    public KeyStoreCertCollection fromClassPathResource(KeyStoreDescriptor descriptor) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return this.fromStream(descriptor, (Function1<String, InputStream>)new Serializable(classLoader){
            public static final long serialVersionUID = 0L;
            private final ClassLoader eta$0$1$1;

            public final InputStream apply(String x$1) {
                return this.eta$0$1$1.getResourceAsStream(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public KeyStoreCertCollection fromStream(KeyStoreDescriptor descriptor, Function1<String, InputStream> streamFrom) {
        this.debug((Function0<Object>)new Serializable(descriptor){
            public static final long serialVersionUID = 0L;
            private final KeyStoreDescriptor descriptor$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading keystore using descriptor: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyStoreCertCollection$.MODULE$.net$shrine$crypto$KeyStoreCertCollection$$toString$1(this.descriptor$2)}));
            }
            {
                this.descriptor$2 = descriptor$2;
            }
        });
        InputStream stream = (InputStream)streamFrom.apply((Object)descriptor.file());
        Predef$.MODULE$.require(stream != null, (Function0)new Serializable(descriptor){
            public static final long serialVersionUID = 0L;
            private final KeyStoreDescriptor descriptor$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null stream for descriptor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyStoreCertCollection$.MODULE$.net$shrine$crypto$KeyStoreCertCollection$$toString$1(this.descriptor$2)}));
            }
            {
                this.descriptor$2 = descriptor$2;
            }
        });
        KeyStore keystore = KeyStore.getInstance(descriptor.keyStoreType().name());
        keystore.load(stream, descriptor.password().toCharArray());
        this.debug((Function0<Object>)new Serializable(keystore){
            public static final long serialVersionUID = 0L;
            private final KeyStore keystore$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keystore aliases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.keystore$1.aliases()).asScala()).mkString(",")}));
            }
            {
                this.keystore$1 = keystore$1;
            }
        });
        this.debug((Function0<Object>)new Serializable(descriptor){
            public static final long serialVersionUID = 0L;
            private final KeyStoreDescriptor descriptor$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keystore ", " loaded successfully"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyStoreCertCollection$.MODULE$.net$shrine$crypto$KeyStoreCertCollection$$toString$1(this.descriptor$2)}));
            }
            {
                this.descriptor$2 = descriptor$2;
            }
        });
        return new KeyStoreCertCollection(keystore, descriptor);
    }

    public CertId toCertId(X509Certificate cert) {
        return new CertId(cert.getSerialNumber(), Option$.MODULE$.apply((Object)cert.getSubjectDN().getName()));
    }

    public KeyStoreCertCollection apply(KeyStore keystore, KeyStoreDescriptor descriptor) {
        return new KeyStoreCertCollection(keystore, descriptor);
    }

    public Option<Tuple2<KeyStore, KeyStoreDescriptor>> unapply(KeyStoreCertCollection x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.keystore(), (Object)x$0.descriptor()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final String net$shrine$crypto$KeyStoreCertCollection$$toString$1(KeyStoreDescriptor descriptor) {
        String x$3 = "********";
        String x$4 = descriptor.copy$default$1();
        Option<String> x$5 = descriptor.copy$default$3();
        Seq<String> x$6 = descriptor.copy$default$4();
        KeyStoreType x$7 = descriptor.copy$default$5();
        return ((Object)descriptor.copy(x$4, x$3, x$5, x$6, x$7)).toString();
    }

    private KeyStoreCertCollection$() {
        MODULE$ = this;
        Loggable.class.$init$((Loggable)this);
    }
}

