/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess;

import java.util.Collection;
import java.util.List;
import org.spin.node.dataaccess.DataAccess;
import org.spin.node.dataaccess.DataAccessException;
import org.spin.node.dataaccess.DataSinkException;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.crypto.signature.Identity;

public final class LazyLoadingDataAccess<QueryCriteria, DataType>
implements DataAccess<QueryCriteria, DataType> {
    private DataAccess<QueryCriteria, DataType> delegate;
    private final Class<? extends DataAccess<QueryCriteria, DataType>> dataAccessClass;

    private LazyLoadingDataAccess(Class<? extends DataAccess<QueryCriteria, DataType>> dataAccessClass) {
        this.dataAccessClass = dataAccessClass;
    }

    public List<DataType> get(QueryCriteria queryCriteria, Identity identity) {
        this.initDelegate();
        return this.delegate.get(queryCriteria, identity);
    }

    public void delete(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.delete(data);
    }

    public void save(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.save(data);
    }

    public void update(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.update(data);
    }

    public void saveOrUpdate(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.saveOrUpdate(data);
    }

    public static final <QueryCriteria, DataType> LazyLoadingDataAccess<QueryCriteria, DataType> instance(Class<? extends DataAccess<QueryCriteria, DataType>> dataAccessClass) {
        return new LazyLoadingDataAccess<QueryCriteria, DataType>(dataAccessClass);
    }

    private final synchronized void initDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (DataAccess)ClassTools.createInstance(this.dataAccessClass);
            }
            catch (DynamicLoadingException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }
}

