/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.node.dataaccess.DataAccess;
import org.spin.node.dataaccess.DataSinkException;
import org.spin.node.dataaccess.ibatis.SpinAdminIbatisTool;
import org.spin.node.dataaccess.types.IbatisLogEntry;
import org.spin.node.dataaccess.types.LogEntry;
import org.spin.query.message.criteria.SPINLogCriteria;
import org.spin.tools.crypto.signature.Identity;

public final class LogEntryIbatisDataAccess
implements DataAccess<SPINLogCriteria, IbatisLogEntry> {
    private static final Logger log = Logger.getLogger(LogEntryIbatisDataAccess.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    protected final SqlMapClient sqlMap = SpinAdminIbatisTool.Instance.getSqlMapClient();

    public void save(Collection<?> data) throws DataSinkException {
        this.saveOrUpdate(data);
    }

    public void update(Collection<?> data) throws DataSinkException {
        this.saveOrUpdate(data);
    }

    public void saveOrUpdate(Collection<?> data) throws DataSinkException {
        try {
            this.sqlMap.startTransaction();
            for (Object item : data) {
                LogEntry logEntry = (LogEntry)this.sqlMap.queryForObject("LogEntry.selectLogEntry", item);
                if (logEntry == null) {
                    this.sqlMap.insert("LogEntry.insertLogEntry", item);
                    continue;
                }
                this.sqlMap.update("LogEntry.updateLogEntry", item);
            }
            this.sqlMap.commitTransaction();
        }
        catch (SQLException e) {
            throw new DataSinkException((Throwable)e);
        }
        finally {
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                throw new DataSinkException((Throwable)e);
            }
        }
    }

    public void delete(Collection<?> data) throws DataSinkException {
        try {
            this.sqlMap.startTransaction();
            for (Object item : data) {
                this.sqlMap.delete("LogEntry.deleteLogEntry", item);
            }
            this.sqlMap.commitTransaction();
        }
        catch (SQLException e) {
            throw new DataSinkException((Throwable)e);
        }
        finally {
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                throw new DataSinkException((Throwable)e);
            }
        }
    }

    public final List<IbatisLogEntry> get(SPINLogCriteria criteria, Identity ignored) {
        List logEntries;
        try {
            logEntries = this.sqlMap.queryForList("LogEntry.selectLogEntryList", (Object)criteria);
        }
        catch (SQLException e) {
            throw new DataSinkException((Throwable)e);
        }
        return logEntries;
    }
}

