/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import org.spin.query.message.identity.IdentityService;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.Identity;

public final class Credentials {
    private final String username;
    private final String password;
    private final String domain;
    public static final Credentials Empty = new Credentials();

    private Credentials() {
        this(null, null, null);
    }

    public Credentials(String domain, String username, String password) {
        this.domain = domain;
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public Identity toIdentity(IdentityService identityService) {
        Util.guardNotNull((Object)identityService);
        return identityService.certify(this.domain, this.username, this.password);
    }

    public String toString() {
        return "[domain=" + this.domain + ", password=********, username=" + this.username + "]";
    }
}

