/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.Agent;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.Credentials;
import org.spin.query.message.agent.ResultDecryptor;
import org.spin.query.message.agent.ResultUnpacker;
import org.spin.query.message.agent.Serializers;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.headers.EncryptionParams;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.QueryInput;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import org.xml.sax.SAXException;

public class Querier {
    private static final Logger log = Logger.getLogger(Querier.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    protected final AgentConfig agentConfig;
    protected final Agent agent;
    protected final IdentityService identityService;
    protected final PKCryptor cryptor;

    public Querier(IdentityService identityService) throws ConfigException, NodeException {
        this(ConfigTool.loadAgentConfig(), identityService);
    }

    public Querier(AgentConfig agentConfig, IdentityService identityService) throws ConfigException, NodeException {
        this(agentConfig, identityService, NodeConnector.instance((String)agentConfig.getNodeConnectorEndpoint().getAddress()));
    }

    public Querier(AgentConfig agentConfig, IdentityService identityService, NodeConnector nodeConnector) throws ConfigException {
        if (agentConfig == null) {
            throw new ConfigException("Null AgentConfig passed in.");
        }
        if (identityService == null) {
            throw new ConfigException("Null IdentityService passed in");
        }
        if (nodeConnector == null) {
            throw new ConfigException("Null NodeConnector passed in");
        }
        this.agentConfig = agentConfig;
        this.identityService = identityService;
        this.cryptor = new PKCryptor();
        if (DEBUG) {
            log.debug((Object)"Loaded PKITool");
        }
        this.agent = new Agent(agentConfig, (SpinNode)nodeConnector);
        if (DEBUG) {
            log.debug((Object)"Created agent");
        }
    }

    public Agent getAgent() {
        return this.agent;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public List<String> query(String queryType, Credentials credentials, String conditions) throws AgentException, TimeoutException {
        return this.query(queryType, credentials, conditions, EncryptionParams.encryptFor((CertID)MyCertIDHolder.getMyCertID()));
    }

    public List<String> query(String queryType, Credentials credentials, String conditions, CertID recipient) throws AgentException, TimeoutException {
        Util.guardNotNull((Object)recipient);
        return this.query(queryType, credentials, conditions, EncryptionParams.encryptFor((CertID)recipient));
    }

    public List<String> query(String queryType, Credentials credentials, String conditions, EncryptionParams encryptionRequested) throws AgentException, TimeoutException {
        Util.guardNotNull((Object)encryptionRequested);
        return this.doSynchronousQuery(queryType, credentials, conditions, encryptionRequested);
    }

    public List<String> query(String queryType, Credentials credentials, Object conditions) throws AgentException, TimeoutException {
        return this.query(queryType, credentials, conditions, EncryptionParams.encryptFor((CertID)MyCertIDHolder.getMyCertID()));
    }

    public List<String> query(String queryType, Credentials credentials, Object criteria, EncryptionParams encryptionRequested) throws AgentException, TimeoutException {
        String serializedConditions;
        Util.guardNotNull((Object)encryptionRequested);
        try {
            serializedConditions = Serializers.serializeOnlyJAXBSerializer().toString(criteria);
        }
        catch (SerializationException e) {
            throw new AgentException(e);
        }
        return this.query(queryType, credentials, serializedConditions, encryptionRequested);
    }

    public List<String> query(String queryType, Credentials credentials, Object criteria, CertID recipient) throws AgentException, TimeoutException {
        String serializedConditions;
        Util.guardNotNull((Object)recipient);
        try {
            serializedConditions = Serializers.serializeOnlyJAXBSerializer().toString(criteria);
        }
        catch (SerializationException e) {
            throw new AgentException(e);
        }
        return this.query(queryType, credentials, serializedConditions, EncryptionParams.encryptFor((CertID)recipient));
    }

    private List<String> doSynchronousQuery(String queryType, Credentials credentials, String conditions, EncryptionParams encryptionRequested) throws AgentException, TimeoutException {
        long start = System.currentTimeMillis();
        AckNack ack = null;
        try {
            ack = this.queryAsync(queryType, credentials, conditions, encryptionRequested);
            Identity requestorID = this.identityService.certify(credentials.getDomain(), credentials.getUsername(), credentials.getPassword());
            List<String> list = this.receive(ack, requestorID);
            return list;
        }
        catch (IdentityServiceException e) {
            throw new AgentException(e);
        }
        finally {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            if (INFO && ack != null) {
                log.info((Object)("Query '" + ack.getQueryID() + "' completed in " + elapsed + "ms"));
            }
        }
    }

    public AckNack queryAsync(String queryType, Credentials credentials, Object conditions) throws AgentException {
        return this.queryAsync(queryType, credentials, conditions, MyCertIDHolder.getMyCertID());
    }

    public AckNack queryAsync(String queryType, Credentials credentials, Object conditions, CertID recipient) throws AgentException {
        String serializedConditions;
        Util.guardNotNull((Object)recipient);
        try {
            serializedConditions = Serializers.serializeOnlyJAXBSerializer().toString(conditions);
        }
        catch (SerializationException e) {
            throw new AgentException(e);
        }
        return this.queryAsync(queryType, credentials, serializedConditions, EncryptionParams.encryptFor((CertID)recipient));
    }

    public AckNack queryAsync(String queryType, Credentials credentials, Object conditions, EncryptionParams encryptionParams) throws AgentException {
        String serializedConditions;
        Util.guardNotNull((Object)encryptionParams);
        try {
            serializedConditions = Serializers.serializeOnlyJAXBSerializer().toString(conditions);
        }
        catch (SerializationException e) {
            throw new AgentException(e);
        }
        return this.queryAsync(queryType, credentials, serializedConditions, encryptionParams);
    }

    public AckNack queryAsync(String queryType, Credentials credentials, String conditions) throws AgentException {
        return this.queryAsync(queryType, credentials, conditions, EncryptionParams.encryptFor((CertID)MyCertIDHolder.getMyCertID()));
    }

    public AckNack queryAsync(String queryType, Credentials credentials, String conditions, CertID recipient) throws AgentException {
        Util.guardNotNull((Object)recipient);
        return this.queryAsync(queryType, credentials, conditions, EncryptionParams.encryptFor((CertID)recipient));
    }

    public AckNack queryAsync(String queryType, Credentials credentials, String conditions, EncryptionParams encryptionParams) throws AgentException {
        Util.guardNotNull((Object)encryptionParams);
        try {
            Identity identity = this.identityService.certify(credentials.getDomain(), credentials.getUsername(), credentials.getPassword());
            QueryInfo queryInfo = this.makeQueryInfo(queryType).withIdentity(identity);
            AckNack ack = this.agent.send(queryInfo, QueryInput.of((String)conditions, (EncryptionParams)encryptionParams));
            if (INFO) {
                log.info((Object)("Sent query: " + ack.getQueryID()));
            }
            return ack;
        }
        catch (IdentityServiceException e) {
            throw new AgentException(e);
        }
    }

    public List<String> receive(AckNack ack, Identity requestorID) throws AgentException, TimeoutException {
        if (ack == null) {
            throw new AgentException("Null AckNack!");
        }
        return this.receive(ack.getQueryID(), requestorID);
    }

    public List<String> receive(String queryID, Identity requestorID) throws AgentException, TimeoutException {
        ResultSet results;
        try {
            results = this.agent.receive(queryID, requestorID);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        if (results == null) {
            throw new AgentException("Null result!");
        }
        if (INFO) {
            log.info((Object)"Got results");
        }
        Collection rawResults = results.getResults();
        if (DEBUG) {
            for (Result result : rawResults) {
                log.debug((Object)("  Raw result: " + result));
            }
        }
        ResultDecryptor decryptor = new ResultDecryptor((Cryptor)this.cryptor);
        return ResultUnpacker.unpackResults(decryptor.decryptResults(rawResults));
    }

    public boolean isComplete(String queryID) throws AgentException {
        try {
            return this.agent.isComplete(queryID);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public static <T> List<T> unmarshallResults(List<String> xmlResults, Class<T> resultClass) throws JAXBException, IOException, SAXException {
        ArrayList result = Util.makeArrayList();
        for (String xml : xmlResults) {
            if (xml == null || xml.length() <= 0) continue;
            result.add(JAXBUtils.unmarshal((String)xml, resultClass));
        }
        return result;
    }

    private final QueryInfo makeQueryInfo(String queryType) {
        return new QueryInfo(this.agentConfig.getPeerGroupToQuery(), null, queryType).withAggregator(this.agentConfig.getRootAggregatorEndpoint());
    }

    private static final class MyCertIDHolder {
        private static CertID myCertID = null;

        private MyCertIDHolder() {
        }

        public static final synchronized CertID getMyCertID() throws AgentException {
            if (myCertID == null) {
                try {
                    myCertID = PKITool.getInstance().getMyCertID();
                }
                catch (ConfigException e) {
                    throw new AgentException("Error determining the Querier's private key", e);
                }
            }
            return myCertID;
        }
    }
}

