/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.AbstractDynamicMBean;
import org.apache.log4j.jmx.LayoutDynamicMBean;
import org.apache.log4j.jmx.MethodUnion;
import org.apache.log4j.spi.OptionHandler;

public class AppenderDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private Hashtable dynamicProps = new Hashtable(5);
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[2];
    private String dDescription = "This MBean acts as a management facade for log4j appenders.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$AppenderDynamicMBean != null ? class$org$apache$log4j$jmx$AppenderDynamicMBean : (class$org$apache$log4j$jmx$AppenderDynamicMBean = AppenderDynamicMBean.class$("org.apache.log4j.jmx.AppenderDynamicMBean")));
    private Appender appender;
    static /* synthetic */ Class class$org$apache$log4j$jmx$AppenderDynamicMBean;
    static /* synthetic */ Class class$org$apache$log4j$Priority;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public AppenderDynamicMBean(Appender appender) throws IntrospectionException {
        this.appender = appender;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() throws IntrospectionException {
        MBeanParameterInfo[] mBeanParameterInfoArray;
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("AppenderDynamicMBean(): Constructs a AppenderDynamicMBean instance", constructorArray[0]);
        BeanInfo beanInfo = Introspector.getBeanInfo(this.appender.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz;
            mBeanParameterInfoArray = propertyDescriptorArray[n2].getName();
            Method method = propertyDescriptorArray[n2].getReadMethod();
            Method method2 = propertyDescriptorArray[n2].getWriteMethod();
            if (method != null && this.isSupportedType(clazz = method.getReturnType())) {
                String string = clazz.isAssignableFrom(class$org$apache$log4j$Priority != null ? class$org$apache$log4j$Priority : AppenderDynamicMBean.class$("org.apache.log4j.Priority")) ? "java.lang.String" : clazz.getName();
                this.dAttributes.add(new MBeanAttributeInfo((String)mBeanParameterInfoArray, string, "Dynamic", true, method2 != null, false));
                this.dynamicProps.put(mBeanParameterInfoArray, new MethodUnion(method, method2));
            }
            ++n2;
        }
        mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        this.dOperations[0] = new MBeanOperationInfo("activateOptions", "activateOptions(): add an appender", mBeanParameterInfoArray, "void", 1);
        mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("layout class", "java.lang.String", "layout class")};
        this.dOperations[1] = new MBeanOperationInfo("setLayout", "setLayout(): add a layout", mBeanParameterInfoArray, "void", 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MethodUnion methodUnion;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        cat.debug("getAttribute called with [" + string + "].");
        if (string.startsWith("appender=" + this.appender.getName() + ",layout")) {
            try {
                return new ObjectName("log4j:" + string);
            }
            catch (Exception exception) {
                cat.error("attributeName", exception);
            }
        }
        if ((methodUnion = (MethodUnion)this.dynamicProps.get(string)) != null && methodUnion.readMethod != null) {
            try {
                return methodUnion.readMethod.invoke((Object)this.appender, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute in " + this.dClassName);
    }

    protected Logger getLogger() {
        return cat;
    }

    public MBeanInfo getMBeanInfo() {
        cat.debug("getMBeanInfo called.");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string.equals("activateOptions") && this.appender instanceof OptionHandler) {
            OptionHandler optionHandler = (OptionHandler)((Object)this.appender);
            optionHandler.activateOptions();
            return "Options activated.";
        }
        if (string.equals("setLayout")) {
            Layout layout = (Layout)OptionConverter.instantiateByClassName((String)objectArray[0], class$org$apache$log4j$Layout != null ? class$org$apache$log4j$Layout : (class$org$apache$log4j$Layout = AppenderDynamicMBean.class$("org.apache.log4j.Layout")), null);
            this.appender.setLayout(layout);
            this.registerLayoutMBean(layout);
        }
        return null;
    }

    private boolean isSupportedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AppenderDynamicMBean.class$("java.lang.String")))) {
            return true;
        }
        return clazz.isAssignableFrom(class$org$apache$log4j$Priority != null ? class$org$apache$log4j$Priority : (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.apache.log4j.Priority")));
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        cat.debug("preRegister called. Server=" + mBeanServer + ", name=" + objectName);
        this.server = mBeanServer;
        this.registerLayoutMBean(this.appender.getLayout());
        return objectName;
    }

    void registerLayoutMBean(Layout layout) {
        if (layout == null) {
            return;
        }
        String string = String.valueOf(this.appender.getName()) + ",layout=" + layout.getClass().getName();
        cat.debug("Adding LayoutMBean:" + string);
        ObjectName objectName = null;
        try {
            LayoutDynamicMBean layoutDynamicMBean = new LayoutDynamicMBean(layout);
            objectName = new ObjectName("log4j:appender=" + string);
            this.server.registerMBean(layoutDynamicMBean, objectName);
            this.dAttributes.add(new MBeanAttributeInfo("appender=" + string, "javax.management.ObjectName", "The " + string + " layout.", true, true, false));
        }
        catch (Exception exception) {
            cat.error("Could not add DynamicLayoutMBean for [" + string + "].", exception);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        MethodUnion methodUnion = (MethodUnion)this.dynamicProps.get(string);
        if (methodUnion != null && methodUnion.writeMethod != null) {
            Object[] objectArray = new Object[1];
            Class<?>[] classArray = methodUnion.writeMethod.getParameterTypes();
            if (classArray[0] == (class$org$apache$log4j$Priority != null ? class$org$apache$log4j$Priority : (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.apache.log4j.Priority")))) {
                object = OptionConverter.toLevel((String)object, (Level)this.getAttribute(string));
            }
            objectArray[0] = object;
            try {
                methodUnion.writeMethod.invoke((Object)this.appender, objectArray);
            }
            catch (Exception exception) {
                cat.error("FIXME", exception);
            }
        } else if (!string.endsWith(".layout")) {
            throw new AttributeNotFoundException("Attribute " + string + " not found in " + this.getClass().getName());
        }
    }
}

