/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.query;

import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.util.Iterator;
import java.util.List;
import net.shrine.config.AdapterMappings;
import net.shrine.serializers.crc.QueryDefBuilder;
import net.shrine.utilities.query.QueryDefIterator;
import org.apache.log4j.Logger;
import org.spin.tools.config.ConfigException;

public class AdapterMappingsIterator
extends QueryDefIterator {
    public static final Logger log = Logger.getLogger(AdapterMappingsIterator.class);
    AdapterMappings mappings;
    boolean translate;
    private Iterator<String> iterator;

    public AdapterMappingsIterator(String adapterMappingsFile, boolean translate) throws ConfigException {
        log.info((Object)("AdapterMappingsIterator init, translate = " + translate + "  file=" + adapterMappingsFile));
        this.mappings = AdapterMappings.loadFromFile((String)adapterMappingsFile);
        this.translate = translate;
        this.iterator = this.mappings.getEntries().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public QueryDefinitionType next() {
        String global = this.iterator.next();
        if (this.translate) {
            ItemType[] items = QueryDefBuilder.getItems((List)this.mappings.getMappings(global));
            return QueryDefBuilder.getQueryDefinition((ItemType[])items);
        }
        return QueryDefBuilder.getQueryDefinition((String[])new String[]{global});
    }
}

