/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.query;

import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import net.shrine.serializers.crc.QueryDefBuilder;
import net.shrine.utilities.query.QueryDefIterator;
import net.shrine.utilities.query.ShortHandNotation;
import org.spin.tools.Util;

public class FlatFileIterator
extends QueryDefIterator {
    public static String COMMENT_LINE = "#";
    File file;
    BufferedReader reader;
    ShortHandNotation current = null;

    public FlatFileIterator(File file) throws FileNotFoundException {
        this.file = file;
        this.reader = new BufferedReader(new FileReader(file));
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.ready() && this.current != ShortHandNotation.end;
        }
        catch (Exception e) {
            log.error((Object)"Could not determine if Flat File has more Query Items", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QueryDefinitionType next() {
        QueryDefinitionType definition = null;
        ArrayList itemKeys = Util.makeArrayList();
        ArrayList panels = Util.makeArrayList();
        try {
            block6: while (this.hasNext() && definition == null) {
                String lineNext = this.reader.readLine();
                log.debug((Object)("CURRENT:" + lineNext));
                if (lineNext.startsWith(COMMENT_LINE)) {
                    System.out.println(COMMENT_LINE);
                    continue;
                }
                if (ShortHandNotation.isNotation(lineNext)) {
                    this.current = ShortHandNotation.parse(lineNext);
                    if (itemKeys.size() > 0) {
                        panels.add(QueryDefBuilder.getPanel((List)itemKeys));
                        itemKeys.clear();
                    }
                    if (this.current == ShortHandNotation.panel || panels.size() <= 0) continue;
                    log.debug((Object)"Returning buffer of panels within query definition.");
                    definition = QueryDefBuilder.getQueryDefinition((List)panels);
                    panels.clear();
                    continue;
                }
                if (lineNext.length() <= 0) continue;
                switch (this.current) {
                    case name: {
                        definition.setQueryName(lineNext);
                        continue block6;
                    }
                    case panel: {
                        itemKeys.add(QueryDefBuilder.getItem((String)lineNext));
                        continue block6;
                    }
                }
                log.debug((Object)("Annotation not yet supported: " + this.current.print()));
            }
            return definition;
        }
        catch (Exception e) {
            log.error((Object)"Could not read next query definition", (Throwable)e);
        }
        return definition;
    }
}

