/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.spin.query.message.cache.ResultStore;
import org.spin.query.message.cache.RootResponseNode;
import org.spin.tools.RandomTool;
import org.spin.tools.Util;

public final class EhcacheMemoryResultStore
implements ResultStore {
    private final CacheManager cacheManager;
    private final Cache responseNodes;
    private final String cacheName = "responseNodes" + RandomTool.randomString();

    public EhcacheMemoryResultStore() {
        this.cacheManager = CacheManager.create();
        this.cacheManager.addCache(this.cacheName);
        this.responseNodes = this.cacheManager.getCache(this.cacheName);
    }

    @Override
    public RootResponseNode get(String queryID) {
        Element element = this.responseNodes.get((Serializable)((Object)queryID));
        if (element == null) {
            return null;
        }
        return (RootResponseNode)element.getObjectValue();
    }

    @Override
    public void put(String queryID, RootResponseNode result) {
        this.responseNodes.put(new Element((Object)queryID, (Object)result));
    }

    @Override
    public boolean containsQueryID(String queryID) {
        return this.responseNodes.isKeyInCache((Object)queryID);
    }

    @Override
    public Set<String> getStoredQueryIDs() {
        return Util.asSet((Collection)this.responseNodes.getKeys());
    }

    @Override
    public void remove(String queryID) {
        this.responseNodes.remove((Serializable)((Object)queryID));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.responseNodes.getSize();
    }

    @Override
    public void shutDownCache() {
        this.cacheManager.removeCache(this.cacheName);
        if (this.cacheManager.getCacheNames().length == 0) {
            this.cacheManager.shutdown();
        }
    }

    @Override
    public boolean isCacheShutDown() {
        return this.responseNodes.getStatus() == Status.STATUS_SHUTDOWN || this.cacheManager.getStatus() == Status.STATUS_SHUTDOWN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheManager == null ? 0 : this.cacheManager.hashCode());
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        result = 31 * result + (this.responseNodes == null ? 0 : this.responseNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EhcacheMemoryResultStore other = (EhcacheMemoryResultStore)obj;
        if (this.cacheManager == null ? other.cacheManager != null : !this.cacheManager.equals(other.cacheManager)) {
            return false;
        }
        if (this.cacheName == null ? other.cacheName != null : !this.cacheName.equals(other.cacheName)) {
            return false;
        }
        return !(this.responseNodes == null ? other.responseNodes != null : !this.responseNodes.equals((Object)other.responseNodes));
    }
}

