/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.identity.local;

import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.identity.local.Hasher;
import org.spin.tools.crypto.signature.Identity;

public final class LocalAuthEntry {
    private final String hashedPassword;
    private final Identity identity;

    public LocalAuthEntry(String domain, String username, String password, String role) throws IdentityServiceException {
        this(new Identity(domain, username, Arrays.asList(role)), password);
    }

    public LocalAuthEntry(Identity identity, String password) throws IdentityServiceException {
        this.hashedPassword = Hasher.hash(identity, password);
        this.identity = identity;
    }

    @Deprecated
    public String getPassword() {
        return this.getHashedPassword();
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public boolean hasPassword(String password) throws IdentityServiceException {
        return this.hashedPassword.equals(Hasher.hash(this.identity, password));
    }

    @Deprecated
    public List<String> getAssertion() {
        return this.getAssertions();
    }

    public List<String> getAssertions() {
        return this.identity.getAssertion();
    }

    public String getDomain() {
        return this.identity.getDomain();
    }

    public XMLGregorianCalendar getTimestamp() {
        return this.identity.getTimestamp();
    }

    public String getUsername() {
        return this.identity.getUsername();
    }
}

